/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util3D;
import ventus.EntryPoint;
import ventus.EntryPointFactory;
import ventus.EntryPointHelper;
import ventus.Intl;
import ventus.actions.copypaste.DefaultPasteHandler;
import ventus.data.IMerlinObj;
import ventus.data.schematics.SimError;
import ventus.feature.Feature;
import ventus.feature.comps.DefaultCompositeDataModel;
import ventus.feature.comps.FeatureUtil;
import ventus.feature.comps.ISelectionRibbon;
import ventus.feature.flowpaths.DebugOp;
import ventus.feature.flowpaths.EditFlowElementOp;
import ventus.feature.flowpaths.EditFlowElementsMgrOp;
import ventus.feature.flowpaths.FindShaftOp;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowElementData;
import ventus.feature.flowpaths.FlowElementDependencies;
import ventus.feature.flowpaths.FlowElementOISHandler;
import ventus.feature.flowpaths.FlowElementPrjWriter;
import ventus.feature.flowpaths.FlowElementRoot;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathDependencies;
import ventus.feature.flowpaths.FlowPathFlowElemDeleteHandler;
import ventus.feature.flowpaths.FlowPathOISHandler;
import ventus.feature.flowpaths.FlowPathPrjWriter;
import ventus.feature.flowpaths.FlowPathRibbon;
import ventus.feature.flowpaths.FlowPathRoot;
import ventus.feature.flowpaths.FlowPathSceneItem;
import ventus.feature.flowpaths.FlowPathWindProfDeleteHandler;
import ventus.feature.flowpaths.NewFlowPath1Pt;
import ventus.feature.flowpaths.NewFlowPath2Pt;
import ventus.gui.guiUtil;

public class FlowPathsFeature {
    public static final String GUID = "flowpaths.data";
    public static final int SEQ_IX = 47;
    public static final ImageIcon ICON = guiUtil.loadIconSvg(FeatureUtil.getRequiredResource(FlowPath.class, "icons/route.svg"), 16);
    private static final double WALL_NORMAL_TOLERANCE = Util3D.toParallelTol(Math.toRadians(1.0));

    public static Feature create() {
        DefaultCompositeDataModel<FlowPathRoot, FlowPath> pathData = new DefaultCompositeDataModel<FlowPathRoot, FlowPath>(() -> new FlowPathRoot(), GUID, 47);
        pathData.addDefaultRootEP(FlowPathRoot.class, ICON);
        pathData.addDefaultNodeEP(FlowPathRoot.FlowPathNode.class, ICON, Intl.intl("Flow_Path_Group"));
        EntryPointHelper<FlowPath> flowpathEp = pathData.addDefaultObjectEP(FlowPath.class, ICON, Intl.intl("Flow_Path"));
        flowpathEp.getNameGroup = EntryPointFactory.nameGroup(vd -> ((FlowPathRoot)vd.getComponentData(GUID)).flatten(FlowPath.class));
        EntryPointHelper<FlowPath> fpHelper = new EntryPointHelper<FlowPath>(FlowPath.class);
        EntryPoint.Getter<FlowPath, Collection> invalidErr = (vd, fp) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            if (fp.isInvalid()) {
                String error = String.format(Intl.intl("%s is not connected to any zones."), fp.getName());
                String fix = Intl.intl("Delete Flow Path or re-attach to a surface.");
                errors.add(new SimError(SimError.Level.CRITICAL, error, fix, (IMerlinObj)fp));
            }
            return errors;
        };
        fpHelper.getErrors = (vd, fp) -> {
            Vector3d norm2;
            Vector3d norm1;
            ArrayList<SimError> errors = new ArrayList<SimError>();
            if (!fp.get(FlowPath.OVERWRITE_MULTIPLIER).booleanValue() && fp.get(FlowPath.START_COMP) != null && fp.get(FlowPath.END_COMP) != null && fp.get(FlowPath.START_COMP) != fp.get(FlowPath.END_COMP) && fp.get(FlowPath.START_WALL) != null && fp.get(FlowPath.END_WALL) != null && !Util3D.testParallel(norm1 = fp.get(FlowPath.START_NORMAL), norm2 = fp.get(FlowPath.END_NORMAL), WALL_NORMAL_TOLERANCE)) {
                errors.add(new SimError(SimError.Level.MODERATE, "<html>" + Intl.intl("The flow path connects non-parallel walls. The calculated flow area might not match the desired value.<p>Manually enter the <b>Area</b> in the property panel."), "<html>" + Intl.intl("Specify a <b>Multiplier</b> for the flow path."), (IMerlinObj)fp));
            }
            errors.addAll((Collection)invalidErr.get(vd, (FlowPath)fp));
            return errors;
        };
        fpHelper.getRuntimeErrors = (vd, fp) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            Collection<FlowPath> conflicts = fp.getConflicts();
            if (conflicts.size() != 0) {
                ArrayList<FlowPath> objs = new ArrayList<FlowPath>(conflicts.size() + 1);
                objs.add((FlowPath)fp);
                objs.addAll(conflicts);
                String error = String.format(Intl.intl("%s has possible conflicts with Flow Paths of the same type."), fp.getName());
                String fix = Intl.intl("Delete or move the conflicting Flow Paths.");
                errors.add(new SimError(SimError.Level.MODERATE, error, fix, objs));
            }
            errors.addAll((Collection)invalidErr.get(vd, (FlowPath)fp));
            return errors;
        };
        fpHelper.register();
        FlowElementData elementData = new FlowElementData();
        FlowPathPrjWriter pathWriter = new FlowPathPrjWriter();
        FlowElementPrjWriter elementWriter = new FlowElementPrjWriter();
        EditFlowElementOp editFlowElemOp = new EditFlowElementOp();
        FindShaftOp shaftSearchOp = new FindShaftOp();
        ISelectionRibbon elemRibbon = ISelectionRibbon.newDefaultSelectionRibbon(FlowElement.class, editFlowElemOp.uiHook);
        FlowPathRibbon ribbonItem = new FlowPathRibbon();
        FlowPathSceneItem sceneItem = new FlowPathSceneItem();
        NewFlowPath1Pt tool1Pt = new NewFlowPath1Pt();
        NewFlowPath2Pt tool2Pt = new NewFlowPath2Pt();
        DefaultPasteHandler pathsPasteHandler = new DefaultPasteHandler(FlowPathRoot.class);
        DefaultPasteHandler elementsPasteHandler = new DefaultPasteHandler(FlowElementRoot.class);
        return new Feature(pathData, elementData, pathWriter, elementWriter, ribbonItem, elemRibbon, sceneItem, tool1Pt, tool2Pt, pathsPasteHandler, elementsPasteHandler, editFlowElemOp, shaftSearchOp, new EditFlowElementsMgrOp(), new FlowPathWindProfDeleteHandler(), new FlowPathFlowElemDeleteHandler(), new FlowPathDependencies(), new DebugOp(), new FlowElementOISHandler(), new FlowPathOISHandler(), new FlowElementDependencies());
    }
}

