/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.LineSegRTreeTest;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.NmtUtil;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Pair;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.RoomUtil;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowPath;
import ventus.geom.GeomUtil;
import ventus.geom.Geometry;

public class FlowPathUtil {
    public static final int[] GROUPS_0 = new int[]{0};

    public static boolean shareLevel(ISchematicRoom r1, ISchematicRoom r2) {
        Floor floor1 = FlowPathUtil.getLevel(r1);
        Floor floor2 = FlowPathUtil.getLevel(r2);
        if (floor1 == null || floor2 == null) {
            return false;
        }
        return floor1.equals(floor2);
    }

    public static boolean isOnLevel(ISchematicRoom r1, Floor level) {
        Floor toCheck = FlowPathUtil.getLevel(r1);
        if (toCheck == null || level == null) {
            return false;
        }
        return toCheck.equals(level);
    }

    public static Floor getLevel(ISchematicRoom obj) {
        if (obj == null) {
            return null;
        }
        return obj.getLevel();
    }

    public static Floor getLevel(int index) {
        if (index < 0) {
            return null;
        }
        VentusData md = Objects.requireNonNull(VentusApp.getAppData());
        for (Floor floor : md.floors.flatten(Floor.class)) {
            if (md.floors.indexOf(floor) != index) continue;
            return floor;
        }
        return null;
    }

    public static void findWallsBetweenPoints(VentusData vd, Point3d p1, Point3d p2, BiPredicate<ISchematicRoom, ISchematicRoom.IWallComponent> filter, BiConsumer<? super ISchematicRoom, ? super ISchematicRoom.IWallComponent> walls) {
        Vector3d lineDir = Util3D.vector(p1, p2);
        double lineLen = Util3D.safeNormalize(lineDir, 1.0E-9);
        if (lineLen == 0.0) {
            return;
        }
        VentusData md = Objects.requireNonNull(VentusApp.getAppData());
        LineSegRTreeTest test = new LineSegRTreeTest(p1, p2);
        md.geomLocation.getLocator().find(new LineSegRTreeTest(p1, p2), ISchematicRoom.class, r -> r.getType().hasWalls, 1, room -> room.getGeom().find(test, (fprim, ctmt) -> {
            Optional<ISchematicRoom.IWallComponent> wall = RoomUtil.getWall(fprim.elements);
            if (wall.isEmpty()) {
                return;
            }
            if (!filter.test((ISchematicRoom)room, wall.get())) {
                return;
            }
            IPolygon poly = wall.get().toPoly((ISchematicRoom)room);
            Plane3d plane = poly.getPlaneIfValid(true);
            if (plane == null) {
                return;
            }
            Point3d isect = PolyUtil.isectPolyRay(poly, plane, p1, lineDir, lineLen);
            if (isect != null) {
                walls.accept((ISchematicRoom)room, wall.get());
            }
        }));
    }

    public static double clampRelativeElevation(double elevation, Floor level) {
        if (level == null) {
            return elevation;
        }
        double floorHeight = level.getHeight().get(Geometry.LENGTH_UNIT);
        return Util.clampT(elevation, 0.01 * floorHeight, 0.99 * floorHeight);
    }

    public static List<FlowPath> getFlowPaths(ISchematicRoom comp, ISchematicRoom.IWallComponent wall) {
        ArrayList<FlowPath> result = new ArrayList<FlowPath>();
        for (FlowPath path : comp.getConnections(FlowPath.class)) {
            FlowPath.Connection props = path.getConnection(comp);
            assert (props != null);
            if (props == null || !wall.equals(path.get(props.wall))) continue;
            result.add(path);
        }
        return result;
    }

    public static LineSeg sliceInterWall(IPolygon slice, ISchematicRoom room, ISchematicRoom.IWallComponent wall) {
        Pair<Model, Face> nmt = wall.toNmt(room, true);
        Model model = (Model)nmt.v1;
        model.getFaces().forEach(f -> {
            f.groups = GROUPS_0;
        });
        model.getEdges().forEach(e -> {
            e.groups = GROUPS_0;
        });
        model.getVerts().forEach(v -> {
            v.groups = GROUPS_0;
        });
        model.addPolygonFace(1, slice.getPlane(true), PolyUtil.getLoop(slice, 0, false));
        return model.getEdges(e -> e.partOfGroup(0) && e.partOfGroup(1)).stream().max((e1, e2) -> Double.compare(e1.curve.length(), e2.curve.length())).map(e -> new LineSeg(e.v1.loc, e.v2.loc)).orElse(null);
    }

    public static double absMax(double ... vals) {
        double max = Math.abs(vals[0]);
        for (int i = 1; i < vals.length; ++i) {
            if (!(Math.abs(vals[i]) > max)) continue;
            max = Math.abs(vals[i]);
        }
        return max;
    }

    public static Face transformFace(Face original, Matrix4d xform) {
        ArrayList<IParametric3D> boundary = new ArrayList<IParametric3D>();
        IdentityHashSet closedEdges = new IdentityHashSet();
        for (FaceLoop loop : original.edgeLoops) {
            if (loop.vert != null) continue;
            for (EdgeUse eu : loop.edges) {
                if (!closedEdges.add(eu.edge)) continue;
                boundary.add(eu.edge.curve.transform(xform));
            }
        }
        Model m = new Model();
        m.addFace(original.plane.transformBy(xform), boundary, 0);
        return m.getFaces().stream().findFirst().orElse(null);
    }

    public static Vector3d multiply(Vector3d a, Vector3d b) {
        return new Vector3d(a.x * b.x, a.y * b.y, a.z * b.z);
    }

    public static List<Model> extrudeModel(Model m0, Function<Face, Vector3d> getExtrudeVec) {
        ArrayList<Model> result = new ArrayList<Model>(m0.getFaces().size());
        for (Face face : m0.getFaces()) {
            Model model = new Model();
            Vector3d extV = getExtrudeVec.apply(face);
            TransformInfo bottomInfo = TransformUtil.translate(-extV.x, -extV.y, -extV.z).getInfo();
            TransformInfo topInfo = TransformUtil.translate(extV.x, extV.y, extV.z).getInfo();
            Face bottomFace = FlowPathUtil.transformFace(face, bottomInfo.getMatrix());
            Face topFace = FlowPathUtil.transformFace(face, topInfo.getMatrix());
            if (bottomFace == null || topFace == null) continue;
            model.addFace(bottomFace, 0);
            model.addFace(topFace, 0);
            for (FaceLoop edgeLoop : face.edgeLoops) {
                for (EdgeUse edgeUse : edgeLoop.edges) {
                    if (!face.isInternalEdge(edgeUse.edge) && edgeUse.edge.faces.size() != 1) continue;
                    Point3d p1 = Util3D.sub(edgeUse.v1().loc, (Tuple3d)extV);
                    Point3d p2 = Util3D.sub(edgeUse.v2().loc, (Tuple3d)extV);
                    Point3d p3 = Util3D.add(edgeUse.v2().loc, (Tuple3d)extV);
                    Point3d p4 = Util3D.add(edgeUse.v1().loc, (Tuple3d)extV);
                    LineSeg3D ls1 = new LineSeg3D(p1, p2);
                    LineSeg3D ls2 = new LineSeg3D(p2, p3);
                    LineSeg3D ls3 = new LineSeg3D(p3, p4);
                    LineSeg3D ls4 = new LineSeg3D(p4, p1);
                    model.addFace(0, new Plane3d(true, p1, p2, p3, p4), Arrays.asList(ls1, ls2, ls3, ls4));
                }
            }
            result.add(model);
        }
        return result;
    }

    public static double pointDistance(Point3d p1, Point3d p2) {
        return Math.sqrt(Math.pow(p2.x - p1.x, 2.0) + Math.pow(p2.y - p1.y, 2.0) + Math.pow(p2.z - p1.z, 2.0));
    }

    public static double modelDistance(Model m1, Model m2) {
        AABox b1 = m1.getBoundingBox();
        AABox b2 = m2.getBoundingBox();
        double mmDist = FlowPathUtil.pointDistance(b1.getMin(), b2.getMin());
        double mMDist = FlowPathUtil.pointDistance(b1.getMin(), b2.getMax());
        double MmDist = FlowPathUtil.pointDistance(b1.getMax(), b2.getMin());
        double MMDist = FlowPathUtil.pointDistance(b1.getMax(), b2.getMax());
        return FlowPathUtil.absMax(mmDist, MMDist, mMDist, MmDist);
    }

    public static List<Model> extrudeModelsTowards(Model toward, List<Model> models, Vector3d extrudeDir) {
        if (toward == null || models.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Model> extrudedModels = new ArrayList<Model>();
        for (Model m : models) {
            Function<Face, Vector3d> getExtrusion;
            double dist = Math.abs(FlowPathUtil.modelDistance(toward, m));
            if (extrudeDir != null) {
                Vector3d vec = Util3D.scale(extrudeDir, dist);
                getExtrusion = f -> vec;
            } else {
                getExtrusion = f -> Util3D.scale(f.plane.getNormal(), dist);
            }
            extrudedModels.addAll(FlowPathUtil.extrudeModel(m, getExtrusion));
        }
        return extrudedModels;
    }

    public static Pair<Double, IGeom> getAreaInfo(Model m0, List<Model> models, Point3d loc, Vector3d projectionDir) {
        Face resultFace = FlowPathUtil.getFaceForLengthandAreaCalc(m0, models, loc, projectionDir);
        if (resultFace == null) {
            return new Pair<Double, IGeom>(0.0, EmptyGeom.INSTANCE);
        }
        return new Pair<Double, IGeom>(resultFace.getArea(), resultFace.toGeomFace());
    }

    public static Pair<Double, IGeom> getLengthInfo(Model m0, List<Model> models, Point3d loc, Vector3d projectionDir) {
        Face resultFace = FlowPathUtil.getFaceForLengthandAreaCalc(m0, models, loc, projectionDir);
        if (resultFace == null) {
            return new Pair<Double, IGeom>(0.0, EmptyGeom.INSTANCE);
        }
        AABox bounds = resultFace.getBounds();
        double midZ = (bounds.getMinZ() + bounds.getMaxZ()) * 0.5;
        LineSeg ls = new LineSeg(new Point3d(bounds.getMinX(), bounds.getMinY(), midZ), new Point3d(bounds.getMaxX(), bounds.getMaxY(), midZ));
        return new Pair<Double, IGeom>(ls.length(), ls);
    }

    private static Face getFaceForLengthandAreaCalc(Model m0, List<Model> models, Point3d loc, Vector3d projectionDir) {
        Collection<Face> touchingFaces;
        if (models.isEmpty()) {
            return loc != null ? m0.findFace(loc) : (Face)m0.getFaces().stream().max((f1, f2) -> Double.compare(f1.getArea(), f2.getArea())).orElse(null);
        }
        List<Model> extModels = FlowPathUtil.extrudeModelsTowards(m0, models, projectionDir);
        Model collModel = m0.clone();
        int[] id1 = new int[]{1};
        collModel.getFaces().forEach(f -> {
            f.groups = id1;
        });
        AABox m0Bounds = m0.getBoundingBox();
        for (Model extModel : extModels) {
            AABox extBounds = extModel.getBoundingBox();
            if (!m0Bounds.intersects(extBounds, 1.0E-6)) continue;
            for (Face face2 : extModel.getFaces()) {
                collModel.addFace(face2, 0);
            }
        }
        if (loc == null) {
            touchingFaces = collModel.getFaces(1);
        } else {
            touchingFaces = new ArrayList<Face>();
            collModel.findFaces(loc, NmtUtil.acceptPointsOnFace(), (face, fc) -> {
                if (face.partOfGroup(1)) {
                    touchingFaces.add((Face)face);
                }
            });
        }
        if (touchingFaces.isEmpty()) {
            return null;
        }
        IdentityHashMap faceInExtrusion = new IdentityHashMap();
        Function<Face, Boolean> testFaceInExtrusion = face -> {
            Point3d testPoint = collModel.findPointInFace((Face)face);
            if (testPoint == null) {
                return false;
            }
            return extModels.stream().anyMatch(m -> m.contains(testPoint));
        };
        Face resultFace = touchingFaces.stream().max((f1, f2) -> {
            boolean inExtrusion2;
            boolean inExtrusion1 = (Boolean)faceInExtrusion.computeIfAbsent(f1, testFaceInExtrusion);
            if (inExtrusion1 != (inExtrusion2 = ((Boolean)faceInExtrusion.computeIfAbsent(f2, testFaceInExtrusion)).booleanValue())) {
                if (inExtrusion1) {
                    return 1;
                }
                return -1;
            }
            double area1 = f1.getArea();
            double area2 = f2.getArea();
            return Double.compare(area1, area2);
        }).get();
        return resultFace;
    }

    public static boolean isDirectlyBelow(ISchematicRoom room1, ISchematicRoom room2) {
        Floor floor1 = FlowPathUtil.getLevel(room1);
        if (floor1 == null) {
            return false;
        }
        Floor floor2 = FlowPathUtil.getLevel(room2);
        if (floor2 == null) {
            return false;
        }
        VentusData md = Objects.requireNonNull((VentusData)room1.getDomain());
        int i1 = md.floors.indexOf(floor1);
        int i2 = md.floors.indexOf(floor2);
        return i1 >= 0 && i2 >= 0 && i2 == i1 - 1;
    }

    public static ISchematicRoom getRoomBelow(ISchematicRoom room1, Point3d point1) {
        VentusData md = Objects.requireNonNull(VentusApp.getAppData());
        Collection<GeomUtil.FindResult> rooms = GeomUtil.findRooms(md, () -> {}, point1, Util3D.VEC3D_ZNEG, Double.MAX_VALUE, 1, (r, c) -> r != room1 && !(c instanceof ISchematicRoom.IWallComponent) && FlowPathUtil.isDirectlyBelow(room1, r));
        if (rooms.isEmpty()) {
            return null;
        }
        ISchematicRoom first = rooms.iterator().next().room;
        return first.getType() == ISchematicRoom.Type.ZONE ? first : null;
    }

    public static List<ISchematicRoom> getRoomsBelow(ISchematicRoom room1) {
        VentusData md = Objects.requireNonNull(VentusApp.getAppData());
        Point3d pMin = room1.getBounds().getMin();
        Point3d pMax = room1.getBounds().getMax();
        Floor floor1 = FlowPathUtil.getLevel(room1);
        if (floor1 == null) {
            return Collections.emptyList();
        }
        int i1 = md.floors.indexOf(floor1);
        Floor floor2 = FlowPathUtil.getLevel(i1 - 1);
        if (floor2 == null) {
            return Collections.emptyList();
        }
        pMin.z = floor2.getWorkingZ().get(Geometry.LENGTH_UNIT);
        return new ArrayList<ISchematicRoom>(md.geomLocation.getLocator().find((ITest<AABox>)new AABox(pMin, pMax), SchematicRoom.class, r -> room1 != r && r.getType() == ISchematicRoom.Type.ZONE && FlowPathUtil.isOnLevel(r, floor2), 1));
    }

    public static List<ISchematicRoom> getRoomsAbove(ISchematicRoom room1) {
        VentusData md = Objects.requireNonNull(VentusApp.getAppData());
        Point3d pMin = room1.getBounds().getMax();
        Point3d pMax = room1.getBounds().getMax();
        Floor floor1 = FlowPathUtil.getLevel(room1);
        if (floor1 == null) {
            return Collections.emptyList();
        }
        int i1 = md.floors.indexOf(floor1);
        Floor floor2 = FlowPathUtil.getLevel(i1 + 1);
        if (floor2 == null) {
            return Collections.emptyList();
        }
        pMax.z = floor2.getWorkingZ().get(Geometry.LENGTH_UNIT) + floor2.getHeight().get(Geometry.LENGTH_UNIT);
        return new ArrayList<ISchematicRoom>(md.geomLocation.getLocator().find((ITest<AABox>)new AABox(pMin, pMax), SchematicRoom.class, r -> room1 != r && r.getType() == ISchematicRoom.Type.ZONE && FlowPathUtil.isOnLevel(r, floor2), 1));
    }

    public static <T> Pair<T, T> reverse(Pair<T, T> pair) {
        return new Pair(pair.v2, pair.v1);
    }

    public static double getWallAzimuth(ISchematicRoom room, ISchematicRoom.IWallComponent wall, boolean direction) {
        if (wall == null) {
            return 0.0;
        }
        Vector3d normal = wall.getNormal();
        if (normal.lengthSquared() == 0.0) {
            return 0.0;
        }
        if (!direction) {
            normal = Util3D.negate(normal);
        }
        return Math.toDegrees(Util3D.angle0To2PI(normal, Util3D.VEC3D_YNEG, Util3D.VEC3D_ZPOS));
    }

    public static Set<ISchematicRoom> findConnectedZones(ISchematicRoom root, Set<FlowElement> connectionTypes) {
        HashSet<ISchematicRoom> linkedZones = new HashSet<ISchematicRoom>();
        FlowPathUtil.findConnectedZones(root, linkedZones, connectionTypes);
        return linkedZones;
    }

    public static Set<FlowPath> findConnectedFlowPathsOfTypes(Set<ISchematicRoom> zones, Set<FlowElement> validTypes) {
        HashSet<FlowPath> connectedPaths = new HashSet<FlowPath>();
        for (ISchematicRoom zone : zones) {
            connectedPaths.addAll(zone.getConnections(FlowPath.class).stream().filter(path -> validTypes.contains(path.getFlowElement())).collect(Collectors.toSet()));
        }
        return connectedPaths;
    }

    public static void findConnectedZones(ISchematicRoom root, Set<ISchematicRoom> linkedRooms, Set<FlowElement> connectionTypes) {
        if (linkedRooms.contains(root)) {
            return;
        }
        List<FlowPath> paths = root.getConnections(FlowPath.class).stream().filter(path -> connectionTypes.contains(path.getFlowElement())).toList();
        HashSet<ISchematicRoom> nextExplore = new HashSet<ISchematicRoom>();
        for (FlowPath path2 : paths) {
            Pair<ISchematicRoom, ISchematicRoom> pathZones = path2.getZones();
            if (pathZones.v1 != root && pathZones.v1 != FlowPath.AMBIENT_ZONE) {
                nextExplore.add((ISchematicRoom)pathZones.v1);
            }
            if (pathZones.v2 == root || pathZones.v2 == FlowPath.AMBIENT_ZONE) continue;
            nextExplore.add((ISchematicRoom)pathZones.v2);
        }
        for (ISchematicRoom potentialAboveRoom : FlowPathUtil.getRoomsAbove(root)) {
            List<FlowPath> potentialVertPaths = potentialAboveRoom.getConnections(FlowPath.class).stream().filter(path -> connectionTypes.contains(path.getFlowElement())).toList();
            for (FlowPath potVert : potentialVertPaths) {
                Pair<ISchematicRoom, ISchematicRoom> pathZones = potVert.getZones();
                if (pathZones.v1 == root) {
                    nextExplore.add((ISchematicRoom)pathZones.v2);
                }
                if (pathZones.v2 != root) continue;
                nextExplore.add((ISchematicRoom)pathZones.v1);
            }
        }
        linkedRooms.add(root);
        for (ISchematicRoom deepZone : nextExplore) {
            FlowPathUtil.findConnectedZones(deepZone, linkedRooms, connectionTypes);
        }
    }
}

