/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.ShapeGeom;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.util.CachedValue;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.theUtil;

public class FlowPathGeometry
extends GeomGroup {
    public static final long serialVersionUID = 1L;
    public final Pair<Point3d, Point3d> locations;
    public final Pair<Vector3d, Vector3d> normals;
    public final double size;
    private static final CachedValue<Mesh> s_unitOctahedron = new CachedValue();

    public FlowPathGeometry(Pair<Vector3d, Vector3d> normals, Pair<Point3d, Point3d> locations, double size) {
        this(normals, locations, size, true);
    }

    public FlowPathGeometry(Pair<Vector3d, Vector3d> normals, Pair<Point3d, Point3d> locations, double size, boolean solid) {
        super(FlowPathGeometry.generateGeoms(normals, locations, size, solid));
        this.locations = locations;
        this.normals = normals;
        this.size = size;
    }

    private static List<IGeom> generateGeoms(Pair<Vector3d, Vector3d> normals, Pair<Point3d, Point3d> locations, double size, boolean solid) {
        ArrayList<IGeom> geoms = new ArrayList<IGeom>();
        ArrayList<Mesh> octahedrons = new ArrayList<Mesh>();
        octahedrons.add(FlowPathGeometry.generateOctahedron());
        octahedrons.add(FlowPathGeometry.generateOctahedron());
        for (int i = 0; i < octahedrons.size(); ++i) {
            Point3d thisLoc = i == 0 ? (Point3d)locations.v1 : (Point3d)locations.v2;
            Vector3d thisNorm = i == 0 ? (Vector3d)normals.v1 : (Vector3d)normals.v2;
            ITransform xform = TransformUtil.translate(thisLoc);
            xform = xform.concatenate(new MatrixXform(Util.getLocalToWorldXform(new Plane3d(thisNorm, GeomConstants.PNT3D_ORIGIN))));
            xform = xform.concatenate(TransformUtil.scale(size, size, size));
            Mesh xformed = ((Mesh)octahedrons.get(i)).transform(xform.getInfo(), 0);
            geoms.add(xformed);
            geoms.add(xformed.generateOutlines());
        }
        if (solid) {
            LineSeg lineGeom = new LineSeg((Point3d)locations.v1, (Point3d)locations.v2);
            geoms.add(lineGeom);
        }
        return geoms;
    }

    public static ShapeGeom generateDiamond(Vector3d normal, Point3d location, double size) {
        Plane3d plane = new Plane3d(normal, new Point3d(0.0, 0.0, 0.0));
        Path2D.Double diamond = new Path2D.Double();
        diamond.moveTo(-size * 0.5, 0.0);
        diamond.lineTo(0.0, -size * 0.5);
        diamond.lineTo(size * 0.5, 0.0);
        diamond.lineTo(0.0, size * 0.5);
        diamond.closePath();
        Matrix4d xform = Util.translateMat(location.x, location.y, location.z);
        xform.mul(Util.getLocalToWorldXform(plane));
        return new ShapeGeom((Shape)diamond, xform);
    }

    public static Mesh generateOctahedron() {
        return s_unitOctahedron.get(() -> {
            Point3d lx;
            double size = 0.5;
            Point3d top = new Point3d(0.0, 0.0, size);
            Point3d bot = new Point3d(0.0, 0.0, -size);
            Point3d ly = new Point3d(0.0, size, 0.0);
            Point3d v1 = lx = new Point3d(size, 0.0, 0.0);
            Point3d v2 = ly;
            Point3d v3 = Util3D.scale(lx, -1.0);
            Point3d v4 = Util3D.scale(ly, -1.0);
            int itop = 4;
            int ibot = 5;
            Point3d[] verts = new Point3d[]{v1, v2, v3, v4, null, null};
            verts[itop] = top;
            verts[ibot] = bot;
            ArrayList ixes = new ArrayList();
            TriConsumer<Integer, Integer, Integer> addTri = (i1, i2, i3) -> {
                ixes.add(i1);
                ixes.add(i2);
                ixes.add(i3);
            };
            for (int i = 0; i < 4; ++i) {
                int j = (i + 1) % 4;
                addTri.accept(itop, i, j);
                addTri.accept(ibot, j, i);
            }
            return new Mesh(verts, theUtil.toIntArray(ixes), 2);
        });
    }

    @Override
    public IGeom transform(TransformInfo ti, int options) {
        if (ti.isIdentity()) {
            return this;
        }
        Pair<Point3d, Point3d> newLocations = new Pair<Point3d, Point3d>(Util3D.xform(ti.getMatrix(), (Point3d)this.locations.v1), Util3D.xform(ti.getMatrix(), (Point3d)this.locations.v2));
        Pair<Vector3d, Vector3d> newNormals = new Pair<Vector3d, Vector3d>(Util3D.xform(ti.getMatrix(), (Vector3d)this.normals.v1), Util3D.xform(ti.getMatrix(), (Vector3d)this.normals.v2));
        return new FlowPathGeometry(newNormals, newLocations, this.size);
    }
}

