/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.util.Collection;
import java.util.List;
import ventus.data.Composite;
import ventus.data.VentusData;
import ventus.feature.comps.TypeDependency;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathRoot;
import ventus.feature.tags.Tag;
import ventus.feature.windprofiles.WindProfile;
import ventus.util.Dependencies;

public class FlowPathDependencies
implements TypeDependency {
    @Override
    public Collection<Dependencies.ReferencingType> getRefTypeInfo() {
        return List.of(this.getWindProfileRefType(), this.getFlowElemRefType(), this.getTagsRefType());
    }

    private Dependencies.ReferencingType getWindProfileRefType() {
        return new Dependencies.ReferencingType(FlowPath.class, md -> FlowPathDependencies.getDataRoot(md).getMembers(), (fp, callback) -> callback.addRef(fp, fp.get(FlowPath.WIND_PROFILE)), WindProfile.class);
    }

    private Dependencies.ReferencingType getFlowElemRefType() {
        return new Dependencies.ReferencingType(FlowPath.class, md -> FlowPathDependencies.getDataRoot(md).getMembers(), (fp, callback) -> callback.addRef(fp, fp.get(FlowPath.FLOW_ELEMENT)), FlowElement.class);
    }

    private Dependencies.ReferencingType getTagsRefType() {
        return new Dependencies.ReferencingType(FlowPath.class, vd -> FlowPathDependencies.getDataRoot(vd).getMembers(), (fp, refAdder) -> refAdder.addRefs(fp, fp.getTags()), Tag.class);
    }

    private static Composite<FlowPath> getDataRoot(VentusData appData) {
        return (FlowPathRoot)appData.getComponentData("flowpaths.data");
    }
}

