/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Color;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.TypedProp;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.AddObject;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowElementData;
import ventus.feature.flowpaths.FlowElementRoot;
import ventus.feature.flowpaths.FlowPath;
import ventus.feature.flowpaths.FlowPathRoot;
import ventus.geom.IMerlinGeomSrc;
import ventus.mv.ModelView;
import ventus.mv.displays.APropsDisplay;
import ventus.util.MerlinProps;

public class FlowPathBuilder
extends MerlinProps
implements IEventObserver {
    public static final TypedProp<Boolean> OVERWRITE_ELEVATION = new TypedProp<Boolean>((Object)"FlowPathBuilder.OVERWRITE_ELEVATION", false);
    public static final TypedProp<Mode> MODE = new TypedProp<Mode>((Object)"FlowPathBuilder.MODE", Mode.ONE_POINT);
    public static final TypedProp<UnitDouble> RELATIVE_ELEVATION = new TypedProp<UnitDouble>((Object)"FlowPathBuilder.RELATIVE_ELEVATION", new UnitDouble(0.0, SI.METER));
    private final FlowPath d_comp = new FlowPath("", this.getDefaultElement());
    public static float SNAP_THRESHOLD = 0.5f;

    public FlowPathBuilder() {
        VentusApp.getAppData().getEvents().addObserver(this);
    }

    private FlowElement getDefaultElement() {
        VentusData vd = VentusApp.getAppData();
        FlowElementRoot flowElementRoot = (FlowElementRoot)vd.getComponentData(FlowElementData.GUID);
        return flowElementRoot != null ? flowElementRoot.getDefault() : new FlowElement("");
    }

    @Override
    public void update(Events events) {
        IEventRecord<FlowElement> rec = events.getEvents(FlowElement.class, new Class[0]);
        if (rec.getRemovedObjs().contains(this.d_comp.get(FlowPath.FLOW_ELEMENT))) {
            this.d_comp.set(FlowPath.FLOW_ELEMENT, this.getDefaultElement());
        }
    }

    public FlowPath comp() {
        return this.d_comp;
    }

    @Override
    public <T> void set(IPropertySet.Prop<T> prop, T val) {
        if (!(prop instanceof TypedProp)) {
            return;
        }
        if (!FlowPath.has((TypedProp)prop)) {
            super.set(prop, val);
            return;
        }
        if (!this.lock()) {
            return;
        }
        try {
            this.d_comp.set((TypedProp)prop, val);
            this.firePropChanged(prop);
        }
        finally {
            this.release();
        }
    }

    @Override
    public <T> T get(IPropertySet.Prop<T> prop) {
        if (!(prop instanceof TypedProp)) {
            return null;
        }
        if (FlowPath.has((TypedProp)prop)) {
            return this.d_comp.get((TypedProp)prop);
        }
        return super.get(prop);
    }

    public void setLocation(ISchematicRoom comp, Vector3d normal, Point3d location, ISchematicRoom.IWallComponent wall) {
        this.setStartLocation(comp, normal, location, wall);
        this.setEndLocation(comp, normal, location, wall);
        if (this.get(OVERWRITE_ELEVATION).booleanValue()) {
            this.comp().setRelativeElevation(this.get(RELATIVE_ELEVATION));
            this.firePropChanged(RELATIVE_ELEVATION);
        } else {
            this.set(RELATIVE_ELEVATION, this.comp().getRelativeElevation());
        }
    }

    public boolean is2Pt() {
        return this.get(MODE) == Mode.TWO_POINT;
    }

    public boolean isValid() {
        Point3d startLocation = this.get(FlowPath.START_LOCATION);
        Point3d endLocation = this.get(FlowPath.END_LOCATION);
        ISchematicRoom startComp = this.get(FlowPath.START_COMP);
        ISchematicRoom endComp = this.get(FlowPath.END_COMP);
        return startComp != null && endComp != null && startLocation != null && endLocation != null;
    }

    public void reset(boolean fullReset) {
        this.pause();
        this.set(FlowPath.START_COMP, (ISchematicRoom)FlowPath.START_COMP.defVal);
        this.set(FlowPath.END_COMP, (ISchematicRoom)FlowPath.END_COMP.defVal);
        this.set(FlowPath.START_LOCATION, (Point3d)FlowPath.START_LOCATION.defVal);
        this.set(FlowPath.END_LOCATION, (Point3d)FlowPath.END_LOCATION.defVal);
        this.set(FlowPath.START_NORMAL, (Vector3d)FlowPath.START_NORMAL.defVal);
        this.set(FlowPath.END_NORMAL, (Vector3d)FlowPath.END_NORMAL.defVal);
        this.set(MODE, (Mode)((Object)FlowPathBuilder.MODE.defVal));
        if (fullReset) {
            this.set(RELATIVE_ELEVATION, (UnitDouble)FlowPathBuilder.RELATIVE_ELEVATION.defVal);
            this.set(OVERWRITE_ELEVATION, (Boolean)FlowPathBuilder.OVERWRITE_ELEVATION.defVal);
        }
        this.resume();
    }

    public void cancel() {
        this.reset(true);
    }

    public void setLocation(ISchematicRoom startComp, ISchematicRoom endComp, ISchematicRoom.IWallComponent startWall, ISchematicRoom.IWallComponent endWall, Vector3d startNormal, Vector3d endNormal, Point3d startLocation, Point3d endLocation) {
        this.setStartLocation(startComp, startNormal, startLocation, startWall);
        this.setEndLocation(endComp, endNormal, endLocation, endWall);
        if (endComp != startComp) {
            this.set(FlowPath.DIRECTION, true);
        }
    }

    public void setLocation(FlowPath.Connection conn, ISchematicRoom comp, Vector3d normal, Point3d location, ISchematicRoom.IWallComponent wall) {
        this.pause();
        this.set(conn.comp, comp);
        this.set(conn.normal, normal);
        this.set(conn.location, location);
        this.set(conn.wall, wall);
        this.resume();
    }

    public void setStartLocation(ISchematicRoom comp, Vector3d normal, Point3d location, ISchematicRoom.IWallComponent wall) {
        this.setLocation(FlowPath.Connection.START, comp, normal, location, wall);
    }

    public void setEndLocation(ISchematicRoom comp, Vector3d normal, Point3d location, ISchematicRoom.IWallComponent wall) {
        this.setLocation(FlowPath.Connection.END, comp, normal, location, wall);
    }

    public void create() {
        if (!this.isValid()) {
            return;
        }
        final FlowPath path = this.comp().clone();
        AMerlinOp op = new AMerlinOp(this){

            @Override
            public void run(VentusApp app, VentusData md) {
                FlowPathRoot dataRoot = (FlowPathRoot)md.getComponentData("flowpaths.data");
                if (dataRoot == null) {
                    return;
                }
                try (VentusData.WriteLock ignored = md.lockWrite();){
                    Undo.begin(Intl.intl("Create Flow Path"));
                    String nextName = path.getName().equals("") ? dataRoot.nextName() : path.getName();
                    path.setName(nextName);
                    AddObject.add((VentusData)md, (Composite)dataRoot, (int)dataRoot.getChildren().size(), (ICompElement[])new FlowPath[]{path});
                    Undo.end(md);
                }
            }
        };
        UIHook.run(null, "FlowPathBuilder.create", op, 4);
    }

    public static enum Mode {
        ONE_POINT,
        TWO_POINT;

    }

    public static class Display
    extends APropsDisplay<FlowPathBuilder> {
        public Display(ModelView mv) {
            super(mv);
        }

        @Override
        protected IMerlinGeomSrc constructGeom(FlowPathBuilder builder) {
            if (!builder.isValid()) {
                return null;
            }
            if (builder.is2Pt()) {
                return null;
            }
            FlowPath node = builder.comp().clone();
            node.setVisible(true);
            if (builder.isValid()) {
                node.set(FlowPath.COLOR, Color.GREEN);
            } else {
                node.set(FlowPath.COLOR, Color.RED);
            }
            return node;
        }

        @Override
        protected Object[] getInterestingChanges() {
            return new Object[0];
        }
    }
}

