/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Color;
import java.util.Collection;
import java.util.function.Function;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.NameGenerator;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.feature.flowpaths.FlowElement;

class FlowElementRoot
extends Composite<FlowElement> {
    private static final long serialVersionUID = 1L;
    private NameGenerator d_nameGen = new NameGenerator(Intl.intl("flowelement"));

    public FlowElementRoot() {
        super(Intl.intl("Flow Elements"));
        this.addDefaults();
    }

    public void reset() {
        this.clear();
        this.addDefaults();
    }

    @Override
    public void clear() {
        super.clear();
        this.d_nameGen.reset();
    }

    @Override
    public void restoreFrom(Object obj) {
        super.restoreFrom(obj);
        if (!(obj instanceof FlowElementRoot)) {
            return;
        }
        this.d_nameGen = ((FlowElementRoot)obj).d_nameGen;
    }

    @Override
    public void add(ICompElement elem) {
        super.add(elem);
        this.d_nameGen.registerName(elem.getName());
    }

    private void addDefaults() {
        this.pauseUpdates();
        for (Default def : Default.values()) {
            this.add(def.create.apply(def));
        }
        this.resumeUpdates();
    }

    public FlowElement getDefault(Collection<FlowElement> elements) {
        FlowElement defElement = elements.stream().filter(e -> e.get(FlowElement.DEFAULT_TYPE) != null).findFirst().orElse(null);
        if (defElement != null) {
            return defElement;
        }
        if (elements.size() > 0) {
            return elements.iterator().next();
        }
        assert (false);
        return null;
    }

    public FlowElement getDefault() {
        return this.getDefault(this.getDeepMembers(FlowElement.class));
    }

    public String nextName() {
        String name = this.getNameGenerator().generateName();
        this.getNameGenerator().registerName(name);
        return name;
    }

    public NameGenerator getNameGenerator() {
        return this.d_nameGen;
    }

    @Override
    public Composite<FlowElement> newGroup(String name) {
        return new FlowElementNode(name);
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Flow Element Group");
    }

    public static enum Default {
        AREA_AREA(type -> {
            FlowElement areaArea = new FlowElement(Intl.intl("AREA/Area"), (Default)((Object)type), new Color(50, 175, 50), FlowElement.PowerlawModel.LEAKAGE_AREA);
            areaArea.set(FlowElement.LEAKAGE_AREA_TYPE, FlowElement.LeakageAreaType.AREA);
            return areaArea;
        }),
        AREA_ITEM(type -> {
            FlowElement areaItem = new FlowElement(Intl.intl("AREA/Item"), (Default)((Object)type), new Color(175, 50, 50), FlowElement.PowerlawModel.LEAKAGE_AREA);
            areaItem.set(FlowElement.LEAKAGE_AREA_TYPE, FlowElement.LeakageAreaType.ITEM);
            return areaItem;
        }),
        STAIRWELL(type -> {
            FlowElement stairwell = new FlowElement(Intl.intl("STAIRWELL"), (Default)((Object)type), new Color(50, 50, 175), FlowElement.PowerlawModel.STAIRWELL);
            stairwell.set(FlowElement.CROSS_SECTIONAL_AREA, new UnitDouble(12.5, SI.METER.pow(2)));
            stairwell.set(FlowElement.PRESSURE_EXPONENT, 0.5);
            return stairwell;
        }),
        SHAFT(type -> {
            FlowElement shaft = new FlowElement(Intl.intl("SHAFT"), (Default)((Object)type), new Color(142, 50, 175), FlowElement.PowerlawModel.SHAFT);
            shaft.set(FlowElement.CROSS_SECTIONAL_AREA, new UnitDouble(6.0, SI.METER.pow(2)));
            shaft.set(FlowElement.REYNOLDS_NUMBER, 1000.0);
            return shaft;
        }),
        ORIFICE(type -> {
            FlowElement orifice = new FlowElement(Intl.intl("ORIFICE"), (Default)((Object)type), new Color(33, 45, 39), FlowElement.PowerlawModel.ORIFICE_AREA);
            orifice.set(FlowElement.CROSS_SECTIONAL_AREA, new UnitDouble(0.1, SI.METER.pow(2)));
            orifice.set(FlowElement.PRESSURE_EXPONENT, 0.5);
            return orifice;
        });

        public final Function<Default, FlowElement> create;

        private Default(Function<Default, FlowElement> create) {
            this.create = create;
        }
    }

    static class FlowElementNode
    extends Composite<FlowElement> {
        public FlowElementNode(String name) {
            super(name);
        }

        @Override
        public String getNewGroupName() {
            return Intl.intl("Flow Element Group");
        }

        @Override
        public Composite<FlowElement> newGroup(String name) {
            return new FlowElementNode(name);
        }
    }
}

