/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.Delete;
import ventus.data.VentusData;
import ventus.feature.flowpaths.FlowElement;
import ventus.feature.flowpaths.FlowElementData;
import ventus.feature.flowpaths.FlowElementEditor;
import ventus.feature.flowpaths.FlowElementManager;
import ventus.feature.flowpaths.FlowElementRoot;
import ventus.gui.LibraryDlg;
import ventus.gui.ManagerDlg;
import ventus.unitsystem.UnitSystem;

public class FlowElementMgrDlg
extends ManagerDlg<FlowElement, FlowElementManager> {
    private static final long serialVersionUID = 1L;
    private final JFrame d_owner;
    private final FlowElementEditor d_editor;
    private FlowElementManager d_manager;

    public FlowElementMgrDlg(JFrame owner, UnitSystem us) {
        super(owner, Intl.intl("Edit Flow Elements"), FlowElement.class);
        this.d_owner = owner;
        this.d_editor = new FlowElementEditor(us);
        this.d_actions = new Action[]{this.newAction(Intl.intl("New..."), this::createNew), new FlowElementLibraryAction(), this.newAction(Intl.intl("Duplicate..."), this::duplicate), this.newAction(Intl.intl("Rename..."), this::renameSelected), this.newAction(Intl.intl("Delete..."), this::deleteSelected)};
        this.updateActions();
    }

    public void init(VentusData data, FlowElementManager manager, FlowElement node) {
        super.init(data, manager, this.d_editor, this.d_actions);
        this.d_manager = manager;
        if (node == null) {
            this.getList().select(0);
            return;
        }
        this.getList().select(node);
    }

    private boolean nameExists(String name) {
        return this.d_manager.getRoot().flatten().stream().anyMatch(elem -> elem.getName().equalsIgnoreCase(name));
    }

    private boolean validateName(String existing, String name) {
        if (name.isEmpty() || name.isBlank()) {
            guiDialog.showInvalidEntryMessage(this, Intl.intl("Name must not be blank."));
            return false;
        }
        if (existing != null && existing.equals(name)) {
            return true;
        }
        if (this.nameExists(name)) {
            guiDialog.showInvalidEntryMessage(this, Intl.intl("A flow element with that name already exists."));
            return false;
        }
        return true;
    }

    public void createNew(ActionEvent event) {
        this.preSave();
        FlowElementRoot root = this.d_manager.getRoot();
        NameGenerator ng = root.getNameGenerator();
        FlowElement.PowerlawModel initPlmFromSelected = this.getList().getSelectedItem() != null ? ((FlowElement)this.getList().getSelectedItem()).get(FlowElement.POWERLAW_MODEL) : FlowElement.PowerlawModel.ORIFICE_AREA;
        guiComboBox<FlowElement.PowerlawModel> modelBox = new guiComboBox<FlowElement.PowerlawModel>(FlowElement.PowerlawModel.values());
        modelBox.setSelectedItem((Object)initPlmFromSelected);
        final guiTextField nameField = new guiTextField();
        nameField.setText(ng.generateValidName(Intl.intl("FlowElement")));
        guiPanel dlgPanel = new guiPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return FlowElementMgrDlg.this.validateName(null, nameField.getValue());
            }
        };
        dlgPanel.setLayout(new MigLayout("insets 0", "[left, grow][right]"));
        dlgPanel.add((Component)new guiLabel(Intl.intl("Name:")), "");
        dlgPanel.add((Component)nameField, "sg 1, wrap");
        dlgPanel.add((Component)new guiLabel(Intl.intl("Model:")), "");
        dlgPanel.add(modelBox, "sg 1, wrap");
        guiDialog dlg = new guiDialog((Window)this, Intl.intl("New Flow Element"), 9);
        dlg.setDialogComponent(dlgPanel);
        if (dlg.doModal() == 1) {
            String name = nameField.getValue();
            FlowElement element = new FlowElement(name, null, theUtil.newRandomColor(), modelBox.getSelectedItem());
            root.add(element);
            this.getList().updateModelView(this.d_manager);
        }
    }

    public void duplicate(ActionEvent event) {
        this.preSave();
        FlowElementRoot root = this.d_manager.getRoot();
        FlowElement selected = (FlowElement)this.getList().getSelectedItem();
        guiComboBox<FlowElement> basedOnComboBox = new guiComboBox<FlowElement>(this.d_manager.getSorted());
        basedOnComboBox.setSelectedItem(selected);
        final guiTextField nameField = new guiTextField();
        nameField.setText(root.getNameGenerator().generateValidName(selected.getName()));
        basedOnComboBox.addItemListener(evt -> {
            if (evt.getStateChange() == 1 && !nameField.isModified()) {
                FlowElement item = (FlowElement)evt.getItem();
                nameField.setText(root.getNameGenerator().generateValidName(item.getName()));
            }
        });
        guiPanel namePanel = new guiPanel(new MigLayout("fill, insets 0")){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return FlowElementMgrDlg.this.validateName(null, nameField.getValue());
            }
        };
        namePanel.add((Component)new guiLabel(Intl.intl("Name:")), "growx");
        namePanel.add((Component)nameField, "growx, wrap");
        namePanel.add((Component)new guiLabel(Intl.intl("Based On:")), "growx");
        namePanel.add(basedOnComboBox, "growx, wrap");
        guiDialog dlg = new guiDialog((Window)this, Intl.intl("Duplicate Flow Element"), 9);
        dlg.setDialogComponent(namePanel);
        if (dlg.doModal() == 1) {
            String name = nameField.getValue();
            FlowElement element = basedOnComboBox.getSelectedItem() != null ? basedOnComboBox.getSelectedItem().clone() : new FlowElement(name);
            element.setName(name);
            element.set(FlowElement.DESC, "");
            root.add(element);
            this.getList().updateModelView(this.d_manager);
        }
    }

    public void renameSelected(ActionEvent event) {
        this.preSave();
        FlowElement node = (FlowElement)this.getList().getSelectedItem();
        String name = null;
        do {
            if ((name = (String)JOptionPane.showInputDialog(this, Intl.intl("Name:"), Intl.intl("Rename Flow Model"), 3, FlowElementData.icon_contrast2_md, null, node.getName())) != null) continue;
            return;
        } while (!this.validateName(node.getName(), name));
        node.setName(name);
        this.getList().updateModelView(this.d_manager);
        this.d_editor.init(node);
    }

    public void deleteSelected(ActionEvent event) {
        FlowElement node = (FlowElement)this.getList().getSelectedItem();
        int selectedIndex = this.getList().getSelectedIx();
        Delete.DelStatus status = Delete.uiDelete(VentusApp.getApp(), this.getMerlinData(), Set.of(node), true);
        if (status.equals((Object)Delete.DelStatus.SUCCESS)) {
            this.getList().updateModelView(this.d_manager);
            this.getList().select(Math.max(0, selectedIndex - 1));
            FlowElement selectedElement = (FlowElement)this.getList().getSelectedItem();
            this.d_editor.init(selectedElement);
            if (selectedElement != null) {
                this.d_editor.getEditorPanel().setEnabled(true);
            }
        }
    }

    @Override
    public void updateActions() {
        if (this.d_manager == null) {
            Arrays.stream(this.d_actions).forEach(action -> action.setEnabled(false));
            return;
        }
        FlowElement item = (FlowElement)this.getList().getSelectedItem();
        boolean isPresent = item != null;
        for (Action action2 : this.d_actions) {
            action2.setEnabled(isPresent);
        }
    }

    public Action newAction(String name, ActionListener listener) {
        return new guiAction(name, listener);
    }

    private class FlowElementLibraryAction
    extends guiAction {
        private static final long serialVersionUID = -5364133990644521647L;

        public FlowElementLibraryAction() {
            super(Intl.intl("Add From Library") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!FlowElementMgrDlg.this.preSave()) {
                return;
            }
            LibraryDlg dlg = new LibraryDlg(FlowElementMgrDlg.this.d_owner, FlowElementMgrDlg.this.getMerlinData(), () -> FlowElementMgrDlg.this.getList().updateModelView(FlowElementMgrDlg.this.d_manager), data -> (FlowElementRoot)data.getComponentData(FlowElementData.GUID), root -> root.flatten(FlowElement.class), new LibraryDlg.LibraryInfo(Intl.intl("Flow Element"), "lib/flowelement", "flowelement"));
            dlg.doModal();
            FlowElementMgrDlg.this.getList().updateModelView(FlowElementMgrDlg.this.d_manager);
        }
    }
}

