/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.flowpaths;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Nullable;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.data.ICompElement;
import ventus.data.IRestorable;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.feature.flowpaths.FlowElementRoot;
import ventus.feature.flowpaths.FlowPathMathUtil;
import ventus.feature.props.TypedPropSet;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;
import ventus.io.VentusIO;
import ventus.io.VentusOIS;

public class FlowElement
extends NamedMerlinObj
implements Serializable,
ICompElement,
IRestorable,
ISurrogate,
IObservable,
IDirectDependent<VentusData> {
    private static final long serialVersionUID = 1L;
    public static final TypedPropSet<FlowElement> PROP_TYPES = new TypedPropSet();
    public static final TypedProp<FlowElementRoot.Default> DEFAULT_TYPE = PROP_TYPES.add((Object)"FlowElement.DEFAULT_TYPE", FlowElementRoot.Default.class, new TypedPropSet.Options[0]);
    public static final TypedProp<String> NAME = PROP_TYPES.add(NamedMerlinObj.NAME, NamedMerlinObj::getName, NamedMerlinObj::setName, new TypedPropSet.Options[0]);
    public static final TypedProp<String> DESC = PROP_TYPES.add((Object)"FlowElement.DESC", "", new TypedPropSet.Options[0]);
    public static final TypedProp<Color> COLOR = PROP_TYPES.add((Object)"FlowElement.COLOR", Color.BLACK, new TypedPropSet.Options[0]);
    public static final TypedProp<Set<Tag>> TAGS = PROP_TYPES.add(VentusData.TAGS, FlowElement::getTags, FlowElement::setTags, TypedPropSet.Options.WEAK_DEPENDENT);
    public static final TypedProp<Boolean> IS_DEFAULT = PROP_TYPES.add(new TypedProp<Boolean>((Object)"FlowElement.IS_DEFAULT", false), FlowElement::isDefault, TypedPropSet.Options.TRANSIENT);
    public static final TypedProp<PowerlawModel> POWERLAW_MODEL = PROP_TYPES.add((Object)"FlowElement.POWERLAW_MODEL", PowerlawModel.ORIFICE_AREA, new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> CROSS_SECTIONAL_AREA = PROP_TYPES.add((Object)"FlowElement.CROSS_SECTIONAL_AREA", new UnitDouble(1.0, SI.METER.pow(2)), new TypedPropSet.Options[0]);
    public static final TypedProp<Double> PRESSURE_EXPONENT = PROP_TYPES.add((Object)"FlowElement.PRESSURE_EXPONENT", Double.valueOf(0.65), new TypedPropSet.Options[0]);
    public static final TypedProp<Double> DISCHARGE_COEFFICIENT = PROP_TYPES.add((Object)"FlowElement.DISCHARGE_COEFFICIENT", Double.valueOf(0.6), new TypedPropSet.Options[0]);
    public static final TypedProp<Double> REYNOLDS_NUMBER = PROP_TYPES.add((Object)"FlowElement.REYNOLDS_NUMBER", Double.valueOf(30.0), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> STAIR_SHAFT_DZ = PROP_TYPES.add((Object)"FlowElement.STAIR_SHAFT_DZ", new UnitDouble(3.0, SI.METER), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> PRESSURE_DIFFERENCE = PROP_TYPES.add((Object)"FlowElement.PRESSURE_DIFFERENCE", new UnitDouble(10.0, SI.PASCAL), new TypedPropSet.Options[0]);
    public static final TypedProp<LeakageAreaType> LEAKAGE_AREA_TYPE = PROP_TYPES.add((Object)"FlowElement.LEAKAGE_AREA_TYPE", LeakageAreaType.ITEM, new TypedPropSet.Options[0]);
    @Deprecated
    public static final TypedProp<UnitDouble> LEAKAGE_AREA = PROP_TYPES.add((Object)"FlowElement.LEAKAGE_AREA", new UnitDouble(1.0, SI.METER.pow(2)), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> LEAKAGE_AREA_PER_ITEM = PROP_TYPES.add((Object)"FlowElement.LEAKAGE_AREA_PER_ITEM", new UnitDouble(1.0, SI.METER.pow(2)), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> LEAKAGE_AREA_PER_LENGTH = PROP_TYPES.add((Object)"FlowElement.LEAKAGE_AREA_PER_LENGTH", new UnitDouble(1.0, SI.METER), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> LEAKAGE_AREA_PER_AREA = PROP_TYPES.add((Object)"FlowElement.LEAKAGE_AREA_PER_AREA", new UnitDouble(3.5E-4, Unit.ONE), new TypedPropSet.Options[0]);
    @Deprecated
    public static final UnitDouble PRE_202_LEAKAGE_AREA_PER_AREA = new UnitDouble(1.0, Unit.ONE);
    public static final TypedProp<UnitDouble> PEOPLE_DENSITY = PROP_TYPES.add((Object)"FlowElement.PEOPLE_DENSITY", new UnitDouble(0.0, Unit.ONE.divide(SI.METER.pow(2))), new TypedPropSet.Options[0]);
    public static final TypedProp<Boolean> STAIR_TREADS_OPEN = PROP_TYPES.add((Object)"FlowElement.STAIR_TREADS_OPEN", Boolean.valueOf(false), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> PERIMETER = PROP_TYPES.add((Object)"FlowElement.PERIMETER", new UnitDouble(10.0, SI.METER), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> ROUGHNESS = PROP_TYPES.add((Object)"FlowElement.ROUGHNESS", new UnitDouble(0.1, SI.METER), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> MAX_FLOW_RATE = PROP_TYPES.add((Object)"FlowElement.MAX_FLOW_RATE", new UnitDouble(0.02, SI.METER.pow(3).divide(SI.SECOND)), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> REGULATING_PRESSURE = PROP_TYPES.add((Object)"FlowElement.REGULATING_PRESSURE", new UnitDouble(0.5, SI.PASCAL), new TypedPropSet.Options[0]);
    public static final TypedProp<UnitDouble> REVERSE_FLOW_FRACTION = PROP_TYPES.add((Object)"FlowElement.REVERSE_FLOW_FRACTION", new UnitDouble(1.0E-4, Unit.ONE), new TypedPropSet.Options[0]);
    private PropertySet d_properties = new PropertySet();
    private transient LinkedIdentityHashSet<IObserver> d_observers = new LinkedIdentityHashSet();

    public FlowElement(String name) {
        this(name, null, theUtil.newRandomColor(), (PowerlawModel)((Object)FlowElement.POWERLAW_MODEL.defVal));
    }

    public FlowElement(String name, FlowElementRoot.Default defaultType, Color color, PowerlawModel law) {
        super(name);
        this.d_properties.setIfNotDefault(DEFAULT_TYPE, defaultType);
        this.d_properties.set(COLOR, color);
        this.d_properties.set(POWERLAW_MODEL, law);
        this.d_properties.merge(law.defaultProps);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        int version;
        is.defaultReadObject();
        this.d_observers = new LinkedIdentityHashSet();
        if (this.d_properties.isDefined(IS_DEFAULT) && this.d_properties.get(IS_DEFAULT).booleanValue()) {
            assert (!this.d_properties.isDefined(DEFAULT_TYPE));
            this.d_properties.remove(IS_DEFAULT);
            String name = this.getName();
            for (FlowElementRoot.Default def : FlowElementRoot.Default.values()) {
                if (!def.create.apply(def).getName().equals(name)) continue;
                this.d_properties.set(DEFAULT_TYPE, def);
                break;
            }
        }
        if (VentusIO.Version.VER_0201.isLater(version = VentusOIS.getVersion(is)) && this.d_properties.get(POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA) {
            LeakageAreaType type = this.d_properties.get(LEAKAGE_AREA_TYPE);
            UnitDouble oldAreaM2 = this.d_properties.get(LEAKAGE_AREA).convert(SI.METER.pow(2));
            if (type == LeakageAreaType.ITEM) {
                UnitDouble areaPerItem = oldAreaM2.divide(new UnitDouble(1.0, Unit.ONE));
                this.d_properties.set(LEAKAGE_AREA_PER_ITEM, areaPerItem);
            } else if (type == LeakageAreaType.LENGTH) {
                UnitDouble areaPerLength = oldAreaM2.divide(new UnitDouble(1.0, SI.METER));
                this.d_properties.set(LEAKAGE_AREA_PER_LENGTH, areaPerLength);
            } else if (type == LeakageAreaType.AREA) {
                UnitDouble areaPerArea = oldAreaM2.divide(new UnitDouble(1.0, SI.METER.pow(2)));
                this.d_properties.set(LEAKAGE_AREA_PER_AREA, areaPerArea);
            }
            this.d_properties.remove(LEAKAGE_AREA);
        }
        if (VentusIO.Version.VER_0202.isLater(version) && this.d_properties.get(POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA && this.d_properties.get(LEAKAGE_AREA_TYPE) == LeakageAreaType.AREA && !this.d_properties.isDefined(LEAKAGE_AREA_PER_AREA)) {
            this.d_properties.set(LEAKAGE_AREA_PER_AREA, PRE_202_LEAKAGE_AREA_PER_AREA);
        }
    }

    @Override
    public <T> Optional<Nullable<T>> getNullableProp(IPropertySet.Prop<T> prop) {
        if (prop instanceof TypedProp) {
            return PROP_TYPES.getValue(this, this.d_properties, null, (TypedProp)prop);
        }
        return Optional.empty();
    }

    public <T> T get(TypedProp<T> prop) {
        Optional<Nullable<T>> value = PROP_TYPES.getValue(this, this.d_properties, null, prop);
        return value.isPresent() ? (T)value.get().val : null;
    }

    public <T> void set(TypedProp<T> prop, T value) {
        PROP_TYPES.setValue(this, this.d_properties, null, prop, value);
    }

    protected <T> void setToPropertySet(TypedProp<T> prop, T value) {
        PROP_TYPES.compareAndSetDirect(this, this.d_properties, null, prop, value);
    }

    public boolean isDefault() {
        return this.get(DEFAULT_TYPE) != null;
    }

    public Set<Tag> getTags() {
        return this.d_properties.get(VentusData.TAGS);
    }

    public void setTags(Set<Tag> tags) {
        this.setToPropertySet(VentusData.TAGS, tags);
    }

    public String getPowerlawModelType() {
        if (this.d_properties.get(POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA) {
            return PowerlawModel.LEAKAGE_AREA.type + this.get(FlowElement.LEAKAGE_AREA_TYPE).sequence;
        }
        return this.d_properties.get(FlowElement.POWERLAW_MODEL).type;
    }

    public double getTurbulentFlow() {
        if (this.d_properties.get(POWERLAW_MODEL) == PowerlawModel.ORIFICE_AREA) {
            return FlowPathMathUtil.orificeAreaTurbulentFlow(this.d_properties.get(CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)), this.d_properties.get(DISCHARGE_COEFFICIENT));
        }
        if (this.d_properties.get(POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA) {
            return FlowPathMathUtil.leakageAreaTurbulentFlow(this.getSingleUnitOfLeakArea().get(SI.METER.pow(2)), this.d_properties.get(DISCHARGE_COEFFICIENT), this.d_properties.get(PRESSURE_DIFFERENCE).get(SI.PASCAL), this.d_properties.get(PRESSURE_EXPONENT));
        }
        if (this.d_properties.get(POWERLAW_MODEL) == PowerlawModel.STAIRWELL) {
            return FlowPathMathUtil.stairwellTurbulentFlow(this.d_properties.get(CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)), this.d_properties.get(STAIR_SHAFT_DZ).get(SI.METER), this.d_properties.get(PEOPLE_DENSITY).get(Unit.ONE.divide(SI.METER.pow(2))), this.d_properties.get(STAIR_TREADS_OPEN));
        }
        if (this.d_properties.get(POWERLAW_MODEL) == PowerlawModel.SHAFT) {
            FlowPathMathUtil.ShaftCalcOutput result = FlowPathMathUtil.getShaftData(this.d_properties.get(STAIR_SHAFT_DZ).get(SI.METER), this.d_properties.get(CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)), this.d_properties.get(PERIMETER).get(SI.METER), this.d_properties.get(ROUGHNESS).get(SI.METER));
            return result.coefTurbulent;
        }
        return 0.0;
    }

    private UnitDouble getSingleUnitOfLeakArea() {
        LeakageAreaType type = this.get(LEAKAGE_AREA_TYPE);
        LeakageAreaTypeInfo typeInfo = new LeakageAreaTypeInfo(type);
        UnitDouble baseValue = this.get(typeInfo.prop);
        return typeInfo.convertToAreaM2.apply(baseValue);
    }

    public static UnitDouble areaToDiameter(UnitDouble area) {
        return area.divide(new UnitDouble(Math.PI, Unit.ONE)).root(2).multiply(new UnitDouble(2.0, Unit.ONE));
    }

    public double getLaminarFlow() {
        if (this.d_properties.get(POWERLAW_MODEL) == PowerlawModel.ORIFICE_AREA) {
            return FlowPathMathUtil.orificeAreaLaminarFlow(this.d_properties.get(REYNOLDS_NUMBER), this.d_properties.get(CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)), this.d_properties.get(DISCHARGE_COEFFICIENT), FlowElement.areaToDiameter(this.d_properties.get(CROSS_SECTIONAL_AREA)).get(SI.METER), this.d_properties.get(PRESSURE_EXPONENT));
        }
        if (this.d_properties.get(POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA) {
            return FlowPathMathUtil.leakageAreaLaminarFlow(this.getSingleUnitOfLeakArea().get(SI.METER.pow(2)), this.d_properties.get(DISCHARGE_COEFFICIENT), this.d_properties.get(PRESSURE_DIFFERENCE).get(SI.PASCAL), this.d_properties.get(PRESSURE_EXPONENT));
        }
        if (this.d_properties.get(POWERLAW_MODEL) == PowerlawModel.STAIRWELL) {
            return FlowPathMathUtil.stairwellLaminarFlow(this.d_properties.get(CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)), this.d_properties.get(STAIR_SHAFT_DZ).get(SI.METER), this.d_properties.get(PEOPLE_DENSITY).get(Unit.ONE.divide(SI.METER.pow(2))), this.d_properties.get(PRESSURE_EXPONENT), this.d_properties.get(STAIR_TREADS_OPEN));
        }
        if (this.d_properties.get(POWERLAW_MODEL) == PowerlawModel.SHAFT) {
            FlowPathMathUtil.ShaftCalcOutput result = FlowPathMathUtil.getShaftData(this.d_properties.get(STAIR_SHAFT_DZ).get(SI.METER), this.d_properties.get(CROSS_SECTIONAL_AREA).get(SI.METER.pow(2)), this.d_properties.get(PERIMETER).get(SI.METER), this.d_properties.get(ROUGHNESS).get(SI.METER));
            return result.coefLaminar;
        }
        return 0.0;
    }

    public boolean isLeakageAreaPerItem() {
        return this.get(POWERLAW_MODEL) == PowerlawModel.LEAKAGE_AREA && this.get(LEAKAGE_AREA_TYPE) == LeakageAreaType.ITEM;
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (!(comparable instanceof FlowElement)) {
            return false;
        }
        if (this == comparable) {
            return true;
        }
        FlowElement other = (FlowElement)comparable;
        return theUtil.surrogateMapsEqual(this.d_properties.getMap(), other.d_properties.getMap(), false);
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES.keys();
    }

    @Override
    public <T> void setProperty(Object key, T value) {
        if (key.equals(VentusData.TAGS)) {
            this.setTags((Set)value);
            return;
        }
        TypedProp<T> property = PROP_TYPES.getStrict(key, value);
        if (property == null) {
            return;
        }
        this.set(property, value);
    }

    @Override
    public Object getProperty(Object key) {
        TypedProp<?> prop = PROP_TYPES.get(key);
        if (prop == null) {
            return NOT_SUPPORTED;
        }
        return this.get(prop);
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof FlowElement)) {
            return;
        }
        FlowElement element = (FlowElement)obj;
        PROP_TYPES.restoreFrom(this, this.d_properties, element.d_properties, null, null);
    }

    @Override
    public FlowElement clone() {
        FlowElement clone = (FlowElement)super.clone();
        clone.d_properties = this.d_properties.clone();
        clone.d_observers = new LinkedIdentityHashSet();
        clone.set(DEFAULT_TYPE, null);
        return clone;
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean changedEvt(Object ... changes) {
        this.d_observers.forEach(o -> o.update(this, changes));
        return super.changedEvt(changes);
    }

    @Override
    public void addObserver(IObserver observer, boolean weakRef) {
        this.d_observers.add(observer);
    }

    @Override
    public void deleteObserver(IObserver observer) {
        this.d_observers.remove(observer);
    }

    @Override
    public boolean isSetNameSupported() {
        return this.get(IS_DEFAULT) == false;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.getTags());
        PROP_TYPES.takeDepSnapshot(this, this.d_properties, null, deps);
    }

    @Override
    public void replaceDependency(VentusData md, Object old, Object replacement) {
        TagsUtil.replaceDependency(this, old, replacement);
        PROP_TYPES.replaceDependency(this, this.d_properties, null, old, replacement);
    }

    public static enum PowerlawModel {
        ORIFICE_AREA(Intl.intl("Orifice Area"), "plr_orfc"),
        LEAKAGE_AREA(Intl.intl("Leakage Area"), "plr_leak"),
        STAIRWELL(Intl.intl("Stairwell"), "plr_stair"),
        SHAFT(Intl.intl("Shaft"), "plr_shaft"),
        SELF_REG_VENT(Intl.intl("Self-regulating Vent"), "srv_jwa");

        public final String name;
        public final String type;
        public final PropertySet defaultProps;

        private PowerlawModel(String name, String type) {
            this(name, type, Collections.EMPTY_LIST);
        }

        private PowerlawModel(String name, String type, List<TypedProp<?>> defaultProps) {
            this.name = name;
            this.type = type;
            this.defaultProps = new PropertySet();
            for (TypedProp<?> prop : defaultProps) {
                this.defaultProps.set(prop, prop.defVal);
            }
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum LeakageAreaType {
        ITEM(1, Intl.intl("Per Item")),
        LENGTH(2, Intl.intl("Per Unit Length")),
        AREA(3, Intl.intl("Per Unit Area"));

        public final String name;
        public final int sequence;

        private LeakageAreaType(int sequence, String name) {
            this.sequence = sequence;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class LeakageAreaTypeInfo {
        public final LeakageAreaType type;
        public final TypedProp<UnitDouble> prop;
        public final int unit;
        public final Function<UnitDouble, UnitDouble> convertToAreaM2;

        public LeakageAreaTypeInfo(LeakageAreaType type) {
            this.type = type;
            if (type == LeakageAreaType.ITEM) {
                this.prop = LEAKAGE_AREA_PER_ITEM;
                this.unit = 2;
                this.convertToAreaM2 = areaPerItem -> areaPerItem.multiply(new UnitDouble(1.0, Unit.ONE)).convert(SI.METER.pow(2));
            } else if (type == LeakageAreaType.LENGTH) {
                this.prop = LEAKAGE_AREA_PER_LENGTH;
                this.unit = 0;
                this.convertToAreaM2 = areaPerLength -> areaPerLength.multiply(new UnitDouble(1.0, SI.METER)).convert(SI.METER.pow(2));
            } else if (type == LeakageAreaType.AREA) {
                this.prop = LEAKAGE_AREA_PER_AREA;
                this.unit = 10;
                this.convertToAreaM2 = areaPerArea -> areaPerArea.multiply(new UnitDouble(1.0, SI.METER.pow(2))).convert(SI.METER.pow(2));
            } else {
                throw new IllegalArgumentException(type.name());
            }
        }

        public void exec(Runnable perItem, Runnable perLength, Runnable perArea) {
            if (this.type == LeakageAreaType.ITEM) {
                perItem.run();
            } else if (this.type == LeakageAreaType.LENGTH) {
                perLength.run();
            } else if (this.type == LeakageAreaType.AREA) {
                perArea.run();
            } else {
                throw new IllegalArgumentException(this.type.name());
            }
        }

        public <T> T get(Supplier<T> perItem, Supplier<T> perLength, Supplier<T> perArea) {
            if (this.type == LeakageAreaType.ITEM) {
                return perItem.get();
            }
            if (this.type == LeakageAreaType.LENGTH) {
                return perLength.get();
            }
            if (this.type == LeakageAreaType.AREA) {
                return perArea.get();
            }
            throw new IllegalArgumentException(this.type.name());
        }
    }
}

