/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ahssimple;

import java.util.Map;
import org.jscience.physics.units.SI;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.RestorableProperties;
import ventus.data.VentusData;
import ventus.feature.ahssimple.SimpleAHS;
import ventus.feature.ahssimple.SimpleAHSRoot;
import ventus.feature.comps.IPrjDataWriter;
import ventus.feature.simparams.SimParamsProps;
import ventus.io.contamx.PrjData;

public class SimpleAHSZonePrjDataWriter
implements IPrjDataWriter {
    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.BEFORE_NORMAL;
    }

    private static double getAmbientTemp(VentusData md) {
        RestorableProperties simParamsData = (RestorableProperties)md.getComponentData("SimParams.data");
        return simParamsData.get(SimParamsProps.defaultZoneTemp).get(SI.KELVIN);
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        SimpleAHSRoot simpleAHSRoot = (SimpleAHSRoot)md.getComponentData("SimpleAHS.data");
        for (SimpleAHS system : simpleAHSRoot.flatten(SimpleAHS.class)) {
            int indexSupply;
            int indexReturn;
            String name = system.getName();
            PrjData.Zone zoneReturn = new PrjData.Zone(null);
            prjData.zoneList.add(zoneReturn);
            prjData.nzone = prjData.zoneList.size();
            zoneReturn.nr = indexReturn = prjData.zoneList.size();
            zoneReturn.flags = 10;
            zoneReturn.ps = 0;
            zoneReturn.pc = 0;
            zoneReturn.pk = 0;
            zoneReturn.pl = 1;
            zoneReturn.relHt = 0.0;
            zoneReturn.vol = 0.0;
            zoneReturn.T0 = SimpleAHSZonePrjDataWriter.getAmbientTemp(md);
            zoneReturn.P0 = 0;
            zoneReturn.name = name + "(Ret)";
            zoneReturn.color = -1;
            zoneReturn.u_Ht = 0;
            zoneReturn.uT = 0;
            zoneReturn.uP = 0;
            zoneReturn.uV = 0;
            zoneReturn.cdaxis = 0;
            zoneReturn.cdvf = 0;
            zoneReturn.cfd = 0;
            PrjData.Zone zoneSupply = new PrjData.Zone(null);
            prjData.zoneList.add(zoneSupply);
            prjData.nzone = prjData.zoneList.size();
            zoneSupply.nr = indexSupply = prjData.zoneList.size();
            zoneSupply.flags = 10;
            zoneSupply.ps = 0;
            zoneSupply.pc = 0;
            zoneSupply.pk = 0;
            zoneSupply.pl = 1;
            zoneSupply.relHt = 0.0;
            zoneSupply.vol = 0.0;
            zoneSupply.T0 = SimpleAHSZonePrjDataWriter.getAmbientTemp(md);
            zoneSupply.P0 = 0;
            zoneSupply.name = name + "(Sup)";
            zoneSupply.color = -1;
            zoneSupply.u_Ht = 0;
            zoneSupply.uT = 0;
            zoneSupply.uP = 0;
            zoneSupply.uV = 0;
            zoneSupply.cdaxis = 0;
            zoneSupply.cdvf = 0;
            zoneSupply.cfd = 0;
            PrjData.AHS ahs = new PrjData.AHS(system);
            ahs.nr = prjData.ahsList.size() + 1;
            ahs.zoneR = zoneReturn.nr;
            ahs.zoneS = zoneSupply.nr;
            ahs.pathR = -1;
            ahs.pathX = -1;
            ahs.pathS = -1;
            ahs.name = name;
            ahs.desc = system.get(SimpleAHS.DESC);
            ahs.color = -1;
            prjData.ahsList.add(ahs);
            prjData.nahs = prjData.ahsList.size();
        }
    }
}

