/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ahssimple;

import java.util.Map;
import thunderheadeng.util.TypedProp;
import ventus.VentusApp;
import ventus.data.VentusData;
import ventus.feature.ahssimple.SimpleAHS;
import ventus.feature.ahssimple.SimpleAHSRoot;
import ventus.feature.comps.IPrjDataWriter;
import ventus.io.contamx.PrjData;

public class SimpleAHSPathPrjDataWriter
implements IPrjDataWriter {
    @Override
    public IPrjDataWriter.Order getOrder() {
        return IPrjDataWriter.Order.AFTER_NORMAL;
    }

    @Override
    public void addPrjData(VentusApp app, VentusData md, Map<TypedProp, Object> scenario, PrjData prjData) {
        SimpleAHSRoot simpleAHSRoot = (SimpleAHSRoot)md.getComponentData("SimpleAHS.data");
        for (SimpleAHS system : simpleAHSRoot.flatten(SimpleAHS.class)) {
            String name = system.getName();
            PrjData.AHS ahs = prjData.findAHS(system);
            PrjData.AirFlowPath fpRecirculation = new PrjData.AirFlowPath(null);
            fpRecirculation.vntsDesc = name + "_recirc";
            PrjData.AirFlowPath fpOutdoor = new PrjData.AirFlowPath(null);
            fpOutdoor.vntsDesc = name + "_outdoor";
            PrjData.AirFlowPath fpExhaust = new PrjData.AirFlowPath(null);
            fpExhaust.vntsDesc = name + "_exhaust";
            int indexRecirculation = prjData.airFlowPathList.size() == 0 ? 1 : prjData.airFlowPathList.size() + 1;
            int indexOutdoor = indexRecirculation + 1;
            int indexExhaust = indexOutdoor + 1;
            fpRecirculation.nr = indexRecirculation;
            fpRecirculation.flags = 16;
            fpRecirculation.pzn = ahs.zoneR;
            fpRecirculation.pzm = ahs.zoneS;
            fpRecirculation.pld = 1;
            fpRecirculation.relHt = 0.0;
            fpRecirculation.mult = 1.0;
            fpRecirculation.wazm = -1.0;
            fpRecirculation.Fahs = system.get(SimpleAHS.MINIMUM_OA_FLOW).getRawValue();
            fpRecirculation.icon = 0;
            fpRecirculation.dir = 6;
            fpRecirculation.u_Ht = 0;
            fpRecirculation.u_XY = 0;
            fpRecirculation.u_dp = 0;
            fpRecirculation.u_F = 0;
            fpOutdoor.nr = indexOutdoor;
            fpOutdoor.flags = 32;
            fpOutdoor.pzn = -1;
            fpOutdoor.pzm = ahs.zoneS;
            fpOutdoor.pld = 1;
            fpOutdoor.relHt = 0.0;
            fpOutdoor.mult = 1.0;
            fpOutdoor.wazm = -1.0;
            fpOutdoor.icon = 0;
            fpOutdoor.dir = 6;
            fpOutdoor.u_Ht = 0;
            fpOutdoor.u_XY = 0;
            fpOutdoor.u_dp = 0;
            fpOutdoor.u_F = 0;
            fpExhaust.nr = indexExhaust;
            fpExhaust.flags = 64;
            fpExhaust.pzn = ahs.zoneR;
            fpExhaust.pzm = -1;
            fpExhaust.pld = 1;
            fpExhaust.relHt = 0.0;
            fpExhaust.mult = 1.0;
            fpExhaust.wazm = -1.0;
            fpExhaust.icon = 0;
            fpExhaust.dir = 6;
            fpExhaust.u_Ht = 0;
            fpExhaust.u_XY = 0;
            fpExhaust.u_dp = 0;
            fpExhaust.u_F = 0;
            prjData.airFlowPathList.add(fpRecirculation);
            prjData.airFlowPathList.add(fpOutdoor);
            prjData.airFlowPathList.add(fpExhaust);
            prjData.npath = prjData.airFlowPathList.size();
            ahs.pathR = fpRecirculation.nr;
            ahs.pathX = fpExhaust.nr;
            ahs.pathS = fpOutdoor.nr;
        }
    }
}

