/*
 * Decompiled with CFR 0.152.
 */
package ventus.feature.ahs;

import java.awt.Component;
import java.util.function.BiFunction;
import javax.vecmath.Vector3d;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Pair;
import ventus.Intl;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.feature.ahs.AHSPoint;
import ventus.feature.ahs.AHSPointBuilder;
import ventus.feature.ahssimple.SimpleAHS;
import ventus.geom.Geometry;
import ventus.gui.APropEditPanel;
import ventus.gui.IPropEditCommand;
import ventus.gui.MerlinComboBox;
import ventus.gui.MerlinUDF;
import ventus.gui.guiUtil;
import ventus.mv.gui.CreatePanel;
import ventus.mv.gui.RoomLocPanel;

public class NewAHSPointPanel
extends APropEditPanel<AHSPointBuilder> {
    private static final long serialVersionUID = 1L;
    private final guiTextField d_nameFld;
    private final guiLabel d_dFlowRateLbl;
    private final guiPanel d_locPnl;
    private final MerlinUDF d_dFlowRateFld;
    private final guiComboBox<AHSPoint.Types> d_typesCB;
    private guiComboBox<SimpleAHS> d_simpleAHSComboBox;

    public NewAHSPointPanel(VentusData vd) {
        super(AHSPoint.NAME, AHSPoint.DESIGN_FLOW_RATE, AHSPoint.TYPES);
        BiFunction<String, String, guiLabel> lbl = (desc, tt) -> guiUtil.lbl(desc, tt);
        this.d_nameFld = this.initValueField(new guiTextField(), new IPropEditCommand[0]);
        this.d_nameFld.setToolTipText(Intl.intl("Name"));
        this.d_dFlowRateLbl = lbl.apply(Intl.intl("Design Flow Rate:"), Intl.intl("Enter the design maximum airflow rate for the supply or return."));
        this.d_dFlowRateFld = this.initValueField(new MerlinUDF(17, DoubleVR.above(0.0, true)), new IPropEditCommand[0]);
        this.d_typesCB = this.initComboBox(guiUtil.newCombo(types -> new Pair<String, String>(guiUtil.encodeToHtmlLabel(types.name), guiUtil.encodeToHtmlLabel(types.desc)), AHSPoint.Types.values()));
        this.d_simpleAHSComboBox = this.initComboBox(new MerlinComboBox(vd, SimpleAHS.class, (IMerlinObj[])new SimpleAHS[0]));
        guiPanel d_namePnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(d_namePnl);
        gb.addRow(this.d_nameFld, 0, 1.0);
        this.d_locPnl = new guiPanel();
        gb = new GridBagHelper(this.d_locPnl);
        RoomLocPanel<AHSPointBuilder> locPanel = new RoomLocPanel<AHSPointBuilder>((props, room, normal, loc) -> props.setLocation((ISchematicRoom)room, (Vector3d)normal, loc.getPoint3dValue(Geometry.LENGTH_UNIT)), props -> new UnitPoint3D(props.get(AHSPoint.LOCATION), Geometry.LENGTH_UNIT), AHSPoint.getRoomFilter(), AHSPoint.LOCATION);
        gb.addRow(locPanel);
        guiPanel propsPnl = new guiPanel();
        gb = new GridBagHelper(propsPnl);
        gb.rowSpace = 1;
        gb.addRow(lbl.apply(Intl.intl("Types:"), Intl.intl("Define the type of an AHS Zone Point.")), this.d_typesCB, 1.0);
        gb.addRow(this.d_dFlowRateLbl, this.d_dFlowRateFld, 0, 1.0);
        guiPanel ahsPnl = new guiPanel();
        gb = new GridBagHelper(ahsPnl);
        gb.rowSpace = 1;
        gb.addRow(lbl.apply(Intl.intl("Air Handling System:"), Intl.intl("Define the associated Air Handling System")), this.d_simpleAHSComboBox, 1.0);
        CreatePanel<AHSPointBuilder> createPnl = new CreatePanel<AHSPointBuilder>(Intl.intl("Create"), builder -> builder.isValid(), (btn, builder) -> builder.create((Component)btn), AHSPointBuilder.VALID_PROPS);
        this.addSection(d_namePnl);
        this.addSeparator();
        this.addSection(propsPnl);
        this.addSeparator();
        this.addSection(ahsPnl);
        this.addSeparator();
        this.addSection(this.d_locPnl);
        this.addSeparator();
        this.addSection(createPnl);
    }

    @Override
    protected void updateFromProps(AHSPointBuilder props) {
        this.d_nameFld.setText(props.get(AHSPoint.NAME));
        this.d_typesCB.setSelectedItem((Object)props.get(AHSPoint.TYPES));
        SimpleAHS system = props.get(AHSPoint.AHS);
        if (this.d_simpleAHSComboBox.contains(system)) {
            this.d_simpleAHSComboBox.setSelectedItem(system);
        } else {
            this.d_simpleAHSComboBox.setSelectedIndex(0);
        }
        this.d_dFlowRateFld.setValue(props.get(AHSPoint.DESIGN_FLOW_RATE));
        boolean locVis = AHSPoint.requiresLocation(props);
        this.d_locPnl.setVisible(locVis);
    }

    @Override
    protected void updateToProps(AHSPointBuilder props) {
        props.set(AHSPoint.NAME, this.d_nameFld.getValue());
        props.set(AHSPoint.TYPES, this.d_typesCB.getSelectedItem());
        props.set(AHSPoint.AHS, this.d_simpleAHSComboBox.getSelectedItem());
        props.set(AHSPoint.DESIGN_FLOW_RATE, (UnitDouble)this.d_dFlowRateFld.getValue());
    }
}

