/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.schematics.geom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.AFace;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.CancelObjectPicking;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.LineConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Sets;
import thunderheadeng.util.SoftCachedValue;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.builders.CorridorUtil;
import ventus.data.AMerlinObj;
import ventus.data.ICompElement;
import ventus.data.NamedMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.ISchematicObj;
import ventus.data.schematics.geom.ASchematicComp;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.data.schematics.geom.ISchematicConnector;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.SchematicDoor;
import ventus.data.schematics.geom.SchematicDoorDir;
import ventus.data.schematics.geom.SchematicGeomUtil;
import ventus.data.value.IVariant;
import ventus.geom.GeomUtil;
import ventus.geom.Geometry;
import ventus.geom.IMerlinDispProps;
import ventus.geom.StrutUtil;
import ventus.io.inferno.InfernoGeom;
import ventus.io.inferno.InfernoType;
import ventus.util.Dependencies;

public class SchematicCorridor
extends ASchematicComp
implements Serializable,
ISchematicRoom,
IDirectDependent<VentusData> {
    static final long serialVersionUID = 1L;
    public static final Object WIDTH = "Corridor.WIDTH";
    public static final Object DOOR1 = "Corridor.DOOR1";
    public static final Object DOOR2 = "Corridor.DOOR2";
    public static final Object TOP_DOOR = "Corridor.TOP_DOOR";
    public static final Object BOTTOM_DOOR = "Corridor.BOTTOM_DOOR";
    public static final Object LENGTH = "Corridor.LENGTH";
    public static final Object SLOPE = "Corridor.SLOPE";
    public static final Set<Object> PROP_TYPES = Sets.appendLHS(ASchematicComp.PROP_TYPES, WIDTH, LENGTH, SLOPE, DOOR1, DOOR2, TOP_DOOR, BOTTOM_DOOR, VentusData.MATERIAL);
    public static final UnitDouble DOOR_STAIR_WIDTH = new UnitDouble(Double.NaN, SI.METER);
    private Point3d[] d_boundary;
    private DoorInfo d_door1;
    private final long d_door1ResultsId = -1L;
    private DoorInfo d_door2;
    private final long d_door2ResultsId = -1L;
    private Vector2d d_dirVec;
    private final boolean d_capacityEnabled = false;
    private IMaterial d_material;
    @SkipDep
    private transient Set<ISchematicObj> d_containedObjs;
    @SkipDep
    private transient Collection<Pair<ISchematicComp, ISchematicComp.ConflictType>> d_conflicts;

    public SchematicCorridor(String name, ISchematicRoom conn1, ISchematicRoom conn2, LineSeg attachedEdge1, LineSeg attachedEdge2, Point3d[] boundary) {
        super(name);
        this.d_door1 = new DoorInfo(this, attachedEdge1, null, null, conn1);
        this.d_door2 = new DoorInfo(this, attachedEdge2, null, null, conn2);
        this.d_containedObjs = new LinkedIdentityHashSet<ISchematicObj>();
        this.d_conflicts = Collections.EMPTY_LIST;
        this.d_boundary = boundary;
    }

    public SchematicCorridor(String name, ISchematicRoom conn1, ISchematicRoom conn2, CorridorGeom geom) {
        super(name);
        this.d_door1 = new DoorInfo(this, null, null, null, conn1);
        this.d_door2 = new DoorInfo(this, null, null, null, conn2);
        this.setGeom(geom, false);
        this.d_containedObjs = new LinkedIdentityHashSet<ISchematicObj>();
        this.d_conflicts = Collections.EMPTY_LIST;
        this.d_boundary = geom.boundary;
    }

    @Override
    public boolean surrogateEquals(Object obj) {
        return this.surrogateEqualsHelper(obj);
    }

    private int surrogateHashCode() {
        return this.hashCode();
    }

    @Override
    protected boolean surrogateEqualsHelper(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SchematicCorridor)) {
            return false;
        }
        SchematicCorridor corr = (SchematicCorridor)obj;
        return super.surrogateEqualsHelper(corr) && theUtil.equal(this.d_door1, corr.d_door1) && theUtil.equal(this.d_door2, corr.d_door2) && Arrays.equals(this.d_boundary, corr.d_boundary) && Objects.equals(this.d_dirVec, corr.d_dirVec);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_containedObjs = new LinkedIdentityHashSet<ISchematicObj>();
        this.d_conflicts = Collections.EMPTY_LIST;
    }

    @Override
    public void restoreFrom(Object obj) {
        this.pauseUpdates();
        super.restoreFrom(obj);
        SchematicCorridor coor = (SchematicCorridor)obj;
        this.setGeom(coor.getGeom());
        this.setMaterial(coor.getMaterial());
        this.resumeUpdates();
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_containedObjs);
        oos.writeObject(this.d_door1.conn);
        oos.writeObject(this.d_door2.conn);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_containedObjs = (Set)ois.readObject();
        this.d_door1.conn = (ISchematicRoom)ois.readObject();
        this.d_door2.conn = (ISchematicRoom)ois.readObject();
    }

    @Override
    public ISchematicRoom.Type getType() {
        return ISchematicRoom.Type.ZONE;
    }

    @Override
    public void floorHeightChanged() {
    }

    public IMaterial getMaterial() {
        return this.d_material;
    }

    public void setMaterial(IMaterial mat) {
        if (Objects.equals(this.d_material, mat)) {
            return;
        }
        this.d_material = mat;
        this.changedEvt(new Object[0]);
    }

    public void setDirection(SchematicDoorDir dir) {
        Vector2d vec = null;
        if (dir != SchematicDoorDir.ALL) {
            Point3d[] boundary = this.getBoundary();
            LineSeg doorDir = new LineSeg(Util3D.getMidPoint(boundary[0], boundary[3]), Util3D.getMidPoint(boundary[1], boundary[2]));
            vec = dir.adjustForDoor(doorDir);
        }
        if (Objects.equals(vec, this.d_dirVec)) {
            return;
        }
        this.d_dirVec = vec;
        this.changedEvt(new Object[0]);
    }

    public SchematicDoorDir getDirection() {
        return SchematicDoorDir.toDir(this.d_dirVec);
    }

    public Vector2d getDirectionVec() {
        return this.d_dirVec;
    }

    public void setDirectionVec(Vector2d vec) {
        if (Objects.equals(vec, this.d_dirVec)) {
            return;
        }
        this.d_dirVec = vec;
        this.changedEvt(new Object[0]);
    }

    public Collection<? extends IParametric3D> getSharedEdges(ISchematicRoom room) {
        if (room != this.d_door1.conn && room != this.d_door2.conn) {
            return Collections.EMPTY_LIST;
        }
        Point3d[] boundary = this.getBoundary();
        ArrayList<LineSeg3D> edges = new ArrayList<LineSeg3D>(2);
        if (room == this.d_door1.conn) {
            edges.add(new LineSeg3D(boundary[0], boundary[1]));
        }
        if (room == this.d_door2.conn) {
            edges.add(new LineSeg3D(boundary[2], boundary[3]));
        }
        return edges;
    }

    @Override
    public void connectTo(ISchematicObj obj) {
        if (!(obj instanceof ISchematicComp)) {
            this.d_containedObjs.add(obj);
            this.changedEvt(VentusData.CONNECTION);
        }
    }

    @Override
    public void disconnectFrom(ISchematicObj obj) {
        if (SchematicGeomUtil.removeConflict(this.d_conflicts, obj)) {
            this.d_conflicts.addAll(this.computeConflicts(false, true));
        }
        if (obj instanceof ISchematicRoom) {
            ISchematicRoom conn = (ISchematicRoom)obj;
            if (conn == this.d_door1.conn) {
                this.d_door1.conn = null;
            } else if (conn == this.d_door2.conn) {
                this.d_door2.conn = null;
            }
            this.markTopoDirty();
            this.changedEvt(new Object[0]);
        } else {
            this.d_containedObjs.remove(obj);
            this.changedEvt(VentusData.CONNECTION);
        }
    }

    @Override
    public boolean hasOpenSpots(Class<? extends ISchematicObj> type) {
        return true;
    }

    @Override
    public Collection<Pair<ISchematicComp, ISchematicComp.ConflictType>> getConflicts() {
        return this.d_conflicts;
    }

    public DoorInfo getDoor1() {
        return this.d_door1;
    }

    public void setDoor1(DoorInfo di) {
        this.d_door1.restoreFrom(di);
    }

    public DoorInfo getDoor2() {
        return this.d_door2;
    }

    public void setDoor2(DoorInfo di) {
        this.d_door2.restoreFrom(di);
    }

    public DoorInfo getTopDoor() {
        return this.isDoor1Bottom() ? this.d_door2 : this.d_door1;
    }

    public void setTopDoor(DoorInfo di) {
        if (this.isDoor1Bottom()) {
            this.setDoor2(di);
        } else {
            this.setDoor1(di);
        }
    }

    public DoorInfo getBottomDoor() {
        return this.isDoor1Bottom() ? this.d_door1 : this.d_door2;
    }

    public void setBottomDoor(DoorInfo di) {
        if (this.isDoor1Bottom()) {
            this.setDoor1(di);
        } else {
            this.setDoor2(di);
        }
    }

    protected boolean isDoor1Bottom() {
        return SchematicCorridor.isDoor1Bottom(this.d_door1.attachedEdge.p1, this.d_door2.attachedEdge.p1);
    }

    private static boolean isDoor1Bottom(Point3d p1Door1, Point3d p1Door2) {
        return p1Door1.z <= p1Door2.z;
    }

    @Override
    public void getConnectors(Collection<? super ISchematicConnector> connectors) {
        String name1 = String.format(Intl.intl("%s door 1"), this.getName());
        String name2 = String.format(Intl.intl("%s door 2"), this.getName());
        connectors.add(this.d_door1.convertToDoor(this, name1));
        connectors.add(this.d_door2.convertToDoor(this, name2));
    }

    public Point3d[] getBoundary() {
        return this.d_boundary;
    }

    private static LineSeg3D convert(LineSeg ls) {
        return new LineSeg3D(ls.p1, ls.p2);
    }

    @Override
    public Object clone() {
        SchematicCorridor clone = (SchematicCorridor)super.clone();
        clone.d_containedObjs = new LinkedIdentityHashSet<ISchematicObj>();
        clone.d_door1 = this.d_door1.clone(clone);
        clone.d_door2 = this.d_door2.clone(clone);
        clone.d_conflicts = Collections.EMPTY_LIST;
        return clone;
    }

    protected void markTopoDirty() {
        this.changedEvt(VentusData.TOPOLOGY);
    }

    protected CorridorUtil.IBoundaryGen getBoundaryGen() {
        double tloc = Util3D.tOnLineSeg(this.d_door1.attachedEdge.p1, this.d_door1.attachedEdge.p2, Util3D.getMidPoint(this.d_boundary[0], this.d_boundary[1]));
        return new CorridorUtil.SlopedBoundaryGen(SchematicCorridor.getSlope(this.d_door1.attachedEdge, tloc, this.d_door2.attachedEdge));
    }

    private CorridorUtil.SearchResult refindCorr() {
        int m;
        Point3d[] points = this.d_boundary;
        double maxAngle = CorridorUtil.DEF_MAX_EDGE_ANGLE.get(SI.RADIAN);
        Predicate<CorridorUtil.SearchResult> corrTest = r -> r.geom.boundary.length == 4;
        CorridorUtil.SearchResult corr = CorridorUtil.findCorr((VentusData)this.getDomain(), points[0], points[1], points[2], points[3], maxAngle, 1.0E-6, 3, corrTest);
        if (corr != null) {
            return corr;
        }
        for (m = 0; m < 2; ++m) {
            corr = CorridorUtil.findCorr((VentusData)this.getDomain(), points[0], points[1], points[m + 2], maxAngle, 1.0E-6, false, 3, corrTest);
            if (corr == null) continue;
            return corr;
        }
        for (m = 0; m < 2; ++m) {
            corr = CorridorUtil.findCorr((VentusData)this.getDomain(), points[2], points[3], points[m], maxAngle, 1.0E-6, false, 1, corrTest);
            if (corr == null) continue;
            return corr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateTopo() {
        this.pauseUpdates();
        try {
            Point3d[] points = this.d_boundary;
            CorridorUtil.SearchResult corr = this.refindCorr();
            if (corr != null) {
                UnitDouble d1 = this.d_door1.width;
                UnitDouble d2 = this.d_door2.width;
                this.d_door1.conn = corr.room1;
                this.d_door2.conn = corr.room2;
                CorridorGeom geom = corr.geom;
                geom = geom.setDirection(this.d_dirVec);
                this.setGeom(geom, false);
                this.d_door1.width = d1;
                this.d_door2.width = d2;
                boolean bl = true;
                return bl;
            }
            Collection<CorridorUtil.EdgeSeg> startSegs = CorridorUtil.getValidStartingSegs((VentusData)this.getDomain(), points[0], points[1], 1.0E-6, 3);
            if (!startSegs.isEmpty()) {
                this.d_door1.conn = startSegs.iterator().next().room;
                this.d_door2.conn = null;
                this.changedEvt(new Object[0]);
                boolean bl = true;
                return bl;
            }
            startSegs = CorridorUtil.getValidStartingSegs((VentusData)this.getDomain(), points[2], points[3], 1.0E-6, 3);
            if (!startSegs.isEmpty()) {
                this.d_door1.conn = null;
                this.d_door2.conn = startSegs.iterator().next().room;
                this.changedEvt(new Object[0]);
                boolean bl = true;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.d_conflicts = this.computeConflicts(true, true);
            this.resumeUpdates();
        }
    }

    private Collection<Pair<ISchematicComp, ISchematicComp.ConflictType>> computeConflicts(boolean edge, boolean manifold) {
        VentusData md = (VentusData)this.getDomain();
        if (md == null) {
            return Collections.EMPTY_LIST;
        }
        Point3d[] boundary = this.getBoundary();
        if (boundary == null) {
            return Collections.EMPTY_LIST;
        }
        return SchematicGeomUtil.computeConflicts(md, Filters.reject(this), edge, manifold, 1, new LineSeg(boundary[0], boundary[1]), new LineSeg(boundary[2], boundary[3]));
    }

    @Override
    public Collection<? extends ISchematicObj> getConnections() {
        ArrayList<ISchematicObj> objs = new ArrayList<ISchematicObj>(this.d_containedObjs.size() + 2);
        if (this.d_door1.conn != null) {
            objs.add(this.d_door1.conn);
        }
        if (this.d_door2.conn != null) {
            objs.add(this.d_door2.conn);
        }
        objs.addAll(this.d_containedObjs);
        for (Pair<ISchematicComp, ISchematicComp.ConflictType> overlap : this.d_conflicts) {
            objs.add((ISchematicObj)overlap.v1);
        }
        return objs;
    }

    @Override
    public Collection<AMerlinObj> getConnObjectsForEnable(VentusData md) {
        ArrayList<AMerlinObj> connObjects = new ArrayList<AMerlinObj>();
        ArrayList allReferences = new ArrayList();
        Dependencies.getObjReferences(md, o -> o == this, (source, target) -> allReferences.add((AMerlinObj)source));
        return connObjects;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == WIDTH) {
            this.setWidth((UnitDouble)value);
        } else if (property == DOOR1) {
            this.setDoor1((DoorInfo)value);
        } else if (property == DOOR2) {
            this.setDoor2((DoorInfo)value);
        } else if (property == TOP_DOOR) {
            this.setTopDoor((DoorInfo)value);
        } else if (property == BOTTOM_DOOR) {
            this.setBottomDoor((DoorInfo)value);
        } else if (property == VentusData.MATERIAL) {
            this.setMaterial(((IMaterial[])value)[0]);
        } else {
            super.setProperty(property, value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == WIDTH) {
            return this.getWidth();
        }
        if (property == DOOR1) {
            return this.getDoor1().clone();
        }
        if (property == DOOR2) {
            return this.getDoor2().clone();
        }
        if (property == TOP_DOOR) {
            return this.getTopDoor().clone();
        }
        if (property == BOTTOM_DOOR) {
            return this.getBottomDoor().clone();
        }
        if (property == LENGTH) {
            return this.getLength();
        }
        if (property == SLOPE) {
            return this.getSlope();
        }
        if (property == AREA) {
            return this.getArea();
        }
        if (property == VOLUME) {
            return this.getVolume();
        }
        if (property == HEIGHT) {
            return this.getHeight();
        }
        if (property == VentusData.MATERIAL) {
            return new IMaterial[]{this.getMaterial()};
        }
        return super.getProperty(property);
    }

    public UnitDouble getLength() {
        UnitDouble area = this.getArea();
        UnitDouble wid = this.getWidth();
        Unit widsq = wid.getUnit().pow(2);
        double len = area.getValue(widsq) / wid.getValue(wid.getUnit());
        return new UnitDouble(len, wid.getUnit());
    }

    public double getSlope() {
        Point3d[] points = this.getBoundary();
        if (points == null) {
            return Double.NaN;
        }
        Point3d mid1 = Util3D.getMidPoint(points[0], points[1]);
        Point3d mid2 = Util3D.getMidPoint(points[2], points[3]);
        Vector3d dir = Util3D.vector(mid1, mid2);
        double rise = dir.z;
        double run = Math.sqrt(dir.x * dir.x + dir.y * dir.y);
        return rise / run;
    }

    public void setWidth(UnitDouble width) {
        double[] adjusted2;
        if (this.getWidth().epsilonEquals(width, 1.0E-6) || width.getValueNoUnit() <= 0.0) {
            return;
        }
        Function<DoorInfo, double[]> adjustPoints = di -> {
            double twidth = width.getValue(Geometry.LENGTH_UNIT) / di.attachedEdge.length();
            int i = di == this.d_door1 ? 0 : 2;
            double midt = Util3D.tOnLineSeg(di.attachedEdge.p1, di.attachedEdge.p2, Util3D.getMidPoint(this.d_boundary[i], this.d_boundary[i + 1]));
            double loc1 = midt - twidth * 0.5;
            double loc2 = midt + twidth * 0.5;
            return new double[]{loc1, loc2};
        };
        double[] adjusted1 = adjustPoints.apply(this.d_door1);
        Point3d[] newBoundary = StrutUtil.calcStrutBoundaryFull(this.d_door1.attachedEdge, this.d_door2.attachedEdge, adjusted1[0], adjusted1[1], (adjusted2 = adjustPoints.apply(this.d_door2))[0], adjusted2[1]);
        if (newBoundary != null) {
            this.d_boundary = newBoundary;
            this.markTopoDirty();
            this.changedEvt(WIDTH);
        }
    }

    public UnitDouble getWidth() {
        double width = Math.max(this.d_boundary[0].distance(this.d_boundary[1]), this.d_boundary[2].distance(this.d_boundary[3]));
        return new UnitDouble(width, SI.METER);
    }

    public Collection<ISchematicComp> split(Point3d l1, Point3d l2) {
        return new ArrayList<ISchematicComp>(0);
    }

    public boolean add(ISchematicComp comp2) {
        return false;
    }

    public boolean sub(ISchematicComp comp2) {
        return false;
    }

    @Override
    public Model getModel() {
        Model model = new Model();
        CorridorGeom geom = this.getCorrGeom();
        for (IFace face : thunderheadeng.geometry.objs.GeomUtil.explode(geom, IFace.class)) {
            GeomUtil.addFaceToModel(face, model, 0, 0.0, 0.0);
        }
        for (ICurve curve : thunderheadeng.geometry.objs.GeomUtil.explode(geom, ICurve.class)) {
            GeomUtil.addCurveToModel(curve, model, 1, 0.0);
        }
        return model;
    }

    @Override
    public boolean isModelCached() {
        return false;
    }

    private IPrimProps getFaceProps(IMerlinDispProps props) {
        return props.getFaceProps(this, IMerlinDispProps.SchematicType.CORRIDOR, this.d_material, this.getColor(), this.getOpacity());
    }

    private IPrimProps getBoundaryProps(IMerlinDispProps props) {
        return props.getEdgeProps(this, IMerlinDispProps.SchematicType.BOUNDARY, null, this.getOpacity());
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps dprops) {
        DispCorridorGeom cgeom;
        if (!(dprops instanceof IMerlinDispProps)) {
            return DisplayGeom.EMPTY;
        }
        IMerlinDispProps props = (IMerlinDispProps)dprops;
        int drawOptions = props.getCorridorDrawOptions();
        IGeom geom = cgeom = new DispCorridorGeom(this.getCorrGeom(), (drawOptions & 2) != 0);
        IGeom baseGeom = cgeom.getGeom(false);
        if (thunderheadeng.geometry.objs.GeomUtil.isEmpty(baseGeom)) {
            return DisplayGeom.EMPTY;
        }
        GeomGroup ggroup = (GeomGroup)cgeom.getGeom(false);
        assert (ggroup.children.size() >= 2);
        PropsBuilder psrc = new PropsBuilder();
        IGeom faces = ggroup.children.get(0);
        IGeom border = ggroup.children.get(1);
        IPrimProps fprops = this.getFaceProps(props);
        IPrimProps bprops = this.getBoundaryProps(props);
        psrc.add(fprops, faces.getNumPrims(1));
        psrc.add(bprops, border.getNumPrims(2));
        int dispIx = 2;
        IPrimProps eprops = props.getEdgeProps(this, IMerlinDispProps.SchematicType.CORRIDOR, null, this.getOpacity());
        if (cgeom.dirArrow) {
            IGeom arrow = ggroup.children.get(dispIx++);
            IPrimProps.GenericProps aprops = new IPrimProps.GenericProps(eprops.getColor(), null, 2.0, IPrimProps.DEF_STIPPLE, 1.0, 0);
            psrc.add(aprops, arrow.getNumPrims(7));
        }
        geom = this.appendOnewayGeom(props, geom, psrc, cgeom);
        IPropsSrc propsSrc = psrc.finalizeProps();
        IGeomNode node = GeomNodeUtil.newNode(geom);
        node = GeomUtil.finalizeTexCoords(node, propsSrc);
        return new DisplayGeom(node, propsSrc);
    }

    protected IGeom appendOnewayGeom(IMerlinDispProps props, IGeom geom, PropsBuilder propsBuilder, CorridorGeom cgeom) {
        if (this.getDirectionVec() != null) {
            Point3d[] boundary = cgeom.getBoundary();
            IGeom dirGeom = SchematicDoorDir.generateDisplayGeom(this, props, this.getDirectionVec(), boundary, this.getDoor1().getRoom(), this.getDoor2().getRoom(), propsBuilder);
            if (dirGeom != null) {
                geom = thunderheadeng.geometry.objs.GeomUtil.group(geom, dirGeom);
            }
        }
        return geom;
    }

    @Override
    public void getInfernoGeom(List<InfernoGeom> igeoms, IMerlinDispProps dprops) {
        Point3d[] boundary = this.d_boundary;
        assert (boundary != null);
        ArrayList<AFace> faces = new ArrayList<AFace>(3);
        if (Util3D.areCoplanar(1.0E-6, boundary)) {
            faces.add(new Quad(boundary[0], boundary[1], boundary[2], boundary[3]));
        } else {
            faces.add(new Triangle(boundary[0], boundary[1], boundary[2]));
            faces.add(new Triangle(boundary[0], boundary[2], boundary[3]));
        }
        IGeom fgeom = thunderheadeng.geometry.objs.GeomUtil.group(faces);
        igeoms.add(new InfernoGeom(this, InfernoType.STAIR, fgeom, this.getFaceProps(dprops)));
        PolyLine lBoundary = new PolyLine(boundary[0], boundary[1], boundary[2], boundary[3], boundary[0]);
        igeoms.add(new InfernoGeom(this, InfernoType.BOUNDARY, lBoundary, this.getBoundaryProps(dprops)));
        ArrayList connectors = new ArrayList();
        this.getConnectors(connectors);
        for (ISchematicConnector connector : connectors) {
            connector.getInfernoGeom(igeoms, dprops);
        }
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getCorrGeom());
    }

    public CorridorGeom getCorrGeom() {
        return new CorridorGeom(this.d_door1.attachedEdge, this.d_door2.attachedEdge, this.d_door1.width != null ? Double.valueOf(this.d_door1.width.getValue(Geometry.LENGTH_UNIT)) : null, this.d_door2.width != null ? Double.valueOf(this.d_door2.width.getValue(Geometry.LENGTH_UNIT)) : null, this.d_dirVec, this.d_boundary);
    }

    @Override
    public void setGeom(IGeomNode node) {
        IGeom geom = node.flatten().getLocalGeom();
        if (!(geom instanceof CorridorGeom)) {
            return;
        }
        this.setGeom((CorridorGeom)geom, true);
    }

    public void setGeom(CorridorGeom geom, boolean markTopoDirty) {
        this.d_door1.attachedEdge = geom.edge1;
        this.d_door2.attachedEdge = geom.edge2;
        this.d_door1.width = SchematicCorridor.newLenVal(this.d_door1.width, geom.door1Width);
        this.d_door2.width = SchematicCorridor.newLenVal(this.d_door2.width, geom.door2Width);
        this.d_dirVec = geom.dirVec;
        this.d_boundary = geom.boundary;
        if (markTopoDirty) {
            this.markTopoDirty();
        }
        this.changedEvt(new Object[0]);
    }

    private static UnitDouble newLenVal(UnitDouble oldVal, Double newVal) {
        if (newVal == null) {
            return null;
        }
        if (oldVal == null) {
            return new UnitDouble(newVal, Geometry.LENGTH_UNIT);
        }
        return UnitDouble.from(newVal, Geometry.LENGTH_UNIT, oldVal.getUnit());
    }

    public Collection<ISchematicComp> separate() {
        return Collections.EMPTY_LIST;
    }

    public Collection<? extends ISchematicComp> addBoundary(Point3d p1, Point3d p2, double tol) {
        return Arrays.asList(this);
    }

    @Override
    public UnitDouble getArea() {
        Point3d[] boundary = this.getBoundary();
        double area = boundary == null ? 0.0 : Util3D.simplePolygonArea(Arrays.asList(boundary));
        return new UnitDouble(area, Geometry.AREA_UNIT);
    }

    public static double getSlope(LineSeg edge1, double edgeT, LineSeg edge2) {
        Vector3d planeNormal = Util3D.vectorN(edge1.p1, edge1.p2);
        Point3d pe1 = edge1.evaluate(edgeT);
        Plane3d plane = new Plane3d(planeNormal, pe1);
        Vector3d dir2 = edge2.getTangent(0.0, ICurve.Orient.POSITIVE, false);
        Point3d pe2 = Inter3D.linePlaneIntersection(edge2.p1, dir2, plane, 1.0E-6);
        if (pe2 == null) {
            return 0.0;
        }
        Vector3d dir = Util3D.vector(pe1, pe2);
        double rise = dir.z;
        double run = Math.sqrt(dir.x * dir.x + dir.y * dir.y);
        return rise / run;
    }

    private static double getMaxWidth(Point3d[] boundary) {
        double maxWidth = boundary[0].distance(boundary[1]);
        if (boundary.length > 2) {
            maxWidth = Math.max(maxWidth, boundary[2].distance(boundary[3]));
        }
        return maxWidth;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        deps.add(DLink.WEAK, this.getMaterial());
    }

    @Override
    public void replaceDependency(VentusData md, Object old, Object replacement) {
        super.replaceDependency(md, old, replacement);
        if (old == this.d_material) {
            this.setMaterial((IMaterial)replacement);
        }
    }

    public static class DoorInfo
    extends NamedMerlinObj
    implements Serializable,
    ICompElement,
    Cloneable,
    ISurrogate {
        static final long serialVersionUID = 1L;
        public static final Object WIDTH = "DoorInfo.WIDTH";
        public static final Set<Object> PROP_TYPES = Sets.fromArrayLHS(SchematicDoor.WIDTH, WIDTH, ISchematicConnector.STATE);
        private SchematicCorridor corridor;
        private LineSeg attachedEdge;
        private UnitDouble width;
        private IVariant<Boolean> state;
        @SkipDep
        private ISchematicRoom conn;

        public DoorInfo(SchematicCorridor corridor, LineSeg attachedEdge, UnitDouble width, IVariant<Boolean> state, ISchematicRoom conn) {
            this.corridor = corridor;
            this.attachedEdge = attachedEdge;
            this.width = width;
            this.state = state;
            this.conn = conn;
        }

        @Override
        public boolean surrogateEquals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            DoorInfo di = (DoorInfo)obj;
            return Objects.equals(di.width, this.width) && di.state.equals(this.state);
        }

        @Override
        public boolean changedEvt(Object ... changes) {
            return this.corridor != null && this.corridor.changedEvt(changes);
        }

        public void restoreFrom(DoorInfo di) {
            this.attachedEdge = di.attachedEdge;
            this.width = di.width;
            this.state = di.state;
            this.changedEvt(new Object[0]);
        }

        @Override
        public DoorInfo clone() {
            return this.clone(null);
        }

        public DoorInfo clone(SchematicCorridor parent) {
            DoorInfo clone = (DoorInfo)super.clone();
            clone.corridor = parent;
            clone.conn = null;
            return clone;
        }

        @Override
        public Set<Object> getPropTypes(int options) {
            return PROP_TYPES;
        }

        public UnitDouble getWidth() {
            return this.width == null ? DOOR_STAIR_WIDTH : this.width;
        }

        public void setWidth(UnitDouble width) {
            this.width = width == DOOR_STAIR_WIDTH ? null : width;
            this.changedEvt(new Object[0]);
        }

        public void setState(IVariant<Boolean> state) {
            if (state.equals(this.state)) {
                return;
            }
            this.state = state;
            this.changedEvt(new Object[0]);
        }

        public IVariant<Boolean> getState() {
            return this.state;
        }

        public LineSeg getEdge() {
            return this.attachedEdge;
        }

        public ISchematicRoom getRoom() {
            return this.conn;
        }

        public SchematicDoor convertToDoor(SchematicCorridor corridor, String name) {
            LineSeg edge = this == corridor.d_door1 ? new LineSeg(corridor.d_boundary[0], corridor.d_boundary[1]) : new LineSeg(corridor.d_boundary[2], corridor.d_boundary[3]);
            UnitDouble width = this.getActualWidth(corridor);
            Point3d[] boundary = StrutUtil.calcStrutBoundary(edge, new StrutUtil.StrutParam(0.5, width.get(Geometry.LENGTH_UNIT)));
            SchematicDoor door = new SchematicDoor(name, false, this.conn, corridor, SchematicCorridor.convert(edge), SchematicCorridor.convert(edge), boundary);
            return door;
        }

        public UnitDouble getActualWidth() {
            return this.getActualWidth(this.corridor);
        }

        public UnitDouble getActualWidth(SchematicCorridor corridor) {
            double maxWidth = this == corridor.d_door1 ? corridor.d_boundary[0].distance(corridor.d_boundary[1]) : corridor.d_boundary[2].distance(corridor.d_boundary[3]);
            UnitDouble maxWidthU = new UnitDouble(maxWidth, Geometry.LENGTH_UNIT);
            if (this.width == null) {
                return maxWidthU;
            }
            return UnitDouble.min(maxWidthU, this.width);
        }

        @Override
        public <T> void setProperty(Object property, T value) {
            if (property == WIDTH) {
                this.setWidth((UnitDouble)value);
            } else if (property == ISchematicConnector.STATE) {
                this.setState((IVariant)value);
            }
        }

        @Override
        public Object getProperty(Object property) {
            if (property == WIDTH) {
                return this.getWidth();
            }
            if (property == SchematicDoor.WIDTH) {
                return this.getActualWidth();
            }
            if (property == ISchematicConnector.STATE) {
                return this.state;
            }
            return ICompElement.NOT_SUPPORTED;
        }
    }

    public static class CorridorGeom
    implements IGeom,
    Serializable,
    IManipulatable {
        static final long serialVersionUID = 1L;
        public final LineSeg edge1;
        public final LineSeg edge2;
        public final Double door1Width;
        public final Double door2Width;
        public final Vector2d dirVec;
        public final Point3d[] boundary;
        private transient SoftCachedValue<IGeom> d_geom = new SoftCachedValue();
        private transient SoftCachedValue<IGeom> d_selectableGeom = new SoftCachedValue();
        public static final double ARROW_LENGTH = 0.5;
        public static final double ARROW_WIDTH = 0.2;

        public CorridorGeom(LineSeg edge1, LineSeg edge2, Double door1Width, Double door2Width, Vector2d dirVec, Point3d[] boundary) {
            this.edge1 = edge1;
            this.edge2 = edge2;
            this.door1Width = door1Width;
            this.door2Width = door2Width;
            this.dirVec = dirVec;
            this.boundary = boundary;
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            in.defaultReadObject();
            this.d_geom = new SoftCachedValue();
            this.d_selectableGeom = new SoftCachedValue();
        }

        public boolean isValid() {
            return this.getBoundary() != null;
        }

        @Override
        public CorridorGeom optimize(IPointOptimizer pointOptimizer) {
            LineSeg e1 = this.edge1.optimize(pointOptimizer);
            LineSeg e2 = this.edge2.optimize(pointOptimizer);
            Object[] newBoundary = new Point3d[this.boundary.length];
            for (int m = 0; m < this.boundary.length; ++m) {
                newBoundary[m] = pointOptimizer.getExisting(this.boundary[m]);
            }
            if (e1 == this.edge1 && e2 == this.edge2 && Arrays.equals(this.boundary, newBoundary)) {
                return this;
            }
            return new CorridorGeom(e1, e2, this.door1Width, this.door2Width, this.dirVec, (Point3d[])newBoundary);
        }

        public CorridorGeom setDirection(Vector2d dirVec) {
            Vector2d vec = null;
            if (dirVec != null) {
                Point3d[] boundary = this.getBoundary();
                LineSeg doorDir = boundary.length == 2 ? new LineSeg(boundary[0], boundary[1]) : new LineSeg(Util3D.getMidPoint(boundary[0], boundary[3]), Util3D.getMidPoint(boundary[1], boundary[2]));
                vec = SchematicDoorDir.adjustForDoor(dirVec, doorDir);
            }
            if (Objects.equals(vec, this.dirVec)) {
                return this;
            }
            return new CorridorGeom(this.edge1, this.edge2, this.door1Width, this.door2Width, vec, this.boundary);
        }

        @Override
        public AABox getBoundingBox(AABox aabb) {
            return this.getGeom(false).getBoundingBox(aabb);
        }

        @Override
        public boolean isAxisAlignedBlock(TransformInfo parentXform) {
            return false;
        }

        @Override
        public boolean isShell() {
            return true;
        }

        @Override
        public int getNumPrims(int types) {
            return this.getGeom(false).getNumPrims(types);
        }

        @Override
        public Iterator<Byte> iteratePrimTypes(int offset) {
            return this.getGeom(false).iteratePrimTypes(offset);
        }

        @Override
        public boolean canExplode() {
            return true;
        }

        @Override
        public Collection<IGeom> explode(Collection<IGeom> prims) {
            prims.add(this.getGeom(false));
            return prims;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.INVERTIBLE;
        }

        @Override
        public IDOF getRetainingDOF() {
            return IDOF.INVERTIBLE;
        }

        @Override
        public IGeom transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d xform = ti.getMatrix();
            Double newDoor1Width = this.door1Width;
            Double newDoor2Width = this.door2Width;
            double edge1Length = this.edge1.p1.distance(this.edge1.p2);
            LineSeg e1 = new LineSeg(Util3D.xform(xform, this.edge1.p1), Util3D.xform(xform, this.edge1.p2));
            LineSeg e2 = new LineSeg(Util3D.xform(xform, this.edge2.p1), Util3D.xform(xform, this.edge2.p2));
            double e1Length = e1.p1.distance(e1.p2);
            Point3d[] newBoundary = new Point3d[this.boundary.length];
            for (int m = 0; m < this.boundary.length; ++m) {
                newBoundary[m] = Util3D.xform(xform, this.boundary[m]);
            }
            Vector3d v1 = Util3D.vector(this.boundary[0], this.boundary[1]);
            Vector3d v2 = Util3D.vector(this.boundary[0], this.boundary[2]);
            Vector3d normal = Util3D.cross(v1, v2);
            normal.normalize();
            double zdot = normal.dot(GeomConstants.VEC3D_ZPOS);
            if (theUtil.lt0(zdot, 1.0E-6)) {
                e1 = new LineSeg(e1.p2, e1.p1);
                e2 = new LineSeg(e2.p2, e2.p1);
            }
            if (this.door1Width != null) {
                double tdw1 = this.door1Width / edge1Length;
                newDoor1Width = tdw1 * e1Length;
            }
            if (this.door2Width != null) {
                double tdw2 = this.door2Width / this.edge2.p1.distance(this.edge2.p2);
                newDoor2Width = tdw2 * e2.p1.distance(e2.p2);
            }
            Vector2d newOWVec = this.dirVec != null ? GeomUtil.to2d(Util3D.xform(xform, GeomUtil.to3d(this.dirVec, false)), true) : null;
            return new CorridorGeom(e1, e2, newDoor1Width, newDoor2Width, newOWVec, newBoundary);
        }

        @Override
        public void pickBox(Object source, IElemSource<Boolean> visFaceEdges, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelObjectPicking {
            this.getGeom(true).pickBox(source, visFaceEdges, filter, region, isects);
        }

        @Override
        public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, IElemSource<Boolean> creases, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
            this.getGeom(true).pickPoints(isects, filter, source, creases, rayBegin, rayDirN, maxDist, tester);
        }

        @Override
        public void find(ITest<AABox> test, IResult<? super IGeom.FoundPrimitive> result) {
            this.getGeom(true).find(test, result);
        }

        @Override
        public void getAll(IResult<? super IPrimitive> result) {
            this.getGeom(true).getAll(result);
        }

        public Point3d[] getBoundary() {
            return this.boundary;
        }

        public IGeom getGeom(boolean selectable) {
            if (!selectable) {
                return this.d_geom.get(() -> this.constructGeom(false));
            }
            return this.d_selectableGeom.get(() -> this.constructGeom(true));
        }

        protected boolean includeDirArrow() {
            return false;
        }

        protected boolean includeFaces() {
            return true;
        }

        protected boolean includeBorder() {
            return true;
        }

        protected IGeom constructGeom(boolean selectable) {
            boolean faces = this.includeFaces();
            boolean border = this.includeBorder();
            boolean dirArrow = this.includeDirArrow();
            Point3d[] corrPoints = this.getBoundary();
            if (corrPoints == null) {
                return EmptyGeom.INSTANCE;
            }
            ArrayList<Object> geoms = new ArrayList<Object>(3);
            if (faces) {
                if (Util3D.areCoplanar(1.0E-6, corrPoints)) {
                    geoms.add(new Quad(corrPoints[0], corrPoints[1], corrPoints[2], corrPoints[3]));
                } else {
                    geoms.add(new GeomGroup(Arrays.asList(new Triangle(corrPoints[0], corrPoints[1], corrPoints[2]), new Triangle(corrPoints[0], corrPoints[2], corrPoints[3]))));
                }
            }
            if (border) {
                if (selectable) {
                    geoms.add(new PolyLine(corrPoints[0], corrPoints[1], corrPoints[2], corrPoints[3], corrPoints[0]));
                } else {
                    geoms.add(new GeomGroup(Arrays.asList(new LineSeg(corrPoints[1], corrPoints[2]), new LineSeg(corrPoints[0], corrPoints[3]))));
                }
            }
            if (dirArrow) {
                geoms.add(CorridorGeom.generateArrow(this.edge1, this.edge2, corrPoints));
            }
            geoms.trimToSize();
            return new GeomGroup(geoms);
        }

        protected static IGeom generateArrow(LineSeg edge1, LineSeg edge2, Point3d[] border) {
            if (border[0].epsilonEquals(border[3], 1.0E-6) || border[1].epsilonEquals(border[2], 1.0E-6)) {
                return EmptyGeom.INSTANCE;
            }
            Point3d midBottom = Util3D.getMidPoint(border[0], border[1]);
            Point3d midTop = Util3D.getMidPoint(border[2], border[3]);
            if (!SchematicCorridor.isDoor1Bottom(edge1.p1, edge2.p1)) {
                Point3d temp = midBottom;
                midBottom = midTop;
                midTop = temp;
            }
            LineSeg line = new LineSeg(midBottom, midTop);
            Vector3d ldir = line.getTangent(0.0, ICurve.Orient.POSITIVE, true);
            ldir.scale(0.5);
            Point3d lp = Util3D.sub(midTop, (Tuple3d)ldir);
            Vector3d crossDir = Util3D.vectorN(border[3], border[2]);
            crossDir.scale(0.1);
            Point3d c1 = Util3D.sub(lp, (Tuple3d)crossDir);
            Point3d c2 = Util3D.add(lp, (Tuple3d)crossDir);
            Triangle arrow = new Triangle(c1, c2, midTop);
            TransformInfo xform = TransformUtil.translate(0.0, 0.0, 0.01).getInfo();
            arrow = arrow.transform(xform, 0);
            line = line.transform(xform, 0);
            return new GeomGroup(Arrays.asList(arrow, line));
        }

        protected CorridorGeom reverse() {
            double t2e2;
            CorridorGeom corr = this;
            Point3d[] points = corr.getBoundary();
            LineSeg edge = corr.edge2;
            double t1e1 = Util3D.tOnLineSeg(edge.p1, edge.p2, points[2]);
            double t2e1 = Util3D.tOnLineSeg(edge.p1, edge.p2, points[3]);
            edge = corr.edge1;
            double t1e2 = Util3D.tOnLineSeg(edge.p1, edge.p2, points[0]);
            CorridorGeom geom = CorridorUtil.findBoundaryCorr(null, corr.edge2, t1e1, t2e1, null, corr.edge1, t1e2, t2e2 = Util3D.tOnLineSeg(edge.p1, edge.p2, points[1]), corr.door1Width, corr.door2Width, Double.MAX_VALUE, false);
            if (geom == null || geom.boundary.length == 2) {
                return null;
            }
            geom = geom.setDirection(this.dirVec);
            return geom;
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new RoomHandle(this, true));
            handles.accept(new RoomHandle(this, false));
            handles.accept(new EdgeLocHandle(this, true, true));
            handles.accept(new EdgeLocHandle(this, true, false));
            handles.accept(new EdgeLocHandle(this, false, true));
            handles.accept(new EdgeLocHandle(this, false, false));
        }

        protected class RoomHandle
        implements IHandle {
            private CorridorGeom d_geom;
            private final boolean d_edge1Fixed;

            public RoomHandle(CorridorGeom geom, boolean edge1Fixed) {
                this.d_geom = geom;
                this.d_edge1Fixed = edge1Fixed;
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof RoomHandle && ((RoomHandle)obj).d_edge1Fixed == this.d_edge1Fixed;
            }

            @Override
            public IGeomNode getGeom() {
                return GeomNodeUtil.newNode(new Point(this.getLocation()));
            }

            protected Point3d getLocation() {
                Point3d[] boundary = this.d_geom.getBoundary();
                if (this.d_edge1Fixed) {
                    return Util3D.getMidPoint(boundary[2], boundary[3]);
                }
                return Util3D.getMidPoint(boundary[0], boundary[1]);
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return null;
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter(ISchematicRoom.class, GeomType.FACE_EDGE));
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            }

            @Override
            public Object modify(Point3d snappedPos) throws ManipException {
                Point3d[] boundary = this.d_geom.getBoundary();
                LineSeg fixedEdge = this.d_edge1Fixed ? this.d_geom.edge1 : this.d_geom.edge2;
                int p1ix = this.d_edge1Fixed ? 0 : 2;
                Point3d fixedEdgeP1 = boundary[p1ix];
                Point3d fixedEdgeP2 = boundary[(p1ix + 1) % 4];
                double fixedEdgeT1 = Inter3D.nearestTOnLineSeg(fixedEdge.p1, fixedEdge.p2, fixedEdgeP1);
                double fixedEdgeT2 = Inter3D.nearestTOnLineSeg(fixedEdge.p1, fixedEdge.p2, fixedEdgeP2);
                CorridorGeom corridor = null;
                double maxAngle = CorridorUtil.DEF_MAX_EDGE_ANGLE.getValue(SI.RADIAN);
                Collection<CorridorUtil.EdgeLoc> edgeLocs2 = CorridorUtil.getPotentialEdgeLocs(VentusApp.getApp().getData(), snappedPos, 1.0E-6, CorridorUtil.DEF_MAX_EDGE_ANGLE.getValue(SI.RADIAN), 0);
                if (!edgeLocs2.isEmpty()) {
                    for (CorridorUtil.EdgeLoc edgeLoc2 : edgeLocs2) {
                        CorridorGeom cgeom = CorridorUtil.findBoundaryCorr(null, fixedEdge, fixedEdgeT1, fixedEdgeT2, edgeLoc2.room, edgeLoc2.edge, this.d_geom.door1Width, this.d_geom.door2Width, SchematicCorridor.getMaxWidth(this.d_geom.boundary), maxAngle, false);
                        if (cgeom == null || cgeom.boundary.length != 4) continue;
                        corridor = cgeom;
                        break;
                    }
                }
                if (corridor == null) {
                    throw new ManipException();
                }
                if (!this.d_edge1Fixed && (corridor = corridor.reverse()) == null) {
                    throw new ManipException();
                }
                this.d_geom = corridor = corridor.setDirection(CorridorGeom.this.dirVec);
                return this.d_geom;
            }

            @Override
            public Object end() {
                return this.d_geom;
            }
        }

        protected class EdgeLocHandle
        implements IHandle {
            private CorridorGeom d_geom;
            private final boolean d_edge1;
            private final boolean d_point1;

            public EdgeLocHandle(CorridorGeom geom, boolean edge1, boolean point1) {
                this.d_geom = geom;
                this.d_edge1 = edge1;
                this.d_point1 = point1;
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof EdgeLocHandle && ((EdgeLocHandle)obj).d_edge1 == this.d_edge1 && ((EdgeLocHandle)obj).d_point1 == this.d_point1;
            }

            @Override
            public IGeomNode getGeom() {
                return GeomNodeUtil.newNode(new Point(this.getLocation()));
            }

            protected Point3d getLocation() {
                Point3d[] points = this.d_geom.getBoundary();
                if (this.d_edge1) {
                    return this.d_point1 ? points[0] : points[1];
                }
                return this.d_point1 ? points[2] : points[3];
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                if (this.d_edge1) {
                    return new LineConstraint(this.d_geom.edge1.p1, this.d_geom.edge1.getTangent(0.0, ICurve.Orient.POSITIVE, true));
                }
                return new LineConstraint(this.d_geom.edge2.p1, this.d_geom.edge2.getTangent(0.0, ICurve.Orient.POSITIVE, true));
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter(ISchematicRoom.class, GeomType.FACE_EDGE));
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            }

            @Override
            public Object modify(Point3d newLoc) throws ManipException {
                LineSeg edge1 = this.d_geom.edge1;
                LineSeg edge2 = this.d_geom.edge2;
                double width1 = this.d_geom.boundary[0].distance(this.d_geom.boundary[1]);
                double width2 = this.d_geom.boundary[2].distance(this.d_geom.boundary[3]);
                if (!this.d_edge1) {
                    LineSeg temp = edge1;
                    edge1 = edge2;
                    edge2 = temp;
                    double twidth = width1;
                    width1 = width2;
                    width2 = twidth;
                }
                newLoc = Inter3D.nearestPointOnLine(edge1.p1, edge1.getTangent(0.0, ICurve.Orient.POSITIVE, false), newLoc);
                Vector3d e1dir = edge1.getTangent(0.0, ICurve.Orient.POSITIVE, false);
                double t1 = Util3D.tOnLine(edge1.p1, e1dir, newLoc);
                double widthMult = this.d_point1 ? -1.0 : 1.0;
                double t2 = t1 + width1 / edge1.length() * widthMult;
                double[] e1Ts = Geometry.getEdgeSegment(edge1, t1, t2, 0.0, 1.0, 0.0, true);
                if (e1Ts == null) {
                    throw new ManipException();
                }
                double t1e1 = e1Ts[0];
                double t2e1 = e1Ts[1];
                CorridorGeom corr = CorridorUtil.findBoundaryCorr(null, edge1, t1e1, t2e1, null, edge2, this.d_geom.door1Width, this.d_geom.door2Width, width1, width2, Double.MAX_VALUE, true);
                if (corr == null || corr.boundary.length != 4) {
                    throw new ManipException();
                }
                if (!this.d_edge1 && (corr = corr.reverse()) == null) {
                    throw new ManipException();
                }
                this.d_geom = corr = corr.setDirection(CorridorGeom.this.dirVec);
                return this.d_geom;
            }

            @Override
            public Object end() {
                return this.d_geom;
            }
        }
    }

    public static class DispCorridorGeom
    extends CorridorGeom {
        private static final long serialVersionUID = -6892581924242060592L;
        public final boolean dirArrow;

        public DispCorridorGeom(CorridorGeom sg, boolean dirArrow) {
            super(sg.edge1, sg.edge2, sg.door1Width, sg.door2Width, sg.dirVec, sg.boundary);
            this.dirArrow = dirArrow;
        }

        @Override
        protected boolean includeDirArrow() {
            return this.dirArrow;
        }
    }
}

