/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.schematics.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Sets;
import thunderheadeng.util.theUtil;
import ventus.data.AMerlinObj;
import ventus.data.IOpacity;
import ventus.data.NamedMerlinObj;
import ventus.data.Opacity;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.feature.tags.Tag;
import ventus.feature.tags.TagsUtil;

public abstract class ASchematicComp
extends NamedMerlinObj
implements ISchematicComp,
Serializable,
Cloneable,
ISurrogate,
IDirectDependent<VentusData> {
    static final long serialVersionUID = 1L;
    public static final Set<Object> PROP_TYPES = Sets.fromArrayLHS(VentusData.VISIBILITY, NamedMerlinObj.NAME, VentusData.TAGS, VentusData.COLOR, VentusData.OPACITY, VentusData.ENABLED);
    private boolean d_visible = true;
    private boolean d_enabled = true;
    private Color d_color = null;
    private float d_transparency = 0.0f;
    private Set<Tag> d_tags = Collections.emptySet();

    public ASchematicComp(String name) {
        super(name);
    }

    @Override
    public void restoreFrom(Object obj) {
        ASchematicComp c = (ASchematicComp)obj;
        this.pauseUpdates();
        this.setName(c.getSetName());
        this.setVisible(c.isVisible());
        this.setEnabled(c.isEnabled());
        this.setColor(c.getColor());
        this.setOpacity(c.getOpacity());
        this.setTags(c.getTags());
        this.resumeUpdates();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_enabled = true;
        in.defaultReadObject();
        if (this.d_tags == null) {
            this.d_tags = Collections.emptySet();
        }
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    private int surrogateHashCode() {
        int hash = super.surrogateHashCodeHelper();
        hash = 31 * hash + theUtil.hashCode(this.d_color);
        return hash;
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        return this.surrogateEqualsHelper(comparable);
    }

    @Override
    protected boolean surrogateEqualsHelper(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ASchematicComp)) {
            return false;
        }
        ASchematicComp comp = (ASchematicComp)obj;
        return super.surrogateEqualsHelper(comp) && theUtil.surrogateSetsEqual(this.d_tags, comp.d_tags) && Objects.equals(this.d_color, comp.d_color);
    }

    @Override
    public Collection<Pair<ISchematicComp, ISchematicComp.ConflictType>> getConflicts() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Color getColor() {
        return this.d_color;
    }

    @Override
    public void setColor(Color color) {
        if (!Objects.equals(this.d_color, color)) {
            this.d_color = color;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public void setOpacity(float opacity) {
        float trans = 1.0f - opacity;
        if (theUtil.eq(trans, this.d_transparency, 0.0)) {
            return;
        }
        this.d_transparency = trans;
        this.changedEvt(new Object[0]);
    }

    @Override
    public float getOpacity() {
        return 1.0f - this.d_transparency;
    }

    @Override
    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(VentusData.VISIBILITY, VentusData.ENABLED, VentusData.TAGS, EventChannel.EVT_GENERAL, VentusData.TOPOLOGY);
        }
    }

    public Set<Tag> getTags() {
        return Collections.unmodifiableSet(this.d_tags);
    }

    public void setTags(Set<Tag> tags) {
        this.d_tags = tags;
        this.changedEvt(new Object[0]);
    }

    public Collection<AMerlinObj> getConnObjectsForEnable(VentusData md) {
        return Collections.emptyList();
    }

    @Override
    public void setVisible(boolean visible) {
        this.d_visible = visible;
        this.changedEvt(VentusData.VISIBILITY);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible && this.d_enabled;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == VentusData.VISIBILITY) {
            this.setVisible((Boolean)value);
        }
        if (property == VentusData.ENABLED) {
            this.setEnabled((Boolean)value);
        } else if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property == VentusData.COLOR) {
            this.setColor((Color)value);
        } else if (property == VentusData.OPACITY) {
            this.setOpacity(((IOpacity)value).getValue());
        } else if (property == VentusData.TAGS) {
            this.setTags((Set)value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == VentusData.VISIBILITY) {
            return this.isVisible();
        }
        if (property == VentusData.ENABLED) {
            return this.isEnabled();
        }
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property == VentusData.COLOR) {
            return this.getColor();
        }
        if (property == VentusData.OPACITY) {
            return new Opacity(this.getOpacity());
        }
        if (property == VentusData.TAGS) {
            return this.getTags();
        }
        return NOT_SUPPORTED;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.getTags());
    }

    @Override
    public void replaceDependency(VentusData md, Object old, Object replacement) {
        TagsUtil.replaceDependency(this, old, replacement);
    }
}

