/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.schematics.elevators;

public interface ITimingModel {
    public static final ITimingModel DEF_MODEL = new AccelModel(1.2, 2.5, 3.5, 3.5);

    public double getTime(double var1);

    public double[] getOpenCloseTimes();

    public static class AccelModel
    extends AModel {
        public final double accel;
        public final double maxVel;

        public AccelModel(double accel, double maxVel, double openTime, double closeTime) {
            super(openTime, closeTime);
            this.accel = accel;
            this.maxVel = maxVel;
        }

        @Override
        public double getTime(double dist) {
            double time;
            double tAccelToMaxVel = this.maxVel / this.accel;
            double distAccelToMaxVel = 0.5 * this.accel * tAccelToMaxVel * tAccelToMaxVel;
            if ((dist *= 0.5) > distAccelToMaxVel) {
                double distLinear = dist - distAccelToMaxVel;
                double tLinear = distLinear / this.maxVel;
                time = tLinear + tAccelToMaxVel;
            } else {
                time = Math.sqrt(dist / this.accel);
            }
            return 2.0 * time;
        }
    }

    public static class VelModel
    extends AModel {
        public final double vel;

        public VelModel(double vel, double openDoorTime, double closeDoorTime) {
            super(openDoorTime, closeDoorTime);
            this.vel = vel;
        }

        @Override
        public double getTime(double dist) {
            return dist / this.vel;
        }
    }

    public static abstract class AModel
    implements ITimingModel {
        public final double openDoorTime;
        public final double closeDoorTime;

        public AModel(double openTime, double closeTime) {
            this.openDoorTime = openTime;
            this.closeDoorTime = closeTime;
        }

        @Override
        public double[] getOpenCloseTimes() {
            return new double[]{this.openDoorTime, this.closeDoorTime};
        }
    }
}

