/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.schematics.elevators;

import java.util.ArrayList;
import java.util.Arrays;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.elevators.ElevatorDoor;
import ventus.data.schematics.elevators.ElevatorRoom;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.SchematicRoom;

public class ElevatorUtil {
    public static Floor getFloor(VentusData md, Object obj) {
        if (obj instanceof ElevatorRoom) {
            return ElevatorUtil.getFloor(md, (ElevatorRoom)obj);
        }
        while (obj != null && !(obj instanceof Floor)) {
            obj = md.hierarchy.getParent(obj);
        }
        return (Floor)obj;
    }

    public static Floor getFloor(VentusData md, ElevatorRoom elevatorRoom) {
        return ElevatorUtil.getFloor(md, elevatorRoom, false);
    }

    public static Floor getFloor(VentusData md, ElevatorRoom room, boolean includeDisconnected) {
        for (ElevatorDoor door : room.getElevatorDoors()) {
            Floor floor = ElevatorUtil.getFloor(md, room, door, includeDisconnected);
            if (floor == null) continue;
            return floor;
        }
        return null;
    }

    public static Floor getFloor(VentusData md, ElevatorRoom elevatorRoom, ElevatorDoor door) {
        return ElevatorUtil.getFloor(md, elevatorRoom, door, false);
    }

    public static Floor getFloor(VentusData md, ElevatorRoom elevatorRoom, ElevatorDoor door, boolean includeDisconnected) {
        SchematicRoom disconnectedRoom;
        ArrayList<ISchematicRoom> connectedToDoor = new ArrayList<ISchematicRoom>(Arrays.asList(door.getConnectedComps()));
        if (includeDisconnected && (disconnectedRoom = door.getDisconnectedRoom()) != null) {
            connectedToDoor.add(disconnectedRoom);
        }
        for (ISchematicRoom connRoom : connectedToDoor) {
            if (connRoom == elevatorRoom) continue;
            Object parent = md.hierarchy.getParent(connRoom);
            while (parent != null && !(parent instanceof Floor)) {
                parent = md.hierarchy.getParent(parent);
            }
            if (parent == null) continue;
            return (Floor)parent;
        }
        return null;
    }
}

