/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.schematics.elevators;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.util.Global;
import thunderheadeng.util.Sets;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.data.schematics.Floor;
import ventus.data.schematics.ISchematicObj;
import ventus.data.schematics.elevators.Elevator;
import ventus.data.schematics.elevators.ElevatorDoor;
import ventus.data.schematics.elevators.ElevatorUtil;
import ventus.data.schematics.elevators.IElevatorComp;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.util.MerlinUtil;

public class ElevatorRoom
extends SchematicRoom
implements IElevatorComp {
    static final long serialVersionUID = 723492347132409L;
    public static final Set<Object> PROP_TYPES = ElevatorRoom.initPropTypes();
    @SkipDep
    private List<ElevatorDoor> d_doors;

    public ElevatorRoom(SchematicRoom room, Collection<ElevatorDoor> connectedDoors) {
        this(room.getName(), room.getModel(), connectedDoors);
    }

    public ElevatorRoom(String name, Model geometry, Collection<ElevatorDoor> connectedDoors) {
        super(name, geometry);
        this.d_doors = new ArrayList<ElevatorDoor>(connectedDoors);
        for (ElevatorDoor door : connectedDoors) {
            super.connectTo(door);
        }
    }

    private static Set<Object> initPropTypes() {
        Set<Object> props = Sets.appendLHS(SchematicRoom.PROP_TYPES, new Object[0]);
        props.remove(VentusData.ENABLED);
        return props;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        super.readTopology(ois);
        if (this.d_doors.isEmpty()) {
            this.d_doors = new ArrayList<ElevatorDoor>(MerlinUtil.filter(this.getDoors(), ElevatorDoor.class));
        }
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null) {
            Floor floor;
            VentusData md = (VentusData)this.getDomain();
            if (md != null && (floor = ElevatorUtil.getFloor((VentusData)this.getDomain(), this)) != null) {
                BaseUnit lu = md != null ? md.getUnitSystem().getLength() : SI.METER;
                return String.format(Intl.intl("Level %s"), Global.format(floor.getWorkingZ().convert(lu)));
            }
            return Intl.intl("<Disconnected Level>");
        }
        return name;
    }

    @Override
    public ElevatorRoom clone() {
        return this.clone(true, true, (Map)null);
    }

    @Override
    public ElevatorRoom clone(boolean deep, boolean cloneGeom, Map<IMerlinObj, IMerlinObj> cloneMap) {
        ElevatorRoom clone = (ElevatorRoom)super.clone(deep, cloneGeom, cloneMap);
        if (deep) {
            clone.d_doors = new ArrayList<ElevatorDoor>(this.d_doors.size());
            for (ElevatorDoor door : this.d_doors) {
                ElevatorDoor newDoor = (ElevatorDoor)door.clone();
                if (cloneMap != null) {
                    cloneMap.put(door, newDoor);
                }
                clone.d_doors.add(newDoor);
                clone.connectTo(newDoor);
            }
        } else {
            clone.d_doors = new ArrayList<ElevatorDoor>(this.d_doors);
        }
        return clone;
    }

    @Override
    public Object getRestoreObj() {
        return this.clone(false, true, (Map)null);
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof ElevatorRoom)) {
            return;
        }
        ElevatorRoom er = (ElevatorRoom)obj;
        this.pauseUpdates();
        for (ElevatorDoor oldDoor : this.getElevatorDoors()) {
            this.disconnectFrom(oldDoor);
            this.removeChild(oldDoor);
        }
        super.restoreFrom(obj);
        for (ElevatorDoor door : er.getElevatorDoors()) {
            this.connectTo(door);
            this.addChild(door);
        }
        this.d_doors = new ArrayList<ElevatorDoor>(er.getElevatorDoors());
        this.resumeUpdates();
    }

    public Collection<ElevatorDoor> getElevatorDoors() {
        return Collections.unmodifiableCollection(this.d_doors);
    }

    @Override
    public boolean getModificationsAllowed() {
        return false;
    }

    @Override
    public Collection<? extends IMerlinObj> getChildren() {
        return this.getElevatorDoors();
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        if (MerlinUtil.test(options, 1)) {
            return PROP_TYPES;
        }
        Set<Object> propTypes = Composite.getPropTypes(options, this.d_doors);
        propTypes = new LinkedHashSet<Object>(propTypes);
        propTypes.addAll(this.getPropTypes(1));
        return propTypes;
    }

    @Override
    public Object getProperty(Object property) {
        Set<Object> localTypes = this.getPropTypes(1);
        if (localTypes.contains(property)) {
            return super.getProperty(property);
        }
        return Composite.getProperty(property, this.d_doors);
    }

    @Override
    public void setProperty(Object property, Object value) {
        Set<Object> localTypes = this.getPropTypes(1);
        if (localTypes.contains(property)) {
            super.setProperty(property, value);
        } else {
            Composite.setProperty(property, value, this.d_doors);
        }
    }

    @Override
    public Collection<? extends ISchematicObj> getConnections() {
        ArrayList<? extends ISchematicObj> erTop = new ArrayList<ISchematicObj>();
        erTop.addAll(super.getConnections());
        Elevator parentElevator = (Elevator)this.getParent();
        if (parentElevator != null) {
            erTop.add(parentElevator.getDischargeRoom());
        }
        return erTop;
    }
}

