/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.schematics.elevators;

import java.util.Set;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Sets;
import ventus.data.VentusData;
import ventus.data.schematics.ISchematicObj;
import ventus.data.schematics.elevators.ElevatorRoom;
import ventus.data.schematics.elevators.IElevatorComp;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.SchematicDoor;
import ventus.data.schematics.geom.SchematicRoom;

public class ElevatorDoor
extends SchematicDoor
implements IElevatorComp {
    static final long serialVersionUID = 234111234908734L;
    public static final Set<Object> PROP_TYPES = Sets.appendLHS(SchematicDoor.PROP_TYPES, VentusData.ENABLED);
    private boolean d_enabled = true;
    private SchematicRoom d_disconnectedRoom;

    public ElevatorDoor(SchematicDoor door) {
        this(door.getName(), false, door.getRoom1(), door.getRoom2(), door.getEdge1(), door.getEdge2(), door.getBoundary());
    }

    public ElevatorDoor(String name, boolean forceAsExit, ISchematicRoom comp1, ISchematicRoom comp2, LineSeg3D attachedEdge1, LineSeg3D attachedEdge2, Point3d[] boundary) {
        super(name, forceAsExit, comp1, comp2, attachedEdge1, attachedEdge2, boundary);
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof ElevatorDoor)) {
            return;
        }
        ElevatorDoor door = (ElevatorDoor)obj;
        this.pauseUpdates();
        super.restoreFrom(obj);
        this.d_enabled = door.isEnabled();
        this.d_disconnectedRoom = door.getDisconnectedRoom();
        this.resumeUpdates();
    }

    @Override
    public boolean hasOpenSpots(Class<? extends ISchematicObj> type) {
        if (!ElevatorRoom.class.isAssignableFrom(type) && !this.isEnabled()) {
            return false;
        }
        return super.hasOpenSpots(type);
    }

    @Override
    public void connectTo(ISchematicObj obj) {
        if (!(obj instanceof ElevatorRoom) && !this.isEnabled()) {
            return;
        }
        super.connectTo(obj);
    }

    @Override
    public void disconnectFrom(ISchematicObj obj) {
        if (!(this.getRoom1() instanceof ElevatorRoom) || !(this.getRoom2() instanceof ElevatorRoom)) {
            if (obj instanceof ElevatorRoom) {
                return;
            }
            if (obj instanceof SchematicRoom) {
                this.d_disconnectedRoom = (SchematicRoom)obj;
            }
        }
        super.disconnectFrom(obj);
    }

    @Override
    public void setWidth(double width) {
    }

    @Override
    public boolean isVisible() {
        return this.d_enabled && super.isVisible();
    }

    @Override
    public boolean isEnabled() {
        return this.d_enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(VentusData.VISIBILITY, VentusData.ENABLED, EventChannel.EVT_GENERAL, VentusData.TOPOLOGY);
        }
    }

    @Override
    public boolean getModificationsAllowed() {
        return false;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public Object getProperty(Object prop) {
        if (prop == VentusData.ENABLED) {
            return this.isEnabled();
        }
        return super.getProperty(prop);
    }

    public void setProperty(Object property, Object value) {
        if (property == VentusData.ENABLED) {
            this.setEnabled((Boolean)value);
        } else {
            super.setProperty(property, value);
        }
    }

    public SchematicRoom getDisconnectedRoom() {
        return this.d_disconnectedRoom;
    }
}

