/*
 * Decompiled with CFR 0.152.
 */
package ventus.data.schematics;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Set;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.Sets;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.GeomComposite;
import ventus.data.ICompElement;
import ventus.data.IRestorable;
import ventus.data.VentusData;
import ventus.data.schematics.FloorComposite;
import ventus.data.schematics.ISchematicObj;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.io.VentusOIS;
import ventus.util.MerlinUtil;

public class Floor
extends GeomComposite<ICompElement>
implements ICompElement,
IRestorable {
    static final long serialVersionUID = 1L;
    public static final Object WORKING_GROUP_CHANGED = "Floor.WORKING_GROUP_CHANGED";
    public static final UnitDouble CURR_FLOOR = new UnitDouble(Double.NaN, SI.METER);
    public static final UnitDouble NEXT_FLOOR = new UnitDouble(Double.NaN, SI.METER);
    public static final Object WORKING_Z = "Floor.WORKING_Z";
    public static final Object HEIGHT = "Floor.HEIGHT";
    public static final Object ZMIN_FILTER = "Floor.ZMIN_FILTER";
    public static final Object ZMAX_FILTER = "Floor.ZMAX_FILTER";
    public static final Set<Object> PROP_TYPES = Sets.appendLHS(GeomComposite.PROP_TYPES, VentusData.VISIBILITY, WORKING_Z, HEIGHT, ZMIN_FILTER, ZMAX_FILTER);
    private UnitDouble d_defWorkingZ;
    private UnitDouble d_height;
    private UnitDouble d_zminFilter;
    private UnitDouble d_zmaxFilter;
    private GeomComposite<ICompElement> d_workingNavGroup;

    public Floor(UnitDouble defWorkingZ) {
        this(null, defWorkingZ);
    }

    public Floor(String name, UnitDouble defWorkingZ) {
        super(name);
        this.d_defWorkingZ = defWorkingZ;
        this.d_height = new UnitDouble(3.0, SI.METER);
        this.d_workingNavGroup = this;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (in instanceof VentusOIS) {
            for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
                obj.readTopology(in);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (ISchematicObj obj : this.getDeepMembers(ISchematicObj.class)) {
            obj.writeTopology(out);
        }
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null) {
            VentusData md = (VentusData)this.getDomain();
            BaseUnit lu = md != null ? md.getUnitSystem().getLength() : SI.METER;
            name = String.format(Intl.intl("Level %s"), Global.format(this.d_defWorkingZ.convert(lu)));
        }
        return name;
    }

    public String getBaseName() {
        return super.getName();
    }

    public void setWorkingGeomGroup(GeomComposite<ICompElement> group) {
        if (this.d_workingNavGroup == group) {
            return;
        }
        this.pauseUpdates();
        if (this.d_workingNavGroup != null) {
            this.d_workingNavGroup.changedEvt(WORKING_GROUP_CHANGED);
        }
        this.d_workingNavGroup = group;
        this.changedEvt(WORKING_GROUP_CHANGED);
        if (this.d_workingNavGroup != null) {
            this.d_workingNavGroup.changedEvt(WORKING_GROUP_CHANGED);
        }
        this.resumeUpdates();
    }

    public GeomComposite<ICompElement> getWorkingGeomGroup() {
        return this.d_workingNavGroup;
    }

    public UnitDouble getWorkingZ() {
        return this.d_defWorkingZ;
    }

    public void setWorkingZ(UnitDouble workingZ) {
        this.d_defWorkingZ = workingZ;
        this.invalidateClippingRegion();
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getHeight() {
        return this.d_height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeight(UnitDouble height) {
        if (Objects.equals(this.d_height, height)) {
            return;
        }
        this.pauseUpdates();
        try {
            this.d_height = height;
            this.invalidateClippingRegion();
            this.changedEvt(new Object[0]);
            for (ISchematicRoom r : this.flatten(ISchematicRoom.class)) {
                r.floorHeightChanged();
            }
        }
        finally {
            this.resumeUpdates();
        }
    }

    public UnitDouble[] getZFilter() {
        UnitDouble min = this.d_zminFilter == null ? CURR_FLOOR : this.d_zminFilter;
        UnitDouble max = this.d_zmaxFilter == null ? NEXT_FLOOR : this.d_zmaxFilter;
        return new UnitDouble[]{min, max};
    }

    public void setZFilter(UnitDouble zMin, UnitDouble zMax) {
        this.d_zminFilter = zMin == CURR_FLOOR ? null : zMin;
        this.d_zmaxFilter = zMax == NEXT_FLOOR ? null : zMax;
        this.invalidateClippingRegion();
        this.changedEvt(new Object[0]);
    }

    private void invalidateClippingRegion() {
        if (this.getDomain() != null) {
            ((VentusData)this.getDomain()).floors.invalidateClippingRegions();
        }
    }

    @Override
    public void restoreFrom(Object nn) {
        this.pauseUpdates();
        super.restoreFrom(nn);
        Floor floor = (Floor)nn;
        this.setWorkingGeomGroup(floor.getWorkingGeomGroup());
        this.setWorkingZ(floor.d_defWorkingZ);
        this.setHeight(floor.d_height);
        UnitDouble[] filter = floor.getZFilter();
        this.setZFilter(filter[0], filter[1]);
        this.resumeUpdates();
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        if (MerlinUtil.test(options, 1)) {
            return PROP_TYPES;
        }
        return super.getPropTypes(options);
    }

    @Override
    public Object getProperty(Object property) {
        if (property == WORKING_Z) {
            return this.getWorkingZ();
        }
        if (property == HEIGHT) {
            return this.getHeight();
        }
        if (property == ZMIN_FILTER) {
            return this.getZFilter()[0];
        }
        if (property == ZMAX_FILTER) {
            return this.getZFilter()[1];
        }
        return super.getProperty(property);
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == WORKING_Z) {
            this.setWorkingZ((UnitDouble)value);
        } else if (property == HEIGHT) {
            this.setHeight((UnitDouble)value);
        } else if (property == ZMIN_FILTER) {
            this.setZFilter((UnitDouble)value, this.getZFilter()[1]);
        } else if (property == ZMAX_FILTER) {
            this.setZFilter(this.getZFilter()[0], (UnitDouble)value);
        } else {
            super.setProperty(property, value);
        }
    }

    public void repairBrokenFloors(FloorComposite topFloorNode) {
        ArrayDeque<Floor> brokenFloors = new ArrayDeque<Floor>(this.getDeepMembers(Floor.class));
        for (Floor f : brokenFloors) {
            System.out.println("Moving level to Levels node: " + f.toString());
            Composite<Floor> parent = Composite.findParent(this, f);
            if (parent != null) {
                parent.remove(f);
                topFloorNode.add(f);
                continue;
            }
            throw new RuntimeException("Unable to repair level grouping error.");
        }
    }

    @Override
    public String toString() {
        return String.format("Level[name=\"%s\", z=%s]", this.getName(), this.d_defWorkingZ.toString());
    }
}

