/*
 * Decompiled with CFR 0.152.
 */
package ventus.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import thunderheadeng.util.theUtil;
import ventus.data.INameGenerator;

public class SequentialNameGen
implements INameGenerator {
    static final long serialVersionUID = 1L;
    private String d_baseName;
    private final int d_minNumWidth;
    private String d_formatStr;
    private int d_index = 0;

    public SequentialNameGen(String baseName, int minNumWidth) {
        this.d_minNumWidth = minNumWidth;
        this.setBaseName(baseName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_baseName == null) {
            int bnumix = this.d_formatStr.lastIndexOf("%0");
            assert (bnumix != -1);
            int numWidth = Integer.parseInt(this.d_formatStr.substring(bnumix + 2, this.d_formatStr.length() - 1));
            String baseName = this.d_formatStr.substring(0, bnumix);
            try {
                theUtil.assignFinalField(this, SequentialNameGen.class, "d_baseName", baseName);
                theUtil.assignFinalField(this, SequentialNameGen.class, "d_minNumWidth", numWidth);
            }
            catch (Throwable t) {
                assert (false);
                t.printStackTrace();
            }
        }
    }

    public String getBaseName() {
        return this.d_baseName;
    }

    public void setBaseName(String baseName) {
        if (baseName.equals(this.d_baseName)) {
            return;
        }
        this.d_baseName = baseName;
        this.d_formatStr = baseName + "%0" + this.d_minNumWidth + "d";
    }

    public int getMinNumWidth() {
        return this.d_minNumWidth;
    }

    @Override
    public String nextName() {
        ++this.d_index;
        return this.getCurrentName();
    }

    @Override
    public String getCurrentName() {
        return String.format(this.d_formatStr, this.d_index);
    }

    @Override
    public void reset() {
        this.d_index = 0;
    }
}

