/*
 * Decompiled with CFR 0.152.
 */
package ventus.data;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.LinkedIdentityHashSet;
import ventus.data.AMerlinObj;
import ventus.data.ICompElement;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;

public class Proxy<T extends ICompElement>
extends AMerlinObj
implements ICompElement,
IDirectDependent<VentusData> {
    static final long serialVersionUID = -3893471045648835311L;
    private final T d_obj;
    private boolean d_enabled = true;

    public Proxy(T obj) {
        this.d_obj = obj;
    }

    @Override
    public String getName() {
        return this.d_obj.getName();
    }

    @Override
    public void setName(String name) {
        this.d_obj.setName(name);
    }

    @Override
    public Collection<? extends IMerlinObj> getChildren() {
        return this.d_obj.getChildren();
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return this.d_obj.getPropTypes(options);
    }

    public <U> void setProperty(Object property, U value) {
        if (property == VentusData.ENABLED) {
            this.setEnabled((Boolean)value);
        } else {
            this.d_obj.setProperty(property, value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == VentusData.ENABLED) {
            return this.isEnabled();
        }
        return this.d_obj.getProperty(property);
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(VentusData.VISIBILITY, VentusData.ENABLED, EventChannel.EVT_GENERAL);
            this.d_obj.changedEvt(VentusData.VISIBILITY, VentusData.ENABLED, EventChannel.EVT_GENERAL);
        }
    }

    public T getObj() {
        return this.d_obj;
    }

    @Override
    public void setDomain(VentusData domain, IMerlinObj parent) {
        this.updateDomainProxy(domain);
        super.setDomain(domain, parent);
    }

    @Override
    public void setDomain(VentusData owner) {
        this.updateDomainProxy(owner);
        super.setDomain(owner);
    }

    private void updateDomainProxy(VentusData domain) {
        VentusData curDomain;
        if (domain != null) {
            domain.proxies.add(this);
        }
        if ((curDomain = (VentusData)this.getDomain()) != null) {
            curDomain.proxies.remove(this);
        }
    }

    public static Collection<Object> getProxyParents(ICompElement obj, boolean includeDisabledProxies) {
        Set<Proxy> allProxies;
        VentusData md = (VentusData)obj.getDomain();
        if (md == null) {
            return null;
        }
        Set<Proxy> set = allProxies = md.proxies != null ? md.proxies.getProxies(obj) : Collections.emptySet();
        if (allProxies.isEmpty()) {
            return null;
        }
        LinkedIdentityHashSet<Object> allParents = new LinkedIdentityHashSet<Object>();
        for (Proxy p : allProxies) {
            Object parent;
            if (!includeDisabledProxies && !p.isEnabled() || (parent = ((VentusData)obj.getDomain()).hierarchy.getParent(p)) == null) continue;
            allParents.add(parent);
        }
        return allParents;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.STRONG, this.d_obj);
    }

    @Override
    public void replaceDependency(VentusData md, Object old, Object replacement) {
        assert (false);
    }

    @Override
    public boolean isSetNameSupported() {
        return this.d_obj.isSetNameSupported();
    }
}

