/*
 * Decompiled with CFR 0.152.
 */
package ventus.data;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import ventus.data.ICompElement;
import ventus.data.IRestorable;
import ventus.data.Proxy;

public class Proxies
implements IRestorable {
    private static final long serialVersionUID = 8953619384941835754L;
    private Map<ICompElement, Set<Proxy<? extends ICompElement>>> proxiesMap;

    public Proxies() {
        this.proxiesMap = new LinkedIdentityHashMap<ICompElement, Set<Proxy<? extends ICompElement>>>();
    }

    public Proxies(Map<ICompElement, Set<Proxy<? extends ICompElement>>> proxiesMap) {
        this.proxiesMap = proxiesMap;
    }

    public void add(Proxy<?> proxy) {
        Object obj = proxy.getObj();
        assert (obj != null);
        this.proxiesMap.computeIfAbsent((ICompElement)obj, (Function<ICompElement, Set<Proxy<? extends ICompElement>>>)((Function<ICompElement, Set>)o -> new LinkedIdentityHashSet()));
        this.proxiesMap.get(obj).add(proxy);
    }

    public void remove(Proxy<?> proxy) {
        Set<Proxy<? extends ICompElement>> set = this.proxiesMap.get(proxy.getObj());
        if (set == null) {
            return;
        }
        set.remove(proxy);
        if (set.isEmpty()) {
            this.proxiesMap.remove(proxy.getObj());
        }
    }

    public Set<Proxy<? extends ICompElement>> getProxies(ICompElement obj) {
        return this.proxiesMap.getOrDefault(obj, Collections.emptySet());
    }

    public <T extends ICompElement> Proxy<? extends T> findFirstProxy(T obj, Predicate<Proxy<? extends T>> filter) {
        return this.getProxies(obj).stream().map(p -> p).filter(filter).findFirst().orElse(null);
    }

    public Set<Proxy<? extends ICompElement>> getAllProxies() {
        LinkedIdentityHashSet<Proxy<? extends ICompElement>> allProxies = new LinkedIdentityHashSet<Proxy<? extends ICompElement>>();
        for (Set<Proxy<? extends ICompElement>> proxies : this.proxiesMap.values()) {
            allProxies.addAll(proxies);
        }
        return allProxies;
    }

    @Override
    public void restoreFrom(Object obj) {
        this.proxiesMap = ((Proxies)obj).proxiesMap;
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    public Object clone() {
        LinkedIdentityHashMap<ICompElement, Set<Proxy<? extends ICompElement>>> newMap = new LinkedIdentityHashMap<ICompElement, Set<Proxy<? extends ICompElement>>>();
        for (ICompElement obj : this.proxiesMap.keySet()) {
            newMap.put(obj, new LinkedIdentityHashSet((Collection)this.proxiesMap.get(obj)));
        }
        Proxies clone = new Proxies(newMap);
        return clone;
    }
}

