/*
 * Decompiled with CFR 0.152.
 */
package ventus.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.function.Predicate;
import thunderheadeng.util.Filters;
import ventus.Intl;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.VentusData;

public class GeomComposite<ObjT extends ICompElement>
extends Composite<ObjT> {
    private static final long serialVersionUID = 6410485383956905837L;
    private boolean d_visible = true;

    public GeomComposite(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public Composite<?> newGroup(String name) {
        return new GeomComposite<ObjT>(name);
    }

    @Override
    public Predicate<ICompElement> getFilter() {
        return Filters.acceptAll();
    }

    @Override
    public void restoreFrom(Object obj) {
        super.restoreFrom(obj);
        this.d_visible = ((GeomComposite)obj).d_visible;
    }

    protected boolean isVisibilityLocal() {
        return this.getPropTypes(1).contains(VentusData.VISIBILITY);
    }

    public boolean isVisible() {
        if (!this.isVisibilityLocal()) {
            Object vis = super.getProperty(VentusData.VISIBILITY);
            return vis == Composite.NON_UNIFORM || vis == Composite.NOT_SUPPORTED || (Boolean)vis != false;
        }
        return this.d_visible;
    }

    public void setVisible(boolean visible) {
        if (!this.isVisibilityLocal()) {
            super.setProperty(VentusData.VISIBILITY, visible);
        } else {
            this.d_visible = visible;
            this.changedEvt(VentusData.VISIBILITY);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == VentusData.VISIBILITY) {
            if (!this.isVisibilityLocal()) {
                return super.getProperty(property);
            }
            return this.d_visible;
        }
        return super.getProperty(property);
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == VentusData.VISIBILITY) {
            this.setVisible((Boolean)value);
        } else {
            super.setProperty(property, value);
        }
    }

    @Override
    public String getNewGroupName() {
        return Intl.intl("Geometry Group");
    }
}

