/*
 * Decompiled with CFR 0.152.
 */
package ventus.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import thunderheadeng.gui.ADomainObject;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.IMerlinObj;
import ventus.data.Proxy;
import ventus.data.VentusData;
import ventus.data.schematics.ISchematicObj;
import ventus.geom.IMerlinGeomSrc;

public abstract class AMerlinObj
extends ADomainObject<VentusData>
implements IMerlinObj,
Serializable {
    static final long serialVersionUID = 1L;

    @Override
    public Collection<? extends IMerlinObj> getChildren() {
        return new ArrayList(0);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public Object clone() {
        AMerlinObj clone = (AMerlinObj)super.clone();
        return clone;
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    protected void removeFromDomain(VentusData domain, IMerlinObj parent) {
        if (this instanceof ISchematicObj) {
            domain.topology.remove((ISchematicObj)((Object)this));
        }
        if (this instanceof IMerlinGeomSrc) {
            domain.geomLocation.remove((IMerlinGeomSrc)((Object)this));
        }
        for (IMerlinObj iMerlinObj : this.getChildren()) {
            iMerlinObj.setDomain(null, this);
        }
        this.removedEvt((Object)this);
        ((VentusData)this.getDomain()).hierarchy.removeFromHierarchy(this);
    }

    protected void addToDomain(VentusData domain, IMerlinObj parent) {
        domain.hierarchy.addToHierarchy(parent, this);
        this.addedEvt((Object)this);
        for (IMerlinObj iMerlinObj : this.getChildren()) {
            iMerlinObj.setDomain(domain, this);
        }
        if (this instanceof IMerlinGeomSrc) {
            domain.geomLocation.add((IMerlinGeomSrc)((Object)this));
        }
        if (this instanceof ISchematicObj) {
            domain.topology.add((ISchematicObj)((Object)this));
        }
    }

    @Override
    public void setDomain(VentusData domain, IMerlinObj parent) {
        if (this.getDomain() == domain) {
            return;
        }
        if (this.getDomain() != null) {
            this.pauseUpdates();
            this.removeFromDomain((VentusData)this.getDomain(), parent);
            this.resumeUpdates();
        }
        super.setDomain(domain);
        if (domain != null) {
            this.pauseUpdates();
            this.addToDomain((VentusData)this.getDomain(), parent);
            this.resumeUpdates();
        }
    }

    protected <T extends IMerlinObj> void addChild(T child) {
        child.setDomain((VentusData)this.getDomain(), this);
        this.changedEvt(VentusData.CHILD_ADDED);
    }

    protected <T extends IMerlinObj> void addChildren(T ... children) {
        this.addChildren((Collection<T>)Arrays.asList(children));
    }

    protected <T extends IMerlinObj> void addChildren(Collection<T> children) {
        this.pauseUpdates();
        for (IMerlinObj child : children) {
            this.addChild(child);
        }
        this.resumeUpdates();
    }

    protected <T extends IMerlinObj> void removeChild(T child) {
        child.setDomain(null, this);
        this.changedEvt(VentusData.CHILD_REMOVED);
    }

    protected <T extends IMerlinObj> void removeChildren(T ... children) {
        this.removeChildren((Collection<T>)Arrays.asList(children));
    }

    protected <T extends IMerlinObj> void removeChildren(Collection<T> children) {
        this.pauseUpdates();
        for (IMerlinObj child : children) {
            this.removeChild(child);
        }
        this.resumeUpdates();
    }

    protected static boolean changesExclusiveTo(Object[] changeList, Object ... changes) {
        if (changeList.length == 0) {
            return false;
        }
        for (Object c1 : changeList) {
            boolean found = false;
            for (Object c2 : changes) {
                if (c1 != c2) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean changedEvt(Object ... changes) {
        if (!AMerlinObj.changesExclusiveTo(changes, VentusData.SELECTION_CHANGED)) {
            Collection<Object> proxyParents;
            LinkedIdentityHashSet parents = new LinkedIdentityHashSet();
            parents.add(this.getParent());
            if (this instanceof ICompElement && (proxyParents = Proxy.getProxyParents((ICompElement)((Object)this), true)) != null) {
                parents.addAll(proxyParents);
            }
            for (Object parent : parents) {
                if (!(parent instanceof Composite)) continue;
                if (AMerlinObj.changesExclusiveTo(changes, VentusData.VISIBILITY)) {
                    ((Composite)parent).changedEvt(changes);
                } else {
                    ((Composite)parent).changedEvt(new Object[0]);
                }
                ((Composite)parent).markPropsCacheDirty();
            }
        }
        if (this.getDomain() != null) {
            if (this instanceof IMerlinGeomSrc && !AMerlinObj.changesExclusiveTo(changes, VentusData.SELECTION_CHANGED, VentusData.VISIBILITY, VentusData.CONNECTION)) {
                ((VentusData)this.getDomain()).geomLocation.update((IMerlinGeomSrc)((Object)this));
            }
            if (this instanceof ISchematicObj && theUtil.contains(VentusData.TOPOLOGY, changes)) {
                ((VentusData)this.getDomain()).topology.changed((ISchematicObj)((Object)this));
            }
        }
        return super.changedEvt(changes);
    }
}

