/*
 * Decompiled with CFR 0.152.
 */
package ventus.builders;

import java.awt.Component;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SubtractAction;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.builders.NewCompUtil;
import ventus.data.VentusData;
import ventus.data.schematics.ISchematicObj;
import ventus.data.schematics.geom.SchematicDoor;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.geom.Geometry;
import ventus.util.MerlinProps;

public class DoorBuilder
extends MerlinProps {
    public static final Object NAME_CHANGED = "DoorBuilder.NAME_CHANGED";
    public static final Object LOC_CHANGED = "DoorBuilder.CENTER_CHANGED";
    public static final Object WIDTH_CHANGED = "DoorBuilder.WIDTH_CHANGED";
    public static final Object DEPTH_CHANGED = "DoorBuilder.DEPTH_CHANGED";
    public static final Object FORCEEXIT_CHANGED = "DoorBuilder.FORCEEXIT_CHANGED";
    private final VentusData d_data;
    private UnitPoint3D d_p1 = new UnitPoint3D(0.0, 0.0, 0.0, SI.METER);
    private UnitPoint3D d_p2 = null;
    private UnitDouble d_minWidth = new UnitDouble(18.0, NonSI.INCH);
    private UnitDouble d_maxWidth = new UnitDouble(32.0, NonSI.INCH);
    private UnitDouble d_maxDepth = new UnitDouble(10.0, NonSI.INCH);
    private final UnitDouble d_maxEdgeAngle = SchematicDoor.DEF_MAX_EDGE_ANGLE;
    private boolean d_forceAsExit = false;
    private boolean d_doorSearchDirty = true;
    private SchematicDoor.SearchResult d_doorSearch = null;

    public DoorBuilder(VentusData data) {
        this.d_data = data;
    }

    public UnitDouble getMinWidth() {
        return this.d_minWidth;
    }

    public void setMinWidth(UnitDouble minWidth) {
        if (!this.lock()) {
            return;
        }
        this.d_minWidth = minWidth;
        this.markSearchDirty();
        this.firePropChanged(WIDTH_CHANGED);
        this.release();
    }

    public UnitDouble getMaxWidth() {
        return this.d_maxWidth;
    }

    public void setMaxWidth(UnitDouble maxWidth) {
        if (!this.lock()) {
            return;
        }
        this.d_maxWidth = maxWidth;
        this.markSearchDirty();
        this.firePropChanged(WIDTH_CHANGED);
        this.release();
    }

    public UnitDouble getMaxDepth() {
        return this.d_maxDepth;
    }

    public void setMaxDepth(UnitDouble maxDepth) {
        if (!this.lock()) {
            return;
        }
        this.d_maxDepth = maxDepth;
        this.markSearchDirty();
        this.firePropChanged(DEPTH_CHANGED);
        this.release();
    }

    public boolean isForceAsExit() {
        return this.d_forceAsExit;
    }

    public void setForceAsExit(boolean forceAsExit) {
        if (!this.lock()) {
            return;
        }
        this.d_forceAsExit = forceAsExit;
        this.markSearchDirty();
        this.firePropChanged(FORCEEXIT_CHANGED);
        this.release();
    }

    public UnitPoint3D getP1() {
        return this.d_p1;
    }

    public void setP1(UnitPoint3D p1) {
        if (!this.lock()) {
            return;
        }
        this.d_p1 = p1;
        this.markSearchDirty();
        this.firePropChanged(LOC_CHANGED);
        this.release();
    }

    public UnitPoint3D getP2() {
        return this.d_p1;
    }

    public void setP2(UnitPoint3D p2) {
        if (!this.lock()) {
            return;
        }
        this.d_p2 = p2;
        this.markSearchDirty();
        this.firePropChanged(LOC_CHANGED);
        this.release();
    }

    private void markSearchDirty() {
        this.d_doorSearchDirty = true;
        this.d_doorSearch = null;
    }

    public SchematicDoor.SearchResult getSearchResult() {
        if (this.d_doorSearchDirty) {
            if (this.d_p2 == null) {
                this.d_doorSearch = SchematicDoor.findDoor(this.d_data, this.d_p1.getPoint3dValue(Geometry.LENGTH_UNIT), this.d_data.doorNameGen.getCurrentName(), this.d_forceAsExit, this.d_minWidth.getValue(Geometry.LENGTH_UNIT), this.d_maxWidth.getValue(Geometry.LENGTH_UNIT), 0.0, this.d_maxDepth.getValue(Geometry.LENGTH_UNIT), this.d_maxEdgeAngle.getValue(SI.RADIAN), 0);
            } else {
                Point3d p1 = this.d_p1.getPoint3dValue(Geometry.LENGTH_UNIT);
                Point3d p2 = this.d_p2.getPoint3dValue(Geometry.LENGTH_UNIT);
                this.d_doorSearch = SchematicDoor.findDoor(this.d_data, p1, p2, this.d_data.doorNameGen.getCurrentName(), this.d_maxEdgeAngle.getValue(SI.RADIAN), p1.distance(p2) * 0.5, 0);
            }
            this.d_doorSearchDirty = false;
        }
        return this.d_doorSearch;
    }

    public boolean isValidDoor() {
        return this.getSearchResult() != null;
    }

    public void addDoor(Component c) {
        final SchematicDoor.SearchResult searchResult = this.getSearchResult();
        if (searchResult != null) {
            AMerlinOp op = new AMerlinOp(){

                @Override
                public void run(VentusApp app, VentusData md) {
                    try (VentusData.WriteLock lock = md.lockWrite();){
                        Undo.begin(Intl.intl("New Door"));
                        ArrayList toClean = new ArrayList();
                        DoorBuilder.addDoorToModel(md, searchResult, toClean::add);
                        DoorBuilder.this.d_data.doorNameGen.nextName();
                        SchematicRoom.cleanup(md, toClean);
                        Undo.end(md);
                    }
                }
            };
            UIHook.run(c, "DoorBuilder.addDoor", op, 4);
        }
    }

    private static SchematicRoom toRoom(SchematicDoor door) {
        Model model = door.getDoorGeom().asModel();
        return new SchematicRoom("", model);
    }

    private static void addDoorToModel(VentusData data, SchematicDoor.SearchResult searchResult, Consumer<? super SchematicRoom> toClean) {
        if (!searchResult.door.isThin() && searchResult.door.getRoom1() == searchResult.door.getRoom2()) {
            for (ISchematicObj iSchematicObj : new ArrayList<ISchematicObj>(searchResult.door.getConnections())) {
                searchResult.door.disconnectFrom(iSchematicObj);
            }
            SchematicRoom subRoom = DoorBuilder.toRoom(searchResult.door);
            SubtractAction.subtract(VentusApp.getApp(), data, 0, toClean, subRoom);
        }
        NewCompUtil.addSchematicComp(data, searchResult.door);
    }
}

