/*
 * Decompiled with CFR 0.152.
 */
package ventus.builders;

import java.awt.Component;
import javax.vecmath.Point2d;
import ventus.builders.PlanarGeomBuilder;
import ventus.builders.WorkingPlane;
import ventus.data.VentusData;

public abstract class ATwoPointBuilder
extends PlanarGeomBuilder {
    public static final Object P1_SET = "ATwoPointBuilder.P1_SET";
    public static final Object P2_SET = "ATwoPointBuilder.P2_SET";
    private Point2d d_p1 = null;
    private Point2d d_p2 = null;
    private boolean d_p1Committed = false;
    private boolean d_p2Committed = false;

    public ATwoPointBuilder(VentusData data, WorkingPlane workingPlane, PlanarGeomBuilder.IGeomBuilder builder) {
        super(data, workingPlane, builder);
        this.reset();
    }

    public void setP1(Point2d p1, boolean commit) {
        if (!this.lock()) {
            return;
        }
        this.d_p1 = new Point2d(p1);
        this.d_p1Committed = commit;
        this.firePropChanged(P1_SET);
        this.release();
    }

    public boolean commitP1(boolean commit) {
        if (this.d_p1 == null) {
            return false;
        }
        this.d_p1Committed = commit;
        this.firePropChanged(P1_SET);
        return true;
    }

    public boolean isP1Committed() {
        return this.d_p1Committed;
    }

    public Point2d getP1() {
        return this.d_p1;
    }

    public void setP2(Point2d p2, boolean commit) {
        if (!this.lock()) {
            return;
        }
        this.d_p2 = new Point2d(p2);
        this.d_p2Committed = commit;
        this.firePropChanged(P2_SET);
        this.release();
    }

    public boolean commitP2(boolean commit) {
        if (this.d_p2 == null) {
            return false;
        }
        this.d_p1Committed = commit;
        this.firePropChanged(P2_SET);
        return true;
    }

    public boolean isP2Committed() {
        return this.d_p2Committed;
    }

    public Point2d getP2() {
        return this.d_p2;
    }

    @Override
    public boolean isReadyToBegin() {
        return !this.d_p1Committed && !this.d_p2Committed;
    }

    public boolean isComplete() {
        return this.d_p1Committed && this.d_p2Committed;
    }

    public boolean canComplete() {
        return this.d_p1Committed && this.d_p2Committed && !this.d_p2.equals(this.d_p1);
    }

    public boolean canCancel() {
        return !this.isComplete();
    }

    public void complete(Component c) {
        assert (this.canComplete());
        super.addGeom(c);
        this.reset();
        this.firePropChanged(COMPLETED);
    }

    @Override
    public void reset() {
        this.d_p2 = null;
        this.d_p1 = null;
        this.d_p2Committed = false;
        this.d_p1Committed = false;
    }
}

