/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.importgeom;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.logging.Logger;
import javafx.stage.FileChooser;
import pyroloader.IPyroDataStore;
import pyroloader.PyroLoadOptions;
import pyroloader.PyroLoader;
import thunderheadeng.gui.wizard.AWizardCard;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.IPropertySet;
import ventus.VentusApp;
import ventus.actions.CancelledException;
import ventus.actions.importgeom.IImporter;
import ventus.actions.importgeom.PyroGeomConverter;
import ventus.actions.importgeom.PyroImporter;
import ventus.data.VentusData;

public class ImportPSM
implements IImporter {
    private static final Logger LOGGER = Logger.getLogger(ImportPSM.class.getName());
    private static final IPropertySet.Prop<String> PYRO_LOADER = new IPropertySet.Prop<String>("pyroloader", "pyrosim-lite/pyrosim.jar");

    @Override
    public FileChooser.ExtensionFilter[] getFileFilters() {
        return new FileChooser.ExtensionFilter[]{FileFilters.EXT_FILTER_FDS4, FileFilters.EXT_FILTER_FDS6, FileFilters.EXT_FILTER_PYROSIM};
    }

    @Override
    public void initDefaultOptions(VentusData md, String ext, IPropertySet options) {
    }

    @Override
    public AWizardCard<IPropertySet> getCard(IPropertySet options) {
        return null;
    }

    @Override
    public void cleanup(IPropertySet options) {
    }

    @Override
    public IImporter.Result read(VentusApp app, String fn, IPropertySet options) throws IOException, CancelledException {
        try {
            String ext = FilenameManager.getExtension(fn);
            if (ext.equalsIgnoreCase("data") || ext.equalsIgnoreCase("fds")) {
                return ImportPSM.importFDS(app, fn, options);
            }
            if (ext.equalsIgnoreCase("psm")) {
                return ImportPSM.importPSM(app, fn, options);
            }
            return IImporter.Result.EMPTY;
        }
        catch (CancelledException e) {
            throw e;
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    private static IImporter.Result importPSM(VentusApp app, String fn, IPropertySet ioptions) throws Throwable {
        System.out.println("importing PSM file: " + fn);
        try {
            PyroLoader loader = ImportPSM.getPyroLoader(app);
            IPyroDataStore data = loader.loadPyroSim(VentusApp.getApp().getActiveFrame(), fn, ImportPSM.getPyroLoadOptions());
            return PyroImporter.importPyroData(app, fn, ioptions, data);
        }
        catch (CancellationException e) {
            throw CancelledException.INSTANCE;
        }
    }

    private static IImporter.Result importFDS(VentusApp app, String fn, IPropertySet ioptions) throws Throwable {
        System.out.println("importing FDS file: " + fn);
        try {
            PyroLoader loader = ImportPSM.getPyroLoader(app);
            IPyroDataStore data = loader.loadFDS(VentusApp.getApp().getActiveFrame(), fn, ImportPSM.getPyroLoadOptions());
            return PyroImporter.importPyroData(app, fn, ioptions, data);
        }
        catch (CancellationException e) {
            throw CancelledException.INSTANCE;
        }
    }

    private static PyroLoader getPyroLoader(VentusApp app) {
        String loaderName = System.getProperty(ImportPSM.PYRO_LOADER.key.toString(), (String)ImportPSM.PYRO_LOADER.defVal);
        String pyroJar = app.getResourceFile(loaderName);
        PyroLoader loader = PyroLoader.get(pyroJar);
        if (loaderName.equals(ImportPSM.PYRO_LOADER.defVal)) {
            return loader;
        }
        try {
            if (!new File(pyroJar).exists()) {
                throw new FileNotFoundException(pyroJar);
            }
            loader.validate();
            return loader;
        }
        catch (Exception e) {
            TeciLogging.log(LOGGER, "Could not load debug PyroSim jar: " + pyroJar, (Throwable)e);
            return PyroLoader.get(app.getResourceFile((String)ImportPSM.PYRO_LOADER.defVal));
        }
    }

    private static PyroLoadOptions getPyroLoadOptions() {
        PyroLoadOptions loadOptions = new PyroLoadOptions();
        VentusApp app = VentusApp.getApp();
        loadOptions.setApplicationData(app.getAppName(), app.getInstallDir(), app.getActiveFrame());
        loadOptions.setCutHoles(true);
        loadOptions.setSupportedGeomTypes(PyroGeomConverter.getSupportedPyroGeomTypes());
        return loadOptions;
    }
}

