/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.geomops;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashMap;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.Delete;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.VentusData;
import ventus.data.schematics.geom.RoomUtil;
import ventus.data.schematics.geom.SchematicRoom;

public class SeparateGeom
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SeparateGeom(), Intl.intl("Sepa&rate,P,Separate the selected rooms,Separate disjoint rooms from one another."));

    public SeparateGeom() {
        SelectionObserver.add(this, SchematicRoom.class);
        this.update(null);
    }

    @Override
    public void update(Events events) {
        VentusData md = VentusApp.getApp().getData();
        this.setEnabled(!md.selection.isDeepEmpty(SchematicRoom.class));
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        Set<SchematicRoom> sel = md.selection.getDeepSelected(SchematicRoom.class);
        if (sel.isEmpty()) {
            return;
        }
        try (VentusData.WriteLock lock = md.lockWrite();){
            ArrayList toClean = new ArrayList();
            SeparateGeom.separate(md, sel, toClean::add, (key, child) -> {});
            SchematicRoom.cleanup(md, toClean);
        }
    }

    public static Map<SchematicRoom, List<SchematicRoom>> separate(VentusData md, Collection<SchematicRoom> rooms, Consumer<? super SchematicRoom> toClean) {
        return SeparateGeom.separate(md, rooms, toClean, (parent, child) -> {});
    }

    public static Map<SchematicRoom, List<SchematicRoom>> separate(VentusData md, Collection<SchematicRoom> rooms, Consumer<? super SchematicRoom> toClean, BiConsumer<? super SchematicRoom, ? super SchematicRoom> toSelect) {
        Undo.begin(Intl.intl("Separate"));
        LinkedIdentityHashMap<SchematicRoom, List<SchematicRoom>> result = new LinkedIdentityHashMap<SchematicRoom, List<SchematicRoom>>();
        boolean modified = false;
        for (SchematicRoom geom : rooms) {
            if (!geom.getModificationsAllowed()) continue;
            List<SchematicRoom> comps = geom.separate();
            result.put(geom, comps);
            if (comps.size() <= 1) continue;
            RoomUtil.assignSeparatedProps(comps, md.roomNameGen);
            Composite parent = (Composite)md.hierarchy.getParent(geom);
            Undo.insertUndoEntry_delete(md, parent, comps);
            parent.addAll(comps);
            modified = true;
            comps.forEach(toClean);
            for (SchematicRoom comp : comps) {
                toSelect.accept(geom, comp);
            }
        }
        Set toDelete = result.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(e -> (SchematicRoom)e.getKey()).collect(Collectors.toSet());
        if (!toDelete.isEmpty()) {
            Delete.deleteAll(md, toDelete);
        }
        Undo.end(md, modified);
        return result;
    }
}

