/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions.copypaste;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.util.Warning;
import ventus.VentusApp;
import ventus.actions.copypaste.CopyPasteUtil;
import ventus.actions.copypaste.PasteHandler;
import ventus.actions.copypaste.PasteHints;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.IMerlinObj;
import ventus.data.INamed;
import ventus.data.VentusData;

public class DefaultPasteHandler
implements PasteHandler {
    private final Class acceptedClass;

    public DefaultPasteHandler(Class clazz) {
        this.acceptedClass = clazz;
    }

    @Override
    public boolean isHandlerFor(IDomainObject obj, String mdRootField) {
        return this.acceptedClass.getName().equals(mdRootField);
    }

    @Override
    public PasteHints getPasteHints(VentusData md, Map<IDomainObject, String> pasteObjMap, IDomainObject pasteObj) {
        return new PasteHints();
    }

    @Override
    public void pasteApply(VentusData md, VentusApp app, Map<IDomainObject, String> pasteObjMap, Map.Entry<IDomainObject, String> pasteEntry, PasteHints hints, Collection<Composite<ICompElement>> selectedComposites, Collection<IMerlinObj> selectedLeaves, Consumer<? super IDomainObject> allPastedObjs, Consumer<? super Warning> warnings) {
        IDomainObject pasteObj = pasteEntry.getKey();
        Composite<ICompElement> defaultRoot = CopyPasteUtil.getDefaultRoot(md, pasteEntry);
        Composite insertRoot = CopyPasteUtil.getBestPasteTarget(md, pasteObj, defaultRoot, selectedComposites, selectedLeaves);
        if (!CopyPasteUtil.validInsertRoot(this.getClass(), pasteObj, insertRoot, warnings)) {
            return;
        }
        Collection<INamed> nameSibs = insertRoot.getMembers(INamed.class);
        CopyPasteUtil.renamePasteObj(nameSibs, pasteObj);
        CopyPasteUtil.pasteIntoAndTransform(md, app, pasteObj, hints, allPastedObjs, insertRoot, true);
        allPastedObjs.accept(pasteObj);
    }
}

