/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import thunderheadeng.util.LinkedIdentityHashSet;
import ventus.EntryPoint;
import ventus.EntryPointFactory;
import ventus.VentusApp;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.VentusData;
import ventus.mv.displays.GlobalDisplayMgr;
import ventus.util.MerlinUtil;

public class Visibility {
    public static void setVisibility(VentusData md, Collection<?> toShow, Collection<?> toHide, boolean hideFirst) {
        LinkedIdentityHashSet<ICompElement> showObjs = new LinkedIdentityHashSet<ICompElement>(toShow.size());
        LinkedIdentityHashSet<ICompElement> hideObjs = new LinkedIdentityHashSet<ICompElement>(toHide.size());
        for (Object obj : toShow) {
            Visibility.collectVisibilityHierarchy(md, showObjs, obj);
        }
        for (Object obj : toHide) {
            Visibility.collectVisibilityHierarchy(md, hideObjs, obj);
        }
        Visibility.removeGroups(showObjs);
        Visibility.removeGroups(hideObjs);
        if (Visibility.containsClipped(md, toShow)) {
            hideObjs.removeAll(md.floors.getMembers());
            showObjs.addAll(md.floors.getMembers());
        }
        if (hideFirst) {
            hideObjs.removeAll(showObjs);
            Undo.insertUndoEntry_restoreSelection(md);
            Undo.insertUndoEntry_propRestore(md, hideObjs, VentusData.VISIBILITY);
            Undo.insertUndoEntry_propRestore(md, showObjs, VentusData.VISIBILITY);
            Visibility.setVisibility(md, hideObjs, false);
            Visibility.setVisibility(md, showObjs, true);
        } else {
            showObjs.removeAll(hideObjs);
            Undo.insertUndoEntry_restoreSelection(md);
            Undo.insertUndoEntry_propRestore(md, showObjs, VentusData.VISIBILITY);
            Undo.insertUndoEntry_propRestore(md, hideObjs, VentusData.VISIBILITY);
            Visibility.setVisibility(md, showObjs, true);
            Visibility.setVisibility(md, hideObjs, false);
        }
    }

    private static boolean containsClipped(VentusData md, Collection<?> objs) {
        VentusApp app = VentusApp.getApp();
        if (app == null) {
            return false;
        }
        GlobalDisplayMgr dispMgr = app.getModelView().getDisplayManager();
        for (Object o : MerlinUtil.flatten(objs)) {
            if (!dispMgr.isClippedByFloor(o)) continue;
            return true;
        }
        return false;
    }

    private static void collectVisibilityHierarchy(VentusData md, Set<ICompElement> coll, Object obj) {
        if (!(obj instanceof ICompElement) || !coll.add((ICompElement)obj)) {
            return;
        }
        for (Object child : md.hierarchy.getChildren(obj)) {
            Visibility.collectVisibilityHierarchy(md, coll, child);
        }
    }

    private static void removeGroups(Set<ICompElement> coll) {
        Iterator<ICompElement> it = coll.iterator();
        while (it.hasNext()) {
            ICompElement obj = it.next();
            if (!(obj instanceof Composite) || obj.getPropTypes(1).contains(VentusData.VISIBILITY)) continue;
            it.remove();
        }
    }

    private static void setVisibility(VentusData vd, Set<ICompElement> objs, boolean visibility) {
        for (ICompElement obj : objs) {
            EntryPoint<ICompElement> ep = EntryPointFactory.get(obj);
            ep.setVisible(vd, obj, visibility);
        }
    }
}

