/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.ArrayList;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.data.IMerlinObj;
import ventus.data.VentusData;
import ventus.gui.ShowObjectsDlg;
import ventus.util.Dependencies;

public class ShowReferencingObjects
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new ShowReferencingObjects(), Intl.intl("Show Referencing Objects..."));

    public ShowReferencingObjects() {
        SelectionObserver.add(this, IMerlinObj.class);
        this.update(null);
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        int types = 0;
        for (Dependencies.Type type : Dependencies.Type.values()) {
            if (md.selection.isDeepEmpty(type.mtype)) continue;
            types |= type.flag;
        }
        LinkedIdentityHashSet referencing = new LinkedIdentityHashSet();
        Dependencies.getObjReferences(md, types, obj -> md.selection.isSelected(obj), (src, target) -> referencing.add(src));
        ShowObjectsDlg dlg = new ShowObjectsDlg(app.getActiveFrame(), md, Intl.intl("Show Referencing Objects"), Intl.intl("Select Referencing Objects"), referencing);
        dlg.doModeless();
    }

    @Override
    public void update(Events events) {
        VentusData md = VentusApp.getApp().getData();
        ArrayList<Class<? extends IMerlinObj>> types = new ArrayList<Class<? extends IMerlinObj>>();
        for (Dependencies.Type type : Dependencies.Type.values()) {
            types.add(type.mtype);
        }
        this.setEnabled(md.selection.isExclusive(theUtil.toArray(types, Class.class)));
    }
}

