/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.Collection;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.VentusData;
import ventus.util.MerlinUtil;

public class SelectNonGroupDescendents
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SelectNonGroupDescendents(), Intl.intl("Select Non-Group Descendants"));

    public SelectNonGroupDescendents() {
        SelectionObserver.add(this, Composite.class);
        this.update();
    }

    public void update() {
        this.setEnabled(VentusApp.getApp().getData().selection.contains(Composite.class));
    }

    @Override
    public void update(Events events) {
        this.update();
    }

    @Override
    public void run(VentusApp app, VentusData vd) {
        try (VentusData.WriteLock lock = vd.lockWrite();){
            Undo.begin(Intl.intl("Select Non-Group Descendants"));
            Undo.insertUndoEntry_restoreSelection(vd);
            Collection<ICompElement> toSelect = MerlinUtil.flattenComposites(vd.selection.getSelected(ICompElement.class));
            vd.selection.clear();
            vd.selection.selectAll(toSelect);
            Undo.end(vd);
        }
    }
}

