/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.Pair;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.AddObject;
import ventus.actions.EditObjects;
import ventus.actions.SelectionObserver;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.IMerlinObj;
import ventus.data.INameGenerator;
import ventus.data.VentusData;
import ventus.gui.NewDlg;

public class NewObject<T extends ICompElement>
extends AMerlinOp
implements IEventObserver {
    private final String d_newMsg;
    private final Object d_propName;
    private final Class<T> d_clazz;
    private final Class<? extends Composite<? super T>> d_compClass;
    private final Function<VentusData, Composite<? super T>> d_getRoot;
    private final Function<VentusData, INameGenerator> d_getNameGenerator;
    private final BiConsumer<EditObjects.CompositeManager<T>, T> d_createEditDlg;
    private final Function<VentusData, T> d_getNewObject;
    private final BiFunction<VentusData, T, T> d_fromExistingObject;
    private final boolean d_requireSelection;

    public NewObject(Class<T> clazz, Function<VentusData, Composite<? super T>> getRoot, Function<VentusData, INameGenerator> getNameGenerator, BiConsumer<EditObjects.CompositeManager<T>, T> createEditDlg, String newMsg, Object propName, Class<? extends Composite<? super T>> compClass, Function<VentusData, T> getNewObject, BiFunction<VentusData, T, T> fromExistingObject, boolean requireSelection) {
        this.d_clazz = clazz;
        this.d_getRoot = getRoot;
        this.d_getNameGenerator = getNameGenerator;
        this.d_createEditDlg = createEditDlg;
        this.d_newMsg = newMsg;
        this.d_propName = propName;
        this.d_compClass = compClass;
        this.d_getNewObject = getNewObject;
        this.d_fromExistingObject = fromExistingObject;
        this.d_requireSelection = requireSelection;
        if (this.d_requireSelection) {
            SelectionObserver.add(this, IMerlinObj.class);
            this.update(null);
        }
    }

    @Override
    public void update(Events events) {
        VentusData md = VentusApp.getApp().getData();
        this.setEnabled(md.selection.isSingleExclusive(this.d_compClass));
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        this.add(app, md, true);
    }

    public void add(VentusApp app, VentusData md, boolean editAfter) {
        ICompElement newObj;
        Pair<String, T> newObjInfo = NewObject.promptForNewObject(app.getActiveFrame(), md, this.d_getNameGenerator.apply(md).getCurrentName(), this.d_getRoot.apply(md), this.d_clazz, this.d_newMsg, this.d_propName);
        if (newObjInfo == null) {
            return;
        }
        try (VentusData.WriteLock lock = md.lockWrite();){
            Composite parent;
            Composite composite = parent = editAfter && this.d_requireSelection ? (Composite)md.selection.getSelected(Composite.class).iterator().next() : this.d_getRoot.apply(md);
            assert (parent != null);
            newObj = NewObject.newObj(md, (ICompElement)newObjInfo.v2, (String)newObjInfo.v1, this.d_clazz, this.d_newMsg, parent, this.d_getNameGenerator, this.d_getNewObject, this.d_fromExistingObject);
        }
        if (editAfter) {
            EditObjects.editObject(app, md, newObj, this.d_propName, this.d_getRoot.apply(md), this.d_createEditDlg, this.d_clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ICompElement> T newObj(VentusData md, T objBase, String name, Class<T> clazz, String newMsg, Composite<? super T> parent, Function<VentusData, INameGenerator> getNameGenerator, Function<VentusData, T> getNewObject, BiFunction<VentusData, T, T> fromExisting) {
        ICompElement objNew = null;
        Undo.begin(Intl.intl(newMsg));
        try {
            objNew = objBase != null ? (ICompElement)fromExisting.apply(md, (VentusData)((Object)objBase)) : (ICompElement)getNewObject.apply(md);
            objNew.setName(name);
            INameGenerator nameGenerator = getNameGenerator.apply(md);
            if (name.equals(nameGenerator.getCurrentName())) {
                nameGenerator.nextName();
            }
            AddObject.add((VentusData)md, parent, (int)parent.getMembers().size(), (ICompElement[])new ICompElement[]{objNew});
        }
        catch (Throwable e) {
            assert (false);
        }
        finally {
            Undo.end(md);
        }
        return (T)objNew;
    }

    public static String promptForName(Component owner, VentusData md, String initName, Composite<? extends ICompElement> group, Class<? extends ICompElement> clazz, String newMsg, Object propName) {
        Pair<String, ? extends ICompElement> result = NewObject.promptForNameOnEQ(md, owner, initName, NewObject.getInUseNames(md, group, clazz, propName), false, clazz, newMsg);
        return result != null ? (String)result.v1 : null;
    }

    public static <T extends ICompElement> Pair<String, T> promptForNewObject(Component owner, VentusData md, String initName, Composite<? extends ICompElement> group, Class<T> clazz, String newMsg, Object propName) {
        return NewObject.promptForNameOnEQ(md, owner, initName, NewObject.getInUseNames(md, group, clazz, propName), true, clazz, newMsg);
    }

    private static <T extends IMerlinObj> Pair<String, T> promptForNameOnEQ(VentusData md, final Component owner, final String initName, final Collection<String> inUse, final boolean newObject, final Class<T> clazz, final String newMsg) {
        Callable worker = new Callable<Pair<String, T>>(){

            @Override
            public Pair<String, T> call() {
                return NewObject.promptForName(owner, initName, inUse, newObject, clazz, newMsg);
            }
        };
        return (Pair)md.ui(worker);
    }

    private static <T extends IMerlinObj> Pair<String, T> promptForName(Component owner, String initName, Collection<String> inUse, boolean newObject, Class<T> clazz, String newMsg) {
        String newName = null;
        Object baseObject = null;
        boolean valid = false;
        boolean same = false;
        boolean contained = true;
        do {
            String msg;
            if (newObject) {
                Window wowner = owner instanceof Window ? (Window)owner : SwingUtilities.getWindowAncestor(owner);
                NewDlg<T> dlg = new NewDlg<T>(wowner, VentusApp.getApp().getData(), newMsg, initName, clazz);
                if (dlg.doModal() != 1) {
                    return null;
                }
                newName = dlg.getName();
                baseObject = dlg.getBaseObject();
            } else {
                newName = JOptionPane.showInputDialog(owner, Intl.intl("Name"), initName);
                if (newName == null) {
                    return null;
                }
            }
            valid = newName.length() > 0;
            same = initName.equals(newName);
            contained = inUse.contains(newName);
            if (!valid) {
                msg = Intl.intl("Please provide a name.");
                JOptionPane.showMessageDialog(owner, msg, Intl.intl("Invalid Entry"), 0);
                continue;
            }
            if (same || !contained) continue;
            msg = String.format(Intl.intl("The name \"%s\" is already in use."), newName);
            JOptionPane.showMessageDialog(owner, msg, Intl.intl("Invalid Entry"), 0);
        } while (!valid || !same && contained);
        return new Pair<String, Object>(newName, baseObject);
    }

    public static Set<String> getInUseNames(VentusData md, Composite<? extends ICompElement> group, Class<? extends ICompElement> objType, Object nameProp) {
        LinkedHashSet<String> inUse = new LinkedHashSet<String>();
        for (ICompElement iCompElement : group.flatten(objType)) {
            inUse.add((String)iCompElement.getProperty(nameProp));
        }
        return inUse;
    }
}

