/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;
import ventus.actions.InfernoGeomBuilder;
import ventus.data.INamed;
import ventus.data.VentusData;
import ventus.data.schematics.SimError;
import ventus.data.schematics.elevators.Elevator;
import ventus.data.schematics.elevators.ElevatorDoor;
import ventus.data.schematics.elevators.ElevatorRoom;
import ventus.data.schematics.geom.ASchematicComp;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.geom.IMerlinDispProps;
import ventus.io.inferno.InfernoGeom;
import ventus.mv.MerlinColors;
import ventus.mv.displays.MerlinDispProps;
import ventus.util.MerlinUtil;

public class InfernoUtil {
    public static final Unit LENGTH_UNIT = SI.METER;
    public static final Unit TIME_UNIT = SI.SECOND;
    public static final Unit VEL_UNIT = SI.METER.divide(SI.SECOND);
    public static final Unit OCC_DENSITY_UNIT = Unit.ONE.divide(SI.METER.pow(2));
    private static final Logger LOGGER = Logger.getLogger(InfernoUtil.class.getName());

    public static String rootFn(String pthFn) {
        int ixSlash = pthFn.lastIndexOf(92);
        if (ixSlash > -1) {
            pthFn = pthFn.substring(ixSlash);
        }
        while (pthFn.toLowerCase().endsWith(".pth") || pthFn.toLowerCase().endsWith(".txt")) {
            pthFn = pthFn.substring(0, pthFn.length() - 4);
        }
        return pthFn;
    }

    private static MerlinDispProps getDisplayProps(VentusData md) {
        MerlinDispProps props = new MerlinDispProps(md, new MerlinColors(), Predicates.alwaysFalse());
        props.setColorRoomsBy(MerlinDispProps.ColorRoomsBy.SET_COLOR);
        props.setDoorDrawOptions(-1, false);
        props.setStairDrawOptions(-1, false);
        return props;
    }

    private static InfernoGeomInfo buildMesh(VentusData md, Object kb, Object tags, List<SimError> errors, Map<ISchematicComp, Object> nodeMap, Map<Elevator, Object> elevatorMap) {
        MerlinDispProps dispProps = InfernoUtil.getDisplayProps(md);
        InfernoGeomInfo infernoGeom = InfernoUtil.collectInfernoGeom(dispProps, InfernoUtil.collectEnabledComps(md));
        List<InfernoGeom> igeoms = infernoGeom.igeoms;
        HashMap matMap = new HashMap();
        HashMap camIdMap = new HashMap();
        InfernoGeomBuilder[] meshes = InfernoUtil.constructMeshes(md, igeoms, errors);
        return infernoGeom;
    }

    public static Set<ISchematicComp> collectEnabledComps(VentusData md) {
        LinkedIdentityHashSet<ISchematicComp> enabledComps = new LinkedIdentityHashSet<ISchematicComp>();
        Collection<Elevator> elevators = md.elevators.getDeepMembers(Elevator.class);
        LinkedHashSet<ASchematicComp> elevatorComps = new LinkedHashSet<ASchematicComp>();
        for (Elevator el : elevators) {
            Collection<ElevatorDoor> elDoors = el.getDeepMembers(ElevatorDoor.class);
            IFilteredCollection<ElevatorDoor> enabledDoors = theUtil.filter(elDoors, c -> c.isEnabled());
            if (enabledDoors.isEmpty()) continue;
            elevatorComps.addAll(el.getDeepMembers(ElevatorRoom.class));
            elevatorComps.addAll(enabledDoors);
        }
        enabledComps.addAll(elevatorComps);
        InfernoUtil.collectAllComponents(md, md.floors.getDeepMembers(ISchematicComp.class), enabledComps);
        return enabledComps;
    }

    private static InfernoGeomInfo collectInfernoGeom(IMerlinDispProps dprops, Set<ISchematicComp> comps) {
        InfernoGeomInfo result = new InfernoGeomInfo();
        for (ISchematicComp comp : comps) {
            ArrayList<InfernoGeom> compGeoms = new ArrayList<InfernoGeom>(3);
            comp.getInfernoGeom(compGeoms, dprops);
            if (compGeoms.isEmpty()) continue;
            result.igeoms.addAll(compGeoms);
            result.finalComps.put(comp, compGeoms);
        }
        return result;
    }

    public static InfernoGeomInfo collectInfernoGeom(VentusData md) {
        return InfernoUtil.collectInfernoGeom(InfernoUtil.getDisplayProps(md), InfernoUtil.collectEnabledComps(md));
    }

    private static void collectAllComponents(VentusData md, Collection<? extends ISchematicComp> objs, Set<ISchematicComp> result) {
        objs = MerlinUtil.getEnabledMembers(md, objs, ISchematicComp.class);
        for (ISchematicComp iSchematicComp : objs) {
            result.add(iSchematicComp);
        }
    }

    private static <K, V> V getNonNull(Map<K, V> map, K key) {
        V result = map.get(key);
        assert (result != null);
        return result;
    }

    private static Object getStopParent(VentusData md, ISchematicComp obj) {
        if (md.hierarchy.isDescendent(md.floors, obj)) {
            return md.floors;
        }
        if (md.hierarchy.isDescendent(md.elevators, obj)) {
            return md.elevators;
        }
        return md;
    }

    private static ISchematicComp findDoubleDeckTopDischargeRoom(Elevator elevator) {
        ArrayList<ElevatorRoom> elevatorRooms = new ArrayList<ElevatorRoom>(elevator.getDeepMembers(ElevatorRoom.class));
        int dischargeIndex = elevatorRooms.indexOf(elevator.getDischargeRoom());
        assert (dischargeIndex < elevatorRooms.size() - 1);
        return (ISchematicComp)elevatorRooms.get(dischargeIndex + 1);
    }

    private static Point3d[] translatePoints(Point3d[] points, Point3d offset) {
        Point3d[] translated = new Point3d[points.length];
        for (int i = 0; i < points.length; ++i) {
            translated[i] = Util3D.add(points[i], (Tuple3d)offset);
        }
        return translated;
    }

    public static String getPathName(VentusData md, Object stopParent, Object obj, boolean annotate) {
        if (stopParent == null) {
            stopParent = md;
        }
        Object[] path = md.hierarchy.getPath(obj, stopParent, false);
        Object pathName = "";
        if (annotate) {
            for (int m = 0; m < path.length; ++m) {
                if (m != 0) {
                    pathName = (String)pathName + "->";
                }
                assert (path[m] instanceof INamed);
                INamed node = (INamed)path[m];
                pathName = (String)pathName + node.getName();
            }
        } else {
            int size = path.length;
            assert (path[size - 1] instanceof INamed);
            INamed node = (INamed)path[size - 1];
            pathName = (String)pathName + node.getName();
        }
        return pathName;
    }

    private static String format(Point3d p) {
        return String.format("(%s, %s, %s)", Global.format(p.x), Global.format(p.y), Global.format(p.z));
    }

    public static InfernoGeomBuilder[] constructMeshes(VentusData md, List<InfernoGeom> igeoms, List<SimError> errors) {
        Random rnd = new Random();
        UnitDouble maxWidth = new UnitDouble(0.0, SI.METER);
        InfernoGeomBuilder.Param refineParams = md.simParams.getMeshBuilderParams();
        return InfernoGeomBuilder.constructMeshes(igeoms, errors, maxWidth.getValue(SI.METER) * 0.5, refineParams);
    }

    public static class InfernoGeomInfo {
        public final List<InfernoGeom> igeoms = new ArrayList<InfernoGeom>();
        public final Map<ISchematicComp, List<InfernoGeom>> finalComps = new LinkedIdentityHashMap<ISchematicComp, List<InfernoGeom>>();
    }

    public static class KBInfo {
        public final Object kb;
        public final Map<ISchematicComp, Object> nodeMap;
        public final InfernoGeomInfo igeoms;

        public KBInfo(Object kb, Map<ISchematicComp, Object> nodeMap, InfernoGeomInfo igeoms) {
            this.kb = kb;
            this.nodeMap = nodeMap;
            this.igeoms = igeoms;
        }
    }
}

