/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.swing.JOptionPane;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.CompElementActions;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.data.AMerlinObj;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.VentusData;
import ventus.data.schematics.geom.ASchematicComp;
import ventus.data.schematics.geom.SchematicCorridor;
import ventus.data.schematics.geom.SchematicDoor;
import ventus.data.schematics.geom.SchematicRoom;

public class EnableAction
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_ENABLE_HOOK = new UIHook(new EnableAction(true), Intl.intl("Enable"));
    public static final UIHook UI_DISABLE_HOOK = new UIHook(new EnableAction(false), Intl.intl("Disable"));
    private final boolean d_enable;

    public EnableAction(boolean enable) {
        this.d_enable = enable;
        VentusApp.getApp().getData().getEvents().addObserver(this);
        this.updateEnabled();
    }

    @Override
    public void update(Events events) {
        IEventRecord<ICompElement> evts = events.getEvents(ICompElement.class, new Class[0]);
        if (evts.hasChangedObjs(VentusData.SELECTION_CHANGED, VentusData.ENABLED) || evts.hasRemovedObjs() || evts.hasAddedObjs()) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        VentusData md = VentusApp.getApp().getData();
        Set sel = md.selection.getSelected(ICompElement.class);
        Set<Object> sharedProps = Composite.getPropTypes(0, sel);
        if (!sharedProps.contains(VentusData.ENABLED)) {
            this.setEnabled(false);
            return;
        }
        Object val = Composite.getProperty(VentusData.ENABLED, sel);
        if (this.d_enable) {
            this.setEnabled(!(val instanceof Boolean) || (Boolean)val == false);
        } else {
            this.setEnabled(!(val instanceof Boolean) || (Boolean)val != false);
        }
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        String undoName = this.d_enable ? Intl.intl("Enable") : Intl.intl("Disable");
        Set<ICompElement> sel = md.selection.getDeepSelected(ICompElement.class);
        Optional<Set<ICompElement>> allObjs = this.collectAndValidate(sel, app, md);
        if (allObjs.isPresent()) {
            try (VentusData.WriteLock lock = md.lockWrite();){
                Undo.begin(undoName);
                CompElementActions.setProperty(VentusData.ENABLED, (Collection<? extends ICompElement>)allObjs.get(), this.d_enable);
                Undo.end(md);
            }
        }
    }

    private Optional<Set<ICompElement>> collectAndValidate(Set<ICompElement> sel, VentusApp app, VentusData md) {
        IFilteredCollection<ASchematicComp> selectedComponents = theUtil.filter(sel, ASchematicComp.class);
        LinkedHashSet<AMerlinObj> connectedObjs = new LinkedHashSet<AMerlinObj>();
        for (ASchematicComp comp : selectedComponents) {
            connectedObjs.addAll(comp.getConnObjectsForEnable(md));
        }
        IFilteredCollection<AMerlinObj> connObjs = theUtil.filter(connectedObjs, o -> {
            if (!(o instanceof ICompElement)) {
                return false;
            }
            ICompElement el = (ICompElement)((Object)o);
            if (ICompElement.NOT_SUPPORTED.equals(el.getProperty(VentusData.ENABLED)) || ICompElement.NON_UNIFORM.equals(el.getProperty(VentusData.ENABLED))) {
                return false;
            }
            if ((Boolean)el.getProperty(VentusData.ENABLED) == this.d_enable) {
                return false;
            }
            return !sel.contains(el);
        });
        if (!connObjs.isEmpty()) {
            String title;
            String msg;
            int choice;
            IFilteredCollection<SchematicRoom> rooms = theUtil.filter(connObjs, SchematicRoom.class);
            IFilteredCollection<SchematicCorridor> corridors = theUtil.filter(connObjs, SchematicCorridor.class);
            IFilteredCollection<SchematicDoor> doors = theUtil.filter(connObjs, SchematicDoor.class);
            Object connObjMsg = "";
            boolean addSep = false;
            if (!rooms.isEmpty()) {
                if (addSep) {
                    connObjMsg = (String)connObjMsg + ", ";
                }
                connObjMsg = (String)connObjMsg + String.format(rooms.size() == 1 ? Intl.intl("%d room") : Intl.intl("%d rooms"), rooms.size());
                addSep = true;
            }
            if (!corridors.isEmpty()) {
                if (addSep) {
                    connObjMsg = (String)connObjMsg + ", ";
                }
                connObjMsg = (String)connObjMsg + String.format(corridors.size() == 1 ? Intl.intl("%d stair/ramp") : Intl.intl("%d stairs/ramps"), corridors.size());
                addSep = true;
            }
            if (!doors.isEmpty()) {
                if (addSep) {
                    connObjMsg = (String)connObjMsg + ", ";
                }
                connObjMsg = (String)connObjMsg + String.format(doors.size() == 1 ? Intl.intl("%d door") : Intl.intl("%d doors"), doors.size());
                addSep = true;
            }
            if ((choice = md.ui(() -> EnableAction.lambda$collectAndValidate$1(app, msg = String.format(this.d_enable ? Intl.intl("Other connected objects (%s) will be enabled.\n Do you still want to enable selected objects?") : Intl.intl("Other connected objects (%s) will be disabled.\n Do you still want to disable selected objects?"), connObjMsg), title = this.d_enable ? Intl.intl("Enable?") : Intl.intl("Disable?"))).intValue()) != 0) {
                return Optional.empty();
            }
        }
        LinkedHashSet<ICompElement> collectedObjs = new LinkedHashSet<ICompElement>(sel);
        connObjs.forEach(o -> collectedObjs.add((ICompElement)((Object)o)));
        return Optional.of(collectedObjs);
    }

    private static /* synthetic */ Integer lambda$collectAndValidate$1(VentusApp app, String msg, String title) throws Exception {
        return JOptionPane.showConfirmDialog(app.getActiveFrame(), msg, title, 0);
    }
}

