/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepSnapshot;
import thunderheadeng.dependencies.Dependency;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;
import ventus.EntryPoint;
import ventus.EntryPointFactory;
import ventus.Intl;
import ventus.VentusApp;
import ventus.actions.AMerlinOp;
import ventus.actions.CancelledException;
import ventus.actions.MerlinOp;
import ventus.actions.SelectionObserver;
import ventus.actions.SetWorkingGroup;
import ventus.actions.UIHook;
import ventus.actions.Undo;
import ventus.builders.NewCompUtil;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.IMerlinObj;
import ventus.data.IRestorable;
import ventus.data.NamedMerlinObj;
import ventus.data.Proxy;
import ventus.data.VentusData;
import ventus.data.material.Material;
import ventus.data.schematics.Floor;
import ventus.data.schematics.elevators.Elevator;
import ventus.data.schematics.elevators.ElevatorDoor;
import ventus.data.schematics.elevators.ElevatorRoom;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.data.schematics.geom.ISchematicConnector;
import ventus.data.schematics.geom.SchematicDoor;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.feature.comps.DeleteHandler;
import ventus.gui.MerlinComboBox;
import ventus.util.Dependencies;
import ventus.util.MerlinUtil;
import ventus.util.VentusDepSnapshot;

public class Delete
extends AMerlinOp
implements IEventObserver {
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/Delete16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new Delete(), Intl.intl("&Delete...,D,Delete selected objects"), ICON);

    public Delete() {
        SelectionObserver.add(this, Object.class);
        this.update(null);
    }

    private boolean canDelete(VentusData md) {
        return !md.selection.isEmpty();
    }

    @Override
    public void update(Events events) {
        VentusData md = VentusApp.getApp().getData();
        this.setEnabled(this.canDelete(md));
    }

    @Override
    public void run(VentusApp app, VentusData md) {
        Set explicitSelObjs = md.selection.getSelected(IMerlinObj.class);
        Delete.uiDelete(app, md, explicitSelObjs, true);
    }

    public static DelStatus uiDelete(VentusApp app, VentusData md, Collection<? extends IMerlinObj> explicitSelObjs, boolean confirmDel) {
        Pair<DelStatus, Runnable> result = Delete.startUiDelete(app, md, explicitSelObjs, confirmDel);
        if (result.v1 != DelStatus.SUCCESS) {
            return (DelStatus)((Object)result.v1);
        }
        ((Runnable)result.v2).run();
        return (DelStatus)((Object)result.v1);
    }

    /*
     * WARNING - void declaration
     */
    public static Pair<DelStatus, Runnable> startUiDelete(VentusApp app, VentusData md, Collection<? extends IMerlinObj> explicitSelObjs, boolean confirmDel) {
        List<PropReplacement> replacements;
        ArrayList<ISchematicComp> addObjs = new ArrayList<ISchematicComp>();
        LinkedIdentityHashSet<IMerlinObj> selObjs = new LinkedIdentityHashSet<IMerlinObj>((Collection<IMerlinObj>)explicitSelObjs);
        Delete.getOtherDeletes(md, explicitSelObjs, selObjs);
        Delete.flattenRoots(md, selObjs);
        try {
            Delete.removeNonDelObjs(md, selObjs);
        }
        catch (Exception e) {
            guiDialog.showInvalidEntryMessage(app.getActiveFrame(), e.getLocalizedMessage());
            return new Pair<DelStatus, Object>(DelStatus.DEL_FAILED, null);
        }
        Delete.calcAutoDeleteProxies(md, selObjs);
        Delete.calcAutoDeletes(md, selObjs);
        int selCount = selObjs.size();
        if (selCount == 0) {
            return new Pair<DelStatus, Runnable>(DelStatus.SUCCESS, () -> {});
        }
        for (Object e : selObjs) {
            selCount += md.hierarchy.getNumChildren(e);
        }
        int selGroupCount = 0;
        for (Object e : selObjs) {
            if (!(e instanceof Composite)) continue;
            --selCount;
            ++selGroupCount;
        }
        boolean undoable = Delete.isDelUndoable(md, selObjs);
        if (confirmDel || !undoable) {
            void var11_21;
            String string;
            String string2 = selGroupCount == 1 ? Intl.intl("1 group") : String.format(Intl.intl("%d groups"), selGroupCount);
            String string3 = string = selCount == 1 ? String.format(Intl.intl("Are you sure you want to remove 1 object (%s)?"), string2) : String.format(Intl.intl("Are you sure you want to remove %1$d objects (%2$s)?"), selCount, string2);
            if (!undoable) {
                String string4 = string + "<br>" + Intl.intl("<b>NOTE:</b> This operation cannot be undone.");
            }
            String string5 = "<html>" + (String)var11_21 + "</html>";
            int option = JOptionPane.showConfirmDialog(app.getActiveFrame(), string5, Intl.intl("Remove?"), 0, 3);
            if (option != 0) {
                return new Pair<DelStatus, Object>(DelStatus.NOT_DELETED, null);
            }
        }
        try {
            replacements = Delete.getReplacements(selObjs, app, md);
        }
        catch (CancelledException cancelledException) {
            return new Pair<DelStatus, Object>(DelStatus.CANCELLED, null);
        }
        if (!MerlinUtil.filter(selObjs, Elevator.class).isEmpty()) {
            int n = JOptionPane.showConfirmDialog(app.getActiveFrame(), Intl.intl("Would you like to restore the rooms used to create the elevators?"), Intl.intl("Restore Original Rooms?"), 1);
            if (n == 0) {
                for (Elevator elevator : MerlinUtil.filter(selObjs, Elevator.class)) {
                    Delete.convertElevatorDischargeComps(elevator, addObjs);
                }
            } else if (n != 1) {
                return new Pair<DelStatus, Object>(DelStatus.CANCELLED, null);
            }
        }
        ArrayList<? extends IMerlinObj> restoreSel = new ArrayList<IMerlinObj>(explicitSelObjs);
        Runnable deleteFunc = () -> {
            try (VentusData.WriteLock lock = md.lockWrite();){
                Undo.begin(Intl.intl("Delete"));
                if (!undoable) {
                    Undo.insertEntry_breakChain(md);
                }
                Delete.restoreSelection(md, restoreSel);
                for (PropReplacement repl : replacements) {
                    repl.perform(md);
                }
                Delete.deleteAll(md, selObjs);
                NewCompUtil.addSchematicComps(md, true, addObjs);
                Undo.end(md);
            }
        };
        return new Pair<DelStatus, Runnable>(DelStatus.SUCCESS, deleteFunc);
    }

    private static void calcAutoDeleteProxies(VentusData md, Set<IMerlinObj> selObjs) {
        Collection<ICompElement> flattenedObjs = MerlinUtil.flatten(selObjs, ICompElement.class);
        LinkedHashSet<Proxy<? extends ICompElement>> proxies = new LinkedHashSet<Proxy<? extends ICompElement>>();
        for (ICompElement obj : flattenedObjs) {
            Set<Proxy<? extends ICompElement>> objProxies = md.proxies.getProxies(obj);
            proxies.addAll(objProxies);
        }
        selObjs.addAll(proxies);
    }

    private static void convertElevatorDischargeComps(Elevator elevator, List<ISchematicComp> comps) {
        ElevatorRoom er = elevator.getDischargeRoom();
        comps.add(new SchematicRoom(er.getName(), er.getModel(), 0));
        for (ElevatorDoor ed : er.getElevatorDoors()) {
            comps.add(new SchematicDoor(ed.getName(), ed.getRoom1(), ed.getRoom2(), ed.getDoorGeom()));
        }
    }

    private static void getOtherDeletes(VentusData md, Collection<? extends IMerlinObj> explicitSelObjs, Set<IMerlinObj> selObjs) {
        for (IMerlinObj iMerlinObj : explicitSelObjs) {
            EntryPointFactory.get(iMerlinObj).getOtherDeleteObjs(md, selObjs, iMerlinObj);
        }
    }

    private static void flattenRoots(VentusData md, Set<IMerlinObj> selObjs) {
        for (IMerlinObj iMerlinObj : md.getChildren()) {
            if (!selObjs.contains(iMerlinObj)) continue;
            selObjs.remove(iMerlinObj);
            selObjs.addAll(iMerlinObj.getChildren());
        }
    }

    private static void removeNonDelObjs(VentusData md, Set<IMerlinObj> objs) throws Exception {
        Exception firstExp = null;
        ArrayList<IMerlinObj> nonDels = new ArrayList<IMerlinObj>();
        for (IMerlinObj obj : objs) {
            try {
                EntryPointFactory.get(obj).checkDelete(md, obj, objs);
            }
            catch (Exception e) {
                if (firstExp == null) {
                    firstExp = e;
                }
                nonDels.add(obj);
            }
        }
        objs.removeAll(nonDels);
        if (firstExp != null && objs.isEmpty()) {
            throw firstExp;
        }
    }

    private static void calcAutoDeletes(VentusData md, Set<IMerlinObj> objs) {
        Set<IMerlinObj> autoDeleteGroups = Delete.getAutoDeleteGroups(md, objs);
        while (!autoDeleteGroups.isEmpty()) {
            for (IMerlinObj group : autoDeleteGroups) {
                if (!objs.contains(group) && !objs.containsAll(group.getChildren())) continue;
                objs.removeAll(group.getChildren());
                objs.add(group);
            }
            autoDeleteGroups = Delete.getAutoDeleteGroups(md, autoDeleteGroups);
        }
    }

    private static Set<IMerlinObj> getAutoDeleteGroups(VentusData md, Set<IMerlinObj> objs) {
        LinkedIdentityHashSet<IMerlinObj> autoDeleteParents = new LinkedIdentityHashSet<IMerlinObj>();
        for (IMerlinObj obj : objs) {
            IMerlinObj parent = (IMerlinObj)md.hierarchy.getParent(obj);
            if (!EntryPointFactory.get(parent).isAutoDeleteGroup(md, parent)) continue;
            autoDeleteParents.add(parent);
        }
        return autoDeleteParents;
    }

    public static Set<IMerlinObj> collectObjs(VentusData md, Set<? extends IMerlinObj> explicit) {
        LinkedIdentityHashSet<IMerlinObj> allRelated = new LinkedIdentityHashSet<IMerlinObj>((Collection<IMerlinObj>)explicit);
        for (IMerlinObj iMerlinObj : explicit) {
            EntryPoint<IMerlinObj> ep = EntryPointFactory.get(iMerlinObj);
            if (ep == null) continue;
            ep.getOtherDeleteObjs(md, allRelated, iMerlinObj);
        }
        return allRelated;
    }

    private static boolean isDelUndoable(VentusData md, Collection<? extends IMerlinObj> objs) {
        return MerlinUtil.flatten(objs, Material.class).stream().noneMatch(mat -> md.materials.isPermanent((Material)mat));
    }

    private static DepSnapshot finalizeDelSet(VentusData md, Set<? extends IMerlinObj> explicitDel, Set<IMerlinObj> finalDelSet) {
        VentusDepSnapshot deps = new VentusDepSnapshot();
        deps.start(md, md.getChildren());
        ArrayDeque<? extends IMerlinObj> open = new ArrayDeque<IMerlinObj>(explicitDel);
        IdentityHashSet<? extends IMerlinObj> closed = new IdentityHashSet<IMerlinObj>(explicitDel);
        while (!open.isEmpty()) {
            IMerlinObj obj = (IMerlinObj)open.removeFirst();
            Set<Dependency> objDeps = deps.getDependents(obj);
            if (objDeps.stream().anyMatch(dep -> dep.link == DLink.REQUIRED)) continue;
            finalDelSet.add(obj);
            for (Dependency dep2 : objDeps) {
                if (dep2.link != DLink.STRONG) continue;
                Consumer<IMerlinObj> addObj = mobj -> {
                    if (closed.add(mobj)) {
                        open.addLast((IMerlinObj)mobj);
                    }
                };
                if (dep2.source instanceof IMerlinObj) {
                    addObj.accept((IMerlinObj)((Object)dep2.source));
                    continue;
                }
                for (IMerlinObj ancestor : deps.getAncestors(IMerlinObj.class, dep2.source)) {
                    addObj.accept(ancestor);
                }
            }
        }
        return deps;
    }

    public static void deleteAll(VentusData md, Set<? extends IMerlinObj> objs) {
        if (objs.isEmpty()) {
            return;
        }
        Delete.restoreSelection(md, objs);
        LinkedIdentityHashSet doors = new LinkedIdentityHashSet();
        for (IMerlinObj iMerlinObj : objs) {
            if (!(iMerlinObj instanceof SchematicRoom)) continue;
            Set<ISchematicConnector> connections = ((SchematicRoom)iMerlinObj).getDoors();
            for (ISchematicConnector iSchematicConnector : connections) {
                doors.add(iSchematicConnector);
            }
        }
        if (!doors.isEmpty()) {
            Undo.insertUndoEntry_restore(md, doors);
        }
        List<Floor> delWorkingGroups = Delete.getDeletingWorkingGroups(md, objs);
        for (Floor floor : delWorkingGroups) {
            SetWorkingGroup.setWorkingGroup(md, floor, floor);
        }
        LinkedIdentityHashSet<IMerlinObj> linkedIdentityHashSet = new LinkedIdentityHashSet<IMerlinObj>();
        DepSnapshot deps = Delete.finalizeDelSet(md, objs, linkedIdentityHashSet);
        objs = linkedIdentityHashSet;
        for (IMerlinObj iMerlinObj : objs) {
            Set<Dependency> objDeps = deps.getDependents(iMerlinObj);
            for (Dependency dep : objDeps) {
                if (dep.link != DLink.WEAK) continue;
                if (dep.source instanceof IRestorable) {
                    Undo.insertUndoEntry_restore(md, (IRestorable)((Object)dep.source));
                } else {
                    for (IRestorable restorable : deps.getAncestors(IRestorable.class, dep.source)) {
                        Undo.insertUndoEntry_restore(md, restorable);
                    }
                }
                dep.source.replaceDependency(md, iMerlinObj, null);
            }
        }
        for (IMerlinObj iMerlinObj : objs) {
            EntryPoint<IMerlinObj> ep = EntryPointFactory.get(iMerlinObj);
            if (ep == null) continue;
            if (ep.isIndexed(md, iMerlinObj)) {
                Undo.insertUndoEntry_insert(md, iMerlinObj);
            } else {
                Undo.insertUndoEntry_add(md, iMerlinObj);
            }
            ep.delete(md, iMerlinObj);
        }
    }

    private static void restoreSelection(VentusData md, Collection<? extends IMerlinObj> objs) {
        Undo.insertUndoEntry_restoreSelection(md);
        IFilteredCollection<IMerlinObj> selectedObjs = theUtil.filter(objs, o -> md.selection.isSelected(o));
        for (IMerlinObj obj : selectedObjs) {
            if (obj instanceof IRestorable) {
                Undo.insertUndoEntry_restore(md, (IRestorable)((Object)obj));
            }
            md.selection.deselect(obj);
        }
    }

    private static List<Floor> getDeletingWorkingGroups(VentusData md, Set<? extends IMerlinObj> objs) {
        ArrayList<Floor> delActiveGroups = new ArrayList<Floor>();
        for (Floor floor : md.floors.getMembers(Floor.class)) {
            if (Delete.selSetContains(md, objs, floor) || !Delete.selSetContains(md, objs, floor.getWorkingGeomGroup())) continue;
            delActiveGroups.add(floor);
        }
        return delActiveGroups;
    }

    private static boolean selSetContains(VentusData md, Set<? extends IMerlinObj> selSet, Object o) {
        while (o != null) {
            if (selSet.contains(o)) {
                return true;
            }
            o = md.hierarchy.getParent(o);
        }
        return false;
    }

    private static int countTypes(Collection<?> objs, Class<?> type) {
        int count = 0;
        for (Object obj : objs) {
            if (!type.isInstance(obj)) continue;
            ++count;
        }
        return count;
    }

    private static boolean isSelected(VentusData md, Set<IMerlinObj> selObjs, Object o) {
        if (o == null) {
            return false;
        }
        return selObjs.contains(o) || Delete.isSelected(md, selObjs, md.hierarchy.getParent(o));
    }

    public static List<PropReplacement> getReplacements(Set<IMerlinObj> selObjs, VentusApp app, VentusData md) throws CancelledException {
        ArrayList<PropReplacement> replacements = new ArrayList<PropReplacement>();
        Predicate<Object> isSelected = o -> Delete.isSelected(md, selObjs, o);
        Delete.getMaterialRepl(isSelected, app, md, replacements);
        for (DeleteHandler handler : app.getComponents(DeleteHandler.class)) {
            List<PropReplacement> reps = handler.getDeleteReplacments(isSelected, app, md);
            replacements.addAll(reps);
        }
        return replacements;
    }

    private static void getMaterialRepl(Predicate<? super IMerlinObj> isSelected, VentusApp app, VentusData md, List<PropReplacement> replacements) throws CancelledException {
        LinkedIdentityHashSet referencing = new LinkedIdentityHashSet();
        IdentityHashSet referenced = new IdentityHashSet();
        Dependencies.getObjReferences(md, Material.class, isSelected, (src, target) -> {
            referencing.add(src);
            referenced.add(target);
        });
        referencing.removeIf(isSelected);
        if (referencing.isEmpty()) {
            return;
        }
        Predicate<? super IMerlinObj> exclude = isSelected.negate();
        MerlinComboBox replacementCB = new MerlinComboBox(md, Material.class, exclude, (IMerlinObj[])new Material[]{null});
        replacementCB.setNullName(Intl.intl("[None]"));
        Material replacement = (Material)Delete.promptUserForReplacement(app, replacementCB, referenced);
        ArrayList<ICompElement> conflictingObjs = new ArrayList<ICompElement>(theUtil.filter(referencing, ICompElement.class, obj -> obj.isSupportedLocally(VentusData.MATERIAL)));
        replacements.add(Delete.getCompressibleArrayReplacement(VentusData.MATERIAL, conflictingObjs, referenced, replacement));
    }

    public static <T extends NamedMerlinObj> T promptUserForReplacement(VentusApp app, MerlinComboBox<T> replacementCB, Set<T> toDelete) throws CancelledException {
        guiDialog dlg = new guiDialog((Window)app.getActiveFrame(), Intl.intl("Select Replacement"), 9);
        dlg.getDialogPane().setLayout(new GridBagLayout());
        guiLabel probDesc = new guiLabel(toDelete.size() == 1 ? String.format(Intl.intl("Selected object, %s, is in use."), ((NamedMerlinObj)toDelete.iterator().next()).getName()) : String.format(Intl.intl("%1$d selected objects are in use."), toDelete.size()));
        guiLabel exitLbl = new guiLabel(Intl.intl("Replace with:"));
        GridBagUtil.add(dlg.getDialogPane(), probDesc, 0, 0, 2, 1, 12, 12, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(dlg.getDialogPane(), exitLbl, 0, 1, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(dlg.getDialogPane(), replacementCB, 1, 1, 1, 1, 6, 6, 0, 0, 2, 0.0, 0.0, 17);
        if (dlg.doModal() == 1) {
            return (T)((NamedMerlinObj)replacementCB.getSelectedItem());
        }
        throw CancelledException.INSTANCE;
    }

    public static <ObjT extends ICompElement, InnerT> PropReplacement getCompressibleArrayReplacement(Object prop, Collection<ObjT> referencing, Set<? extends InnerT> referenced, InnerT replacement) {
        ArrayList<Object[]> replacements = new ArrayList<Object[]>(referencing.size());
        for (ICompElement referencingObj : referencing) {
            Object[] oldVals = (Object[])referencingObj.getProperty(prop);
            Object[] newVals = Arrays.copyOf(oldVals, oldVals.length);
            Arrays.asList(newVals).replaceAll(mat -> referenced.contains(mat) ? replacement : mat);
            if (newVals.length > 1 && MerlinUtil.isUniform(newVals)) {
                newVals = Arrays.copyOf(newVals, 1);
            }
            replacements.add(newVals);
        }
        return new PropReplacement(prop, referencing, replacements);
    }

    private static <ObjT extends ICompElement, InnerT> PropReplacement getSetReplacement(Object prop, Collection<ObjT> referencing, Collection<? extends InnerT> referenced, InnerT replacement) {
        ArrayList replacements = new ArrayList(referencing.size());
        HashMap cache = new HashMap();
        for (ICompElement referencingObj : referencing) {
            LinkedIdentityHashSet existing;
            LinkedIdentityHashSet newVals = new LinkedIdentityHashSet((Collection)referencingObj.getProperty(prop));
            newVals.removeAll(referenced);
            if (replacement != null) {
                newVals.add(replacement);
            }
            if ((existing = (LinkedIdentityHashSet)cache.putIfAbsent(newVals, newVals)) == null) {
                existing = newVals;
            }
            replacements.add(existing);
        }
        return new PropReplacement(prop, referencing, replacements);
    }

    public static <ObjT extends ICompElement, InnerT> PropReplacement getSetReplacement(IPropertySet.Prop<Set<InnerT>> prop, Collection<ObjT> referencing, Collection<? extends InnerT> referenced, InnerT replacement) {
        return Delete.getSetReplacement(prop, referencing, referenced, replacement);
    }

    public static <SrcT extends ICompElement, PropT> PropReplacement getReplacement(IPropertySet.Prop<PropT> prop, Collection<SrcT> referencing, PropT replacement) {
        Set<Object> refSet = referencing instanceof Set ? (Set<Object>)referencing : new LinkedIdentityHashSet<SrcT>(referencing);
        return replacement == null ? new PropRemove(prop, refSet) : new PropReplacement(prop, (Collection<? extends ICompElement>)refSet, replacement);
    }

    static {
        UI_HOOK.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        UI_HOOK.putValue("AcceleratorKey1", KeyStroke.getKeyStroke(8, 0));
    }

    public static enum DelStatus {
        SUCCESS,
        NOT_DELETED,
        DEL_FAILED,
        CANCELLED;

    }

    public static class PropReplacement {
        public final Object propKey;
        public final Collection<? extends ICompElement> objs;
        public final List<?> replacements;

        public PropReplacement(Object propKey, Collection<? extends ICompElement> objs, Object replacement) {
            this(propKey, objs, PropReplacement.fill(replacement, objs.size()));
        }

        public PropReplacement(Object propKey, Collection<? extends ICompElement> objs, List<?> replacements) {
            this.propKey = propKey;
            this.objs = objs;
            this.replacements = replacements;
        }

        private static List<?> fill(Object obj, int count) {
            ArrayList<Object> list = new ArrayList<Object>(count);
            for (int m = 0; m < count; ++m) {
                list.add(obj);
            }
            return list;
        }

        public void perform(VentusData md) {
            Undo.insertUndoEntry_propRestore(md, this.objs, this.propKey);
            int ix = 0;
            for (ICompElement iCompElement : this.objs) {
                iCompElement.setProperty(this.propKey, this.replacements.get(ix++));
            }
        }
    }

    public static class PropRemove<ObjT extends ICompElement, PropT>
    extends PropReplacement {
        private final Set<ObjT> objs;

        public PropRemove(IPropertySet.Prop<PropT> prop, Set<ObjT> objs) {
            super((Object)prop, (Collection<? extends ICompElement>)objs, (Object)null);
            this.objs = objs;
        }

        @Override
        public void perform(VentusData md) {
            super.perform(md);
            Delete.deleteAll(md, this.objs);
        }
    }

    public static class DistributionUpdatePropReplacement
    extends PropReplacement {
        public DistributionUpdatePropReplacement(Collection<? extends ICompElement> objsToUpdate, List<IUrn<?>> replacements, Object property) {
            super(property, objsToUpdate, replacements);
        }

        public static <T> List<IUrn<?>> getReplacements(Set<T> conflicts, T replacementObj, Collection<? extends ICompElement> objsToUpdate, Object property) {
            ArrayList replacements = new ArrayList();
            for (ICompElement iCompElement : objsToUpdate) {
                Map originalWeights = ((IUrn)iCompElement.getProperty(property)).getWeights();
                HashMap newWeights = new HashMap();
                Set originalObjs = originalWeights.keySet();
                for (Object obj : originalObjs) {
                    DistributionUpdatePropReplacement.addObj(obj, replacementObj, newWeights, conflicts.contains(obj), originalWeights.get(obj));
                }
                replacements.add(UrnUtil.newUrn(newWeights));
            }
            return replacements;
        }

        private static <T> void addObj(T obj, T replacementObj, Map<T, Double> newWeights, boolean replace, Double weight) {
            T newObj;
            T t = newObj = replace ? replacementObj : obj;
            if (!newWeights.containsKey(newObj)) {
                newWeights.put(newObj, weight);
            } else {
                double oldWeight = newWeights.get(newObj);
                newWeights.put(newObj, oldWeight + weight);
            }
        }
    }
}

