/*
 * Decompiled with CFR 0.152.
 */
package ventus.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import thunderheadeng.util.theUtil;
import ventus.actions.Undo;
import ventus.data.Composite;
import ventus.data.ICompElement;
import ventus.data.VentusData;

public class CompElementActions {
    public static void setProperty(Object prop, Collection<? extends ICompElement> objs, Object newVal) {
        VentusData md = Composite.getDomain(objs);
        new DefProp<ICompElement, Object>(prop).set(md, objs, newVal);
    }

    public static List<ICompElement> flattenToLocallyDefined(Object prop, Collection<? extends ICompElement> objs) {
        ArrayList<ICompElement> modObjs = new ArrayList<ICompElement>();
        CompElementActions.flattenToLocallyDefined(prop, objs, modObjs);
        return modObjs;
    }

    private static void flattenToLocallyDefined(Object prop, Collection<? extends ICompElement> objs, List<ICompElement> result) {
        for (ICompElement iCompElement : objs) {
            if (iCompElement.getPropTypes(1).contains(prop)) {
                result.add(iCompElement);
                continue;
            }
            CompElementActions.flattenToLocallyDefined(prop, theUtil.filter(iCompElement.getChildren(), ICompElement.class), result);
        }
    }

    public static class DefProp<ObjT extends ICompElement, PropT>
    implements IObjectProp<ObjT, PropT> {
        private final Object d_prop;

        public DefProp(Object prop) {
            this.d_prop = prop;
        }

        public Object getProp() {
            return this.d_prop;
        }

        protected void saveState(VentusData md, Object prop, Collection<? extends ObjT> objs, PropT newVal) {
            List<ICompElement> modObjs = CompElementActions.flattenToLocallyDefined(this.d_prop, objs);
            Undo.insertUndoEntry_propRestore(md, modObjs, this.d_prop);
        }

        protected void set(VentusData md, Object prop, ObjT obj, PropT newVal) {
            obj.setProperty(this.d_prop, newVal);
        }

        protected Object get(VentusData md, Object prop, ObjT obj) {
            return obj.getProperty(this.d_prop);
        }

        protected boolean equal(VentusData md, PropT obj1, PropT obj2) {
            return Objects.equals(obj1, obj2);
        }

        @Override
        public void set(VentusData md, Collection<? extends ObjT> objs, PropT newVal) {
            this.saveState(md, this.d_prop, objs, newVal);
            for (ICompElement obj : objs) {
                this.set(md, this.d_prop, obj, newVal);
            }
        }

        @Override
        public Object get(VentusData md, Collection<? extends ObjT> objs) {
            if (objs.isEmpty()) {
                return ICompElement.NOT_SUPPORTED;
            }
            Object val = ICompElement.NOT_SUPPORTED;
            for (ICompElement obj : objs) {
                Object val2 = this.get(md, this.d_prop, obj);
                if (val2 == ICompElement.NON_UNIFORM) {
                    return ICompElement.NON_UNIFORM;
                }
                if (val2 == ICompElement.NOT_SUPPORTED) continue;
                if (val == ICompElement.NOT_SUPPORTED) {
                    val = val2;
                    continue;
                }
                if (this.equal(md, val, val2)) continue;
                return ICompElement.NON_UNIFORM;
            }
            return val;
        }
    }

    public static interface IObjectProp<ObjT, PropT> {
        public void set(VentusData var1, Collection<? extends ObjT> var2, PropT var3);

        public Object get(VentusData var1, Collection<? extends ObjT> var2);
    }
}

