/*
 * Decompiled with CFR 0.152.
 */
package ventus;

import java.awt.Font;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;
import ventus.EntryPoint;
import ventus.EntryPointHelper;
import ventus.Intl;
import ventus.actions.RenameAction;
import ventus.data.Composite;
import ventus.data.GeomComposite;
import ventus.data.ICompElement;
import ventus.data.IMerlinObj;
import ventus.data.INamed;
import ventus.data.ImportedGeom;
import ventus.data.Proxy;
import ventus.data.SequentialNameGen;
import ventus.data.VentusData;
import ventus.data.camera.Camera;
import ventus.data.camera.CameraList;
import ventus.data.camera.CameraTour;
import ventus.data.camera.ICameraObj;
import ventus.data.image.RasterImage;
import ventus.data.material.Material;
import ventus.data.material.MaterialDB;
import ventus.data.schematics.Floor;
import ventus.data.schematics.FloorComposite;
import ventus.data.schematics.SimError;
import ventus.data.schematics.elevators.Elevator;
import ventus.data.schematics.elevators.ElevatorDoor;
import ventus.data.schematics.elevators.ElevatorGroup;
import ventus.data.schematics.elevators.ElevatorRoom;
import ventus.data.schematics.elevators.ElevatorUtil;
import ventus.data.schematics.elevators.IElevatorComp;
import ventus.data.schematics.geom.ISchematicComp;
import ventus.data.schematics.geom.ISchematicConnector;
import ventus.data.schematics.geom.ISchematicRoom;
import ventus.data.schematics.geom.SchematicCorridor;
import ventus.data.schematics.geom.SchematicDoor;
import ventus.data.schematics.geom.SchematicRoom;
import ventus.data.schematics.geom.SchematicStair;
import ventus.gui.guiUtil;
import ventus.mv.ModelView;
import ventus.mv.displays.IMerlinDispMgr;
import ventus.treeview.TVEntryPoint;

public class EntryPointFactory {
    private static final Map<Class<?>, EntryPoint> s_entryPoints = new LinkedHashMap();
    private static final Map<Pair<Class<?>, FuncType>, EntryPoint.Func<?>> s_funcs = new LinkedHashMap();
    private static final Map<FuncType, EntryPoint.Func> s_defaults = new HashMap<FuncType, EntryPoint.Func>();
    private static final Map<IMerlinObj, List<SimError>> doubleDeckElevatorWarnings = new IdentityHashMap<IMerlinObj, List<SimError>>();
    public static final Icon mgrIcon = guiUtil.loadMerlinIcon("manager8.png");
    public static final Icon materialsIcon = guiUtil.loadIcon("ventus/icons/surfacedb16.gif", 16);
    public static final Icon cameraListIcon = guiUtil.loadMerlinIcon("cameras16.png", 16);
    public static final Icon cameraIcon = guiUtil.loadMerlinIcon("camera16.png", 16);
    public static final Icon cameraTourIcon = guiUtil.loadMerlinIcon("camera_tour16.png", 16);
    public static final Icon floorIcon = guiUtil.loadMerlinIcon("floor16.png", 16);
    public static final Icon stairsIcon = guiUtil.loadMerlinIcon("stairs216.png", 16);
    public static final Icon exitIcon = guiUtil.loadMerlinIcon("exit16.png", 16);
    public static final Icon doorIcon = guiUtil.loadMerlinIcon("door216.png", 16);
    public static final Icon rampIcon = guiUtil.loadMerlinIcon("ramp16.png", 16);
    public static final Icon roomIcon = guiUtil.loadMerlinIcon("openrect16.png", 16);
    public static final Icon resumePriorIcon = guiUtil.loadMerlinIcon("return16.png", 16);
    public static final Icon importedGeometry2DIcon = guiUtil.loadMerlinIcon("2Dgeometry16.png", 16);
    public static final Icon importedGeometry3DIcon = guiUtil.loadMerlinIcon("block16_2.gif", 16);
    public static final Icon importedGeometryGroupIcon = guiUtil.loadMerlinIcon("composite16.png", 16);
    public static final Icon floorGroupIcon = guiUtil.loadMerlinIcon("mesh16.png", 16);
    public static final Icon backgroundImageIcon = guiUtil.loadMerlinIcon("backgroundImage16.gif", 16);
    public static final Icon blankIcon = null;
    public static final Icon waitIcon;
    public static final Icon waitUntilEndIcon;
    public static final Icon elevatorIcon;
    private static final Font s_plain;
    private static final Font s_bold;
    private static final Font s_italic;
    private static final Font s_italicBold;

    public static Icon getManagerIcon(Icon itemIcon) {
        return itemIcon == null ? null : new DecoratedIcon(itemIcon, mgrIcon, 3);
    }

    private static void registerDefault(FuncType funcType, EntryPoint.Func<?> func) {
        s_defaults.put(funcType, func);
    }

    public static void register(EntryPointHelper helper) {
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_GetErrors, helper.getErrors);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_GetRuntimeErrors, helper.getRuntimeErrors);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_GetName, helper.getName);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_SetName, helper.setName);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_CanRename, helper.canRename);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_GetIcon, helper.getIcon);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_GetType, helper.getType);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_GetBaseFont, helper.getBaseFont);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_IsVisible, helper.isVisible);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_IsEnabled, helper.isVisible);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_GetForcedAutoexpand, helper.getForcedAutoexpand);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_IsLeaf, helper.isLeaf);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_GetChildren, helper.getChildren);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.TV_GetParent, helper.getParent);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.CheckDelete, helper.checkDelete);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.GetOtherDeleteObjs, helper.getOtherDeleteObjs);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.GetConflict, helper.getConflict);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.Delete, helper.delete);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.IsAutoDeleteGroup, helper.isAutoDeleteGroup);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.IsVisible, helper.isVisible);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.SetVisible, helper.setVisible);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.GetCompositeRoot, helper.getRootComposite);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.GetNameGenerator, helper.getNameGenerator);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.GetUniqueNameGroup, helper.getNameGroup);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.GetNameFormatRules, helper.getNameFormat);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.IsIndexed, helper.isIndexed);
        EntryPointFactory.registerIfPresent(helper.type, FuncType.IsMovable, helper.isMovable);
    }

    private static <T> void registerIfPresent(Class<T> type, FuncType funcType, EntryPoint.Func<?> func) {
        if (func != null) {
            EntryPointFactory.register(type, funcType, func);
        }
    }

    public static <T> void register(Class<T> type, FuncType funcType, EntryPoint.Func<?> func) {
        s_funcs.put(new Pair<Class<T>, FuncType>(type, funcType), func);
    }

    public static <T, ReturnT> void register(Class<T> type, FuncType funcType, EntryPoint.Getter<T, ReturnT> getter) {
        EntryPointFactory.register(type, funcType, getter);
    }

    public static <T, ReturnT, ArgT> void register(Class<T> type, FuncType funcType, EntryPoint.Action<T, ReturnT, ArgT> action) {
        EntryPointFactory.register(type, funcType, action);
    }

    public static <T, ArgT> void register(Class<T> type, FuncType funcType, EntryPoint.Setter<T, ArgT> setter) {
        EntryPointFactory.register(type, funcType, setter);
    }

    public static void registerIcon(Class<?> type, Icon icon) {
        EntryPointFactory.register(type, FuncType.TV_GetIcon, new ConstantAsyncGetter(icon));
    }

    private static void registerType(Class<?> type, String typeString) {
        EntryPointFactory.register(type, FuncType.TV_GetType, new ConstantGetter(typeString));
    }

    public static <T> EntryPoint<T> get(T obj) {
        return EntryPointFactory.get(obj.getClass(), obj);
    }

    public static synchronized <T> EntryPoint<T> get(Class clazz) {
        return EntryPointFactory.get(clazz, null);
    }

    private static synchronized <T> EntryPoint<T> get(Class clazz, T obj) {
        EntryPoint ep = s_entryPoints.get(clazz);
        if (ep != null) {
            return ep;
        }
        TVEntryPoint tvep = new TVEntryPoint((EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetErrors, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetRuntimeErrors, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetName, obj), (EntryPoint.Setter)EntryPointFactory.findFunc(clazz, FuncType.TV_SetName, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_CanRename, obj), (EntryPoint.AsyncGetter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetIcon, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetBaseFont, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_IsVisible, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_IsEnabled, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetForcedAutoexpand, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_IsLeaf, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetChildren, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetParent, obj));
        ep = new EntryPoint(clazz, tvep, (EntryPoint.Action)EntryPointFactory.findFunc(clazz, FuncType.CheckDelete, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetOtherDeleteObjs, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetConflict, obj), (EntryPoint.Action)EntryPointFactory.findFunc(clazz, FuncType.Delete, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.IsAutoDeleteGroup, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.IsVisible, obj), (EntryPoint.Setter)EntryPointFactory.findFunc(clazz, FuncType.SetVisible, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetCompositeRoot, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetNameGenerator, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.IsIndexed, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.IsMovable, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.TV_GetType, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetUniqueNameGroup, obj), (EntryPoint.Getter)EntryPointFactory.findFunc(clazz, FuncType.GetNameFormatRules, obj));
        s_entryPoints.put(clazz, ep);
        return ep;
    }

    private static Collection<SimError> lazyAdd(Collection<SimError> coll, SimError err) {
        if (coll.isEmpty()) {
            coll = new ArrayDeque<SimError>();
        }
        coll.add(err);
        return coll;
    }

    private static <T extends IMerlinObj> EntryPoint.Func<T> findFunc(Class<?> clazz, FuncType funcType, Object obj) {
        EntryPoint.Func func = EntryPointFactory.findFuncHelper(clazz, funcType);
        return func != null ? func : s_defaults.get((Object)funcType);
    }

    private static <T extends IMerlinObj> EntryPoint.Func<T> findFuncHelper(Class<?> clazz, FuncType funcType) {
        if (clazz == null) {
            return null;
        }
        EntryPoint.Func<Object> func = s_funcs.get(new Pair(clazz, funcType));
        if (func != null) {
            return func;
        }
        func = EntryPointFactory.findFuncHelper(clazz.getSuperclass(), funcType);
        if (func != null) {
            return func;
        }
        for (Class<?> ifaceClass : clazz.getInterfaces()) {
            func = EntryPointFactory.findFuncHelper(ifaceClass, funcType);
            if (func == null) continue;
            return func;
        }
        return null;
    }

    public static synchronized Collection<EntryPoint> getAll() {
        return s_entryPoints.values();
    }

    public static <T> EntryPoint.Getter<T, T> getStandardConflictGetter(final Class<T> clazz) {
        return new EntryPoint.Getter<T, T>(){

            @Override
            public T get(VentusData md, T comparable) {
                Collection members = EntryPointFactory.get(comparable).getRootComposite(md, comparable).flatten(clazz);
                for (Object conflict : members) {
                    if (!theUtil.equal(comparable, conflict)) continue;
                    return conflict;
                }
                return null;
            }
        };
    }

    public static <T> boolean deletingAllOfType(VentusData vd, Set<? extends IMerlinObj> delObjs, Class<T> type, Composite<? super T> root) {
        return root.flatten(type).stream().allMatch(obj -> {
            Object mobj = obj;
            while (mobj != null) {
                if (delObjs.contains(mobj)) {
                    return true;
                }
                mobj = vd.hierarchy.getParent(mobj);
            }
            return false;
        });
    }

    static void registerCameraTour() {
        EntryPointFactory.registerIcon(CameraTour.class, cameraTourIcon);
    }

    public static <T> EntryPoint.Getter<T, EntryPoint.INameGroup> nameGroup(Function<VentusData, ? extends Collection<?>> getter) {
        EntryPoint.INameGroup group = getter::apply;
        return new ConstantGetter(group);
    }

    static {
        waitUntilEndIcon = waitIcon = guiUtil.loadMerlinIcon("clock16.png", 16);
        elevatorIcon = guiUtil.loadMerlinIcon("elevator16.png", 16);
        s_plain = new Font("Sans Serif", 0, 11);
        s_bold = new Font("Sans Serif", 1, 11);
        s_italic = new Font("Sans Serif", 2, 11);
        s_italicBold = s_italic.deriveFont(1);
        EntryPointFactory.registerDefault(FuncType.CheckDelete, new NullAction(null));
        EntryPointFactory.registerDefault(FuncType.GetOtherDeleteObjs, new ConstantGetter(Collections.EMPTY_LIST));
        EntryPointFactory.registerDefault(FuncType.GetConflict, new ConstantGetter(null));
        EntryPointFactory.registerDefault(FuncType.Delete, new NullAction(false));
        EntryPointFactory.registerDefault(FuncType.IsAutoDeleteGroup, new ConstantGetter(false));
        EntryPointFactory.registerDefault(FuncType.IsVisible, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.SetVisible, new NullSetter());
        EntryPointFactory.registerDefault(FuncType.GetCompositeRoot, new ConstantGetter(null));
        EntryPointFactory.registerDefault(FuncType.GetNameGenerator, new ConstantGetter(null));
        EntryPointFactory.registerDefault(FuncType.IsIndexed, new ConstantGetter(false));
        EntryPointFactory.registerDefault(FuncType.IsMovable, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.GetUniqueNameGroup, new ConstantGetter(null));
        EntryPointFactory.registerDefault(FuncType.GetNameFormatRules, new ConstantGetter(Predicates.alwaysTrue()));
        EntryPointFactory.registerDefault(FuncType.TV_GetErrors, new ConstantGetter(Collections.EMPTY_LIST));
        EntryPointFactory.registerDefault(FuncType.TV_GetName, new ConstantGetter(""));
        EntryPointFactory.registerDefault(FuncType.TV_SetName, new NullSetter());
        EntryPointFactory.registerDefault(FuncType.TV_CanRename, new ConstantGetter(false));
        EntryPointFactory.registerDefault(FuncType.TV_GetIcon, new ConstantAsyncGetter(null));
        EntryPointFactory.registerDefault(FuncType.TV_GetType, new ConstantGetter(""));
        EntryPointFactory.registerDefault(FuncType.TV_GetBaseFont, new ConstantGetter(s_plain));
        EntryPointFactory.registerDefault(FuncType.TV_IsVisible, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.TV_IsEnabled, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.TV_GetForcedAutoexpand, new ConstantGetter(false));
        EntryPointFactory.registerDefault(FuncType.TV_IsLeaf, new ConstantGetter(true));
        EntryPointFactory.registerDefault(FuncType.TV_GetChildren, new ConstantGetter(Collections.EMPTY_LIST));
        EntryPointFactory.registerDefault(FuncType.TV_GetParent, new ConstantGetter(null));
        EntryPointFactory.registerDefault(FuncType.TV_GetRuntimeErrors, new ConstantGetter(Collections.EMPTY_LIST));
        EntryPointFactory.register(VentusData.class, FuncType.TV_GetErrors, (VentusData md, T obj) -> {
            ArrayList<SimError> errors = new ArrayList<SimError>();
            for (IMerlinObj iMerlinObj : md.getChildren()) {
                errors.addAll(EntryPointFactory.get(iMerlinObj).tvEntryPoint.getErrors(md, iMerlinObj));
            }
            return errors;
        });
        EntryPointFactory.register(VentusData.class, FuncType.TV_GetChildren, (VentusData md, T obj) -> obj.getChildren().stream().filter(child -> child != obj.materials).collect(Collectors.toList()));
        EntryPointFactory.register(INamed.class, FuncType.TV_GetName, new EntryPoint.Getter<INamed, String>(){

            @Override
            public String get(VentusData md, INamed obj) {
                return obj.getName();
            }
        });
        EntryPointFactory.register(INamed.class, FuncType.TV_SetName, new EntryPoint.Setter<INamed, String>(){

            @Override
            public void set(VentusData md, INamed obj, String arg) {
                RenameAction.rename(md, null, Arrays.asList(obj), arg);
            }
        });
        EntryPointFactory.register(INamed.class, FuncType.TV_CanRename, new EntryPoint.Getter<INamed, Boolean>(){

            @Override
            public Boolean get(VentusData md, INamed obj) {
                return obj.isSetNameSupported();
            }
        });
        EntryPointFactory.register(IMerlinObj.class, FuncType.TV_GetChildren, (VentusData md, T obj) -> obj.getChildren());
        EntryPointFactory.register(IMerlinObj.class, FuncType.TV_GetParent, (VentusData md, T obj) -> md.hierarchy.getParent(obj));
        EntryPointFactory.register(IMerlinObj.class, FuncType.TV_IsLeaf, (VentusData md, T obj) -> obj.getChildren().isEmpty());
        EntryPointFactory.register(ICompElement.class, FuncType.GetCompositeRoot, (VentusData md, T obj) -> md.floors);
        EntryPointFactory.register(ICompElement.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("Geom", 2)));
        EntryPointFactory.register(ICompElement.class, FuncType.Delete, new EntryPoint.Action<ICompElement, Boolean, Object>(){

            @Override
            public Boolean perform(VentusData md, ICompElement obj, Object arg) {
                Object parentObj = md.hierarchy.getParent(obj);
                if (!(parentObj instanceof Composite)) {
                    return false;
                }
                Composite parent = (Composite)parentObj;
                return parent.remove(obj);
            }
        });
        EntryPointFactory.register(ICompElement.class, FuncType.IsVisible, new EntryPoint.Getter<ICompElement, Boolean>(){

            @Override
            public Boolean get(VentusData md, ICompElement obj) {
                Object value = obj.getProperty(VentusData.VISIBILITY);
                boolean basevis = value instanceof Boolean ? (Boolean)value : true;
                return basevis && !md.displayFilter.filter(obj);
            }
        });
        EntryPointFactory.register(ICompElement.class, FuncType.TV_IsEnabled, new EntryPoint.Getter<ICompElement, Boolean>(){

            @Override
            public Boolean get(VentusData md, ICompElement obj) {
                Object val = obj.getProperty(VentusData.ENABLED);
                return val instanceof Boolean ? (Boolean)val : true;
            }
        });
        EntryPointFactory.register(ICompElement.class, FuncType.SetVisible, new EntryPoint.Setter<ICompElement, Boolean>(){

            @Override
            public void set(VentusData md, ICompElement obj, Boolean arg) {
                obj.setProperty(VentusData.VISIBILITY, arg);
                if (!arg.booleanValue()) {
                    md.selection.deselect(obj);
                }
            }
        });
        EntryPointFactory.register(ICompElement.class, FuncType.TV_IsVisible, new EntryPoint.Getter<ICompElement, Boolean>(){

            @Override
            public Boolean get(VentusData md, ICompElement obj) {
                Object value = obj.getProperty(VentusData.VISIBILITY);
                return value instanceof Boolean ? (Boolean)value : true;
            }
        });
        EntryPointFactory.register(Composite.class, FuncType.GetOtherDeleteObjs, new EntryPoint.Getter<Composite<?>, Collection<? extends IMerlinObj>>(){

            @Override
            public Collection<? extends IMerlinObj> get(VentusData md, Composite<?> obj) {
                LinkedIdentityHashSet<IMerlinObj> otherObjs = new LinkedIdentityHashSet<IMerlinObj>();
                for (IMerlinObj child : obj.getChildren()) {
                    EntryPoint<IMerlinObj> ep = EntryPointFactory.get(child);
                    ep.getOtherDeleteObjs(md, otherObjs, child);
                }
                return otherObjs;
            }
        });
        EntryPointFactory.register(Composite.class, FuncType.CheckDelete, new EntryPoint.Action<Composite<?>, Exception, Set<? extends IMerlinObj>>(){

            @Override
            public Exception perform(VentusData md, Composite<?> obj, Set<? extends IMerlinObj> delObjs) {
                for (IMerlinObj child : obj.getChildren()) {
                    EntryPoint<IMerlinObj> ep = EntryPointFactory.get(child);
                    try {
                        ep.checkDelete(md, child, delObjs);
                    }
                    catch (Exception e) {
                        return e;
                    }
                }
                return null;
            }
        });
        EntryPointFactory.register(Composite.class, FuncType.TV_GetErrors, new EntryPoint.Getter<Composite<?>, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(VentusData md, Composite<?> obj) {
                int moderateErrors = 0;
                int criticalErrors = 0;
                ArrayList<? extends IMerlinObj> moderateObjs = new ArrayList<IMerlinObj>();
                ArrayList<? extends IMerlinObj> criticalObjs = new ArrayList<IMerlinObj>();
                SimError.Type type = SimError.Type.RESULTS;
                for (ICompElement eobj : obj.getMembers(ICompElement.class)) {
                    for (SimError se : EntryPointFactory.get(eobj).tvEntryPoint.getErrors(md, eobj)) {
                        int numErrors;
                        if (se.type.equals((Object)SimError.Type.DATA)) {
                            type = SimError.Type.DATA;
                        }
                        int n = numErrors = se instanceof CompositeSimError ? ((CompositeSimError)se).errorCount : 1;
                        if (se.level == SimError.Level.CRITICAL) {
                            criticalErrors += numErrors;
                            criticalObjs.addAll(se.causeObjs);
                            continue;
                        }
                        moderateErrors += numErrors;
                        moderateObjs.addAll(se.causeObjs);
                    }
                }
                if (moderateErrors > 0 || criticalErrors > 0) {
                    ArrayList<CompositeSimError> errors = new ArrayList<CompositeSimError>(2);
                    if (moderateErrors > 0) {
                        errors.add(new CompositeSimError(SimError.Level.MODERATE, moderateErrors, moderateObjs, type));
                    }
                    if (criticalErrors > 0) {
                        errors.add(new CompositeSimError(SimError.Level.CRITICAL, criticalErrors, criticalObjs, type));
                    }
                    return errors;
                }
                return Collections.EMPTY_LIST;
            }
        });
        EntryPointFactory.register(Composite.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(GeomComposite.class, FuncType.TV_GetBaseFont, new EntryPoint.Getter<GeomComposite<?>, Font>(){

            @Override
            public Font get(VentusData md, GeomComposite<?> obj) {
                if (md.floors.getActive().getWorkingGeomGroup() == obj) {
                    return s_italic;
                }
                return EntryPointFactory.get(GeomComposite.class.getSuperclass()).tvEntryPoint.getBaseFont(md, obj);
            }
        });
        EntryPointFactory.register(GeomComposite.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<GeomComposite<?>, Icon>(){

            @Override
            public Icon get(VentusData md, GeomComposite<?> obj, Consumer<Icon> whenReady) {
                if (md.hierarchy.isDescendent(md.sceneGeom, obj)) {
                    return importedGeometryGroupIcon;
                }
                if (md.hierarchy.isDescendent(md.floors, obj)) {
                    return floorGroupIcon;
                }
                if (md.hierarchy.isDescendent(md.elevators, obj)) {
                    return elevatorIcon;
                }
                return blankIcon;
            }
        });
        EntryPointFactory.register(GeomComposite.class, FuncType.TV_GetType, new EntryPoint.Getter<GeomComposite<?>, String>(){

            @Override
            public String get(VentusData md, GeomComposite<?> obj) {
                if (md.hierarchy.isDescendent(md.sceneGeom, obj)) {
                    return Intl.intl("Geometry_Group");
                }
                if (md.hierarchy.isDescendent(md.floors, obj)) {
                    return Intl.intl("Geometry_Group");
                }
                if (md.hierarchy.isDescendent(md.elevators, obj)) {
                    return Intl.intl("Elevator_Group");
                }
                return Intl.intl("Group");
            }
        });
        EntryPointFactory.register(CameraList.class, FuncType.GetCompositeRoot, (VentusData md, T obj) -> md.cameras);
        EntryPointFactory.register(CameraList.class, FuncType.GetNameGenerator, (VentusData md, T obj) -> md.cameraNameGen);
        EntryPointFactory.registerIcon(CameraList.class, cameraListIcon);
        EntryPointFactory.registerType(CameraList.class, Intl.intl("View_Group"));
        EntryPointFactory.register(CameraList.class, FuncType.IsAutoDeleteGroup, new EntryPoint.Getter<CameraList, Boolean>(){

            @Override
            public Boolean get(VentusData md, CameraList obj) {
                return md.cameras != obj;
            }
        });
        EntryPointFactory.registerIcon(Camera.class, cameraIcon);
        EntryPointFactory.registerType(Camera.class, Intl.intl("View"));
        EntryPointFactory.registerCameraTour();
        EntryPointFactory.register(ICameraObj.class, FuncType.GetCompositeRoot, (VentusData md, T obj) -> md.cameras);
        EntryPointFactory.register(ICameraObj.class, FuncType.GetNameGenerator, (VentusData md, T obj) -> md.cameraNameGen);
        EntryPointFactory.register(ICameraObj.class, FuncType.TV_GetForcedAutoexpand, new ConstantGetter(true));
        EntryPointFactory.register(Floor.class, FuncType.GetCompositeRoot, (VentusData md, T obj) -> md.floors);
        EntryPointFactory.register(Floor.class, FuncType.GetNameGenerator, (VentusData md, T obj) -> new ConstantGetter(new SequentialNameGen("Level", 2)));
        EntryPointFactory.register(Floor.class, FuncType.IsMovable, new ConstantGetter(false));
        EntryPointFactory.registerIcon(Floor.class, floorIcon);
        EntryPointFactory.registerType(Floor.class, Intl.intl("Floor"));
        EntryPointFactory.register(Floor.class, FuncType.TV_GetBaseFont, new EntryPoint.Getter<Floor, Font>(){

            @Override
            public Font get(VentusData md, Floor obj) {
                boolean working;
                boolean active = md.floors.getActive() == obj;
                boolean bl = working = md.floors.getActive().getWorkingGeomGroup() == obj;
                if (active && working) {
                    return s_italicBold;
                }
                if (active) {
                    return s_bold;
                }
                if (working) {
                    return s_italic;
                }
                return EntryPointFactory.get(Floor.class.getSuperclass()).tvEntryPoint.getFont(md, obj);
            }
        });
        EntryPointFactory.register(Floor.class, FuncType.CheckDelete, new EntryPoint.Action<Floor, Exception, Set<? extends IMerlinObj>>(){

            @Override
            public Exception perform(VentusData md, Floor obj, Set<? extends IMerlinObj> selObjs) {
                if (obj == md.activeFloor()) {
                    return new Exception(Intl.intl("The active level cannot be deleted."));
                }
                return null;
            }
        });
        EntryPointFactory.register(Floor.class, FuncType.GetOtherDeleteObjs, new EntryPoint.Getter<Floor, Collection<? extends IMerlinObj>>(){

            @Override
            public Collection<? extends IMerlinObj> get(VentusData md, Floor obj) {
                if (obj == md.activeFloor()) {
                    return obj.getChildren();
                }
                return Collections.EMPTY_LIST;
            }
        });
        EntryPointFactory.registerIcon(FloorComposite.class, floorIcon);
        EntryPointFactory.registerType(FloorComposite.class, Intl.intl("Floor_Group"));
        EntryPointFactory.register(ISchematicComp.class, FuncType.TV_GetErrors, new EntryPoint.Getter<ISchematicComp, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(VentusData md, ISchematicComp obj) {
                Collection<Object> errors = Collections.EMPTY_LIST;
                boolean nonManifold = false;
                Collection<Pair<ISchematicComp, ISchematicComp.ConflictType>> overlaps = obj.getConflicts();
                for (Pair<ISchematicComp, ISchematicComp.ConflictType> overlap : overlaps) {
                    String msg = "";
                    String fix = "";
                    switch ((ISchematicComp.ConflictType)((Object)overlap.v2)) {
                        case EDGE: {
                            msg = String.format(Intl.intl("%1$s overlaps %2$s."), obj.getName(), ((ISchematicComp)overlap.v1).getName());
                            fix = Intl.intl("Adjust edges so components no longer overlap.");
                            break;
                        }
                        case NON_MANIFOLD: {
                            nonManifold = true;
                        }
                    }
                    if (msg.isEmpty()) continue;
                    errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.MODERATE, msg, fix, obj));
                }
                if (nonManifold) {
                    String msg = "";
                    String fix = "";
                    if (obj instanceof SchematicDoor) {
                        msg = String.format(Intl.intl("%s must be connected to exactly one or two rooms."), obj.getName());
                    } else if (obj instanceof SchematicCorridor) {
                        msg = String.format(Intl.intl("Each end of %s must be connected to an outer edge of exactly one room."), obj.getName());
                    }
                    errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.MODERATE, msg, fix, obj));
                }
                return errors;
            }
        });
        EntryPointFactory.registerIcon(ISchematicRoom.class, roomIcon);
        EntryPointFactory.register(ISchematicRoom.class, FuncType.GetOtherDeleteObjs, new EntryPoint.Getter<ISchematicRoom, Collection<? extends IMerlinObj>>(){

            @Override
            public Collection<? extends IMerlinObj> get(VentusData md, ISchematicRoom obj) {
                return new ArrayList();
            }
        });
        EntryPointFactory.register(ISchematicRoom.class, FuncType.GetConflict, (VentusData md, T comparable) -> null);
        EntryPointFactory.register(ISchematicConnector.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<ISchematicConnector, Icon>(){

            @Override
            public Icon get(VentusData md, ISchematicConnector obj, Consumer<Icon> whenReady) {
                return obj.isExit() ? exitIcon : doorIcon;
            }
        });
        EntryPointFactory.register(ISchematicConnector.class, FuncType.TV_GetType, new EntryPoint.Getter<ISchematicConnector, String>(){

            @Override
            public String get(VentusData md, ISchematicConnector obj) {
                return obj.isExit() ? "Exit" : "Door";
            }
        });
        EntryPointFactory.registerIcon(SchematicStair.class, stairsIcon);
        EntryPointFactory.registerType(SchematicStair.class, Intl.intl("Stair"));
        EntryPointFactory.register(SchematicStair.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(SchematicStair.class));
        EntryPointFactory.registerIcon(SchematicCorridor.class, rampIcon);
        EntryPointFactory.registerType(SchematicCorridor.class, Intl.intl("Ramp"));
        EntryPointFactory.register(SchematicCorridor.class, FuncType.TV_GetErrors, new EntryPoint.Getter<SchematicCorridor, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(VentusData md, SchematicCorridor obj) {
                Collection<Object> errors = Collections.EMPTY_LIST;
                for (SimError error : EntryPointFactory.get(ISchematicComp.class).tvEntryPoint.getErrors(md, obj)) {
                    errors = EntryPointFactory.lazyAdd(errors, error);
                }
                if (obj.isEnabled()) {
                    ISchematicRoom d_conn1 = obj.getDoor1().getRoom();
                    ISchematicRoom d_conn2 = obj.getDoor2().getRoom();
                    if (d_conn1 == null && d_conn2 == null) {
                        errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.MODERATE, String.format(Intl.intl("%s is not connected to any rooms."), obj.getName()), Intl.intl("Delete or adjust handles to connect to a room."), obj));
                    } else if (d_conn1 instanceof ElevatorRoom || d_conn2 instanceof ElevatorRoom) {
                        errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.MODERATE, Intl.intl("Stairs and ramps may not be connected to elevators."), Intl.intl("Remove this object or reconnect to a non-elevator room."), obj));
                    }
                    if (d_conn1 == null || d_conn2 == null) {
                        String msg = obj instanceof SchematicStair ? Intl.intl("Disconnected Stairway") : Intl.intl("Disconnected Ramp");
                        errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.MODERATE, msg, Intl.intl("Modify geometry or add a landing."), obj));
                    }
                }
                return errors;
            }
        });
        EntryPointFactory.register(SchematicCorridor.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(SchematicCorridor.class));
        EntryPointFactory.registerType(SchematicDoor.class, Intl.intl("Door"));
        EntryPointFactory.register(SchematicDoor.class, FuncType.TV_GetErrors, new EntryPoint.Getter<SchematicDoor, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(VentusData md, SchematicDoor obj) {
                Collection<Object> errors = Collections.EMPTY_SET;
                for (SimError error : EntryPointFactory.get(ISchematicComp.class).tvEntryPoint.getErrors(md, obj)) {
                    errors = EntryPointFactory.lazyAdd(errors, error);
                }
                if (!obj.isEnabled()) {
                    return errors;
                }
                String error = null;
                String fix = null;
                ISchematicRoom room1 = obj.getRoom1();
                ISchematicRoom room2 = obj.getRoom2();
                if (room1 == null && room2 == null) {
                    error = String.format(Intl.intl("%s is not connected to any elements."), obj.getName());
                    fix = Intl.intl("Delete door.");
                } else if (!(room1 != null && room2 != null || obj.isExit())) {
                    error = String.format(Intl.intl("Non-exit, %s, is only connected to one room."), obj.getName());
                    fix = Intl.intl("Delete or adjust handles to connect to another room.");
                } else if (!(obj instanceof ElevatorDoor) && (room1 instanceof ElevatorRoom || room2 instanceof ElevatorRoom)) {
                    error = String.format(Intl.intl("Doors may not be connected to an existing elevator."), new Object[0]);
                    fix = Intl.intl("Remove this door or reconnect to a non-elevator room.");
                }
                if (error != null) {
                    errors = EntryPointFactory.lazyAdd(errors, new SimError(SimError.Level.CRITICAL, error, fix, obj));
                }
                return errors;
            }
        });
        EntryPointFactory.register(SchematicDoor.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(SchematicDoor.class));
        EntryPointFactory.registerType(SchematicRoom.class, Intl.intl("Room"));
        EntryPointFactory.register(SchematicRoom.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(SchematicRoom.class));
        EntryPointFactory.registerType(Elevator.class, Intl.intl("Elevator"));
        EntryPointFactory.register(Elevator.class, FuncType.GetCompositeRoot, (VentusData md, T obj) -> md.elevators);
        EntryPointFactory.register(Elevator.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("Elevator", 2)));
        EntryPointFactory.register(Elevator.class, FuncType.IsAutoDeleteGroup, new ConstantGetter(true));
        EntryPointFactory.register(Elevator.class, FuncType.TV_GetErrors, new EntryPoint.Getter<Elevator, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(VentusData md, Elevator obj) {
                Object enabled;
                EntryPoint superep = EntryPointFactory.get(obj.getClass().getSuperclass());
                ArrayList<SimError> errors = new ArrayList<SimError>(superep.tvEntryPoint.getErrors(md, obj));
                for (IMerlinObj child : obj.getChildren()) {
                    errors.addAll(EntryPointFactory.get(child).tvEntryPoint.getErrors(md, child));
                }
                Floor dischargeFloor = obj.getDischargeFloor();
                if (dischargeFloor == null && (!((enabled = obj.getProperty(VentusData.ENABLED)) instanceof Boolean) || ((Boolean)enabled).booleanValue())) {
                    errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("Elevator is not connected at its discharge floor."), Intl.intl("Make sure the elevator's doors are enabled at the discharge floor or change the elevator's discharge floor."), obj));
                }
                List cachedErrors = doubleDeckElevatorWarnings.getOrDefault(obj, Collections.emptyList());
                errors.addAll(cachedErrors);
                return errors;
            }
        });
        EntryPointFactory.register(Elevator.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(Elevator.class));
        EntryPointFactory.registerType(ElevatorGroup.class, Intl.intl("Elevator_Group"));
        EntryPointFactory.register(ElevatorGroup.class, FuncType.GetCompositeRoot, (VentusData md, T obj) -> md.elevators);
        EntryPointFactory.register(ElevatorGroup.class, FuncType.CheckDelete, (VentusData md, T obj, ArgT delObjs) -> null);
        EntryPointFactory.register(ElevatorGroup.class, FuncType.TV_GetErrors, new EntryPoint.Getter<ElevatorGroup, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(VentusData md, ElevatorGroup obj) {
                EntryPoint superep = EntryPointFactory.get(obj.getClass().getSuperclass());
                ArrayList<SimError> errors = new ArrayList<SimError>(superep.tvEntryPoint.getErrors(md, obj));
                for (IMerlinObj child : obj.getChildren()) {
                    errors.addAll(EntryPointFactory.get(child).tvEntryPoint.getErrors(md, child));
                }
                Optional<Object> dischargeFloor = Optional.empty();
                for (Elevator elevator : obj.flatten(Elevator.class)) {
                    Floor floor = elevator.getDischargeFloor();
                    if (floor == null) continue;
                    if (dischargeFloor.isEmpty()) {
                        dischargeFloor = Optional.of(floor);
                        continue;
                    }
                    if (dischargeFloor.get() == floor) continue;
                    errors.add(new SimError(SimError.Level.MODERATE, Intl.intl("Elevators in the same group (call set) should have the same discharge floor. Different floors may produce unknown behavior."), Intl.intl("Set all elevators in the group to the same discharge floor."), obj));
                    break;
                }
                return errors;
            }
        });
        EntryPointFactory.register(IElevatorComp.class, FuncType.CheckDelete, new EntryPoint.Action<IElevatorComp, Exception, Set<? extends IMerlinObj>>(){

            @Override
            public Exception perform(VentusData md, IElevatorComp obj, Set<? extends IMerlinObj> delObjs) {
                Elevator elevator;
                Object parent = md.hierarchy.getParent(obj);
                if (parent instanceof Elevator && (delObjs.contains(elevator = (Elevator)parent) || delObjs.containsAll(elevator.getChildren()))) {
                    return null;
                }
                return new Exception(Intl.intl("Elevator rooms and doors cannot be individually deleted."));
            }
        });
        EntryPointFactory.registerType(ElevatorRoom.class, Intl.intl("Room"));
        EntryPointFactory.register(ElevatorRoom.class, FuncType.GetCompositeRoot, (VentusData md, T obj) -> md.elevators);
        EntryPointFactory.register(ElevatorRoom.class, FuncType.TV_GetBaseFont, new EntryPoint.Getter<ElevatorRoom, Font>(){

            @Override
            public Font get(VentusData md, ElevatorRoom obj) {
                Object parent = md.hierarchy.getParent(obj);
                if (parent instanceof Elevator && ((Elevator)parent).getDischargeRoom() == obj) {
                    return s_bold;
                }
                return EntryPointFactory.get(ElevatorRoom.class.getSuperclass()).tvEntryPoint.getBaseFont(md, obj);
            }
        });
        EntryPointFactory.register(ElevatorRoom.class, FuncType.TV_GetErrors, new EntryPoint.Getter<ElevatorRoom, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(VentusData md, ElevatorRoom obj) {
                EntryPoint superep = EntryPointFactory.get(obj.getClass().getSuperclass());
                ArrayList<SimError> errors = new ArrayList<SimError>(superep.tvEntryPoint.getErrors(md, obj));
                for (IMerlinObj iMerlinObj : obj.getChildren()) {
                    errors.addAll(EntryPointFactory.get(iMerlinObj).tvEntryPoint.getErrors(md, iMerlinObj));
                }
                LinkedIdentityHashSet connectedFloors = new LinkedIdentityHashSet();
                for (ElevatorDoor door : obj.getElevatorDoors()) {
                    Floor floor = ElevatorUtil.getFloor(md, obj, door);
                    if (floor == null) continue;
                    connectedFloors.add(floor);
                }
                if (connectedFloors.size() > 1) {
                    errors.add(new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("Elevator level is connected to %d floors.  It must only be connected to one."), connectedFloors.size()), Intl.intl("Move all rooms connected to the elevator level to the same floor."), obj));
                }
                if (connectedFloors.size() >= 1) {
                    Elevator elevator = (Elevator)obj.getParent();
                    if (elevator != null) {
                        IdentityHashMap<Floor, Integer> floorUseCounts = new IdentityHashMap<Floor, Integer>();
                        for (ElevatorRoom level : elevator.getMembers(ElevatorRoom.class)) {
                            Floor floor = ElevatorUtil.getFloor(md, level);
                            if (floor == null) continue;
                            Integer count = (Integer)floorUseCounts.get(floor);
                            if (count == null) {
                                floorUseCounts.put(floor, 1);
                                continue;
                            }
                            count = count + 1;
                            floorUseCounts.put(floor, count);
                        }
                        Integer count = (Integer)floorUseCounts.get(connectedFloors.iterator().next());
                        if (count != null && count > 1) {
                            errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("Multiple elevator levels connected to one floor."), Intl.intl("This elevator level must be connected to its own floor."), obj));
                        }
                    } else {
                        errors.add(new SimError(SimError.Level.CRITICAL, Intl.intl("This elevator is in an invalid state."), Intl.intl("elevatorRoom.getParent() is returning null."), obj));
                    }
                }
                return errors;
            }
        });
        EntryPointFactory.register(ElevatorRoom.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(ElevatorRoom.class));
        EntryPointFactory.registerType(ElevatorDoor.class, Intl.intl("Door"));
        EntryPointFactory.register(ElevatorRoom.class, FuncType.GetCompositeRoot, (VentusData md, T obj) -> md.elevators);
        EntryPointFactory.register(ElevatorDoor.class, FuncType.TV_GetErrors, new EntryPoint.Getter<ElevatorDoor, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(VentusData md, ElevatorDoor obj) {
                EntryPoint superep = EntryPointFactory.get(obj.getClass().getSuperclass());
                Collection<SimError> errors = superep.tvEntryPoint.getErrors(md, obj);
                if (obj.getRoom1() instanceof ElevatorRoom && obj.getRoom2() != obj.getRoom1() && obj.getRoom2() instanceof ElevatorRoom) {
                    SimError error = new SimError(SimError.Level.CRITICAL, Intl.intl("Elevator doors can only be connected to one elevator."), Intl.intl("Delete one of the elevators."), obj);
                    ArrayList<SimError> newErrors = new ArrayList<SimError>(errors);
                    newErrors.add(error);
                    errors = newErrors;
                }
                return errors;
            }
        });
        EntryPointFactory.register(ElevatorDoor.class, FuncType.GetConflict, new EntryPoint.Getter<ElevatorDoor, ElevatorDoor>(){

            @Override
            public ElevatorDoor get(VentusData md, ElevatorDoor comparable) {
                Collection<ElevatorRoom> elevatorRooms = md.elevators.flatten(ElevatorRoom.class);
                for (ElevatorRoom room : elevatorRooms) {
                    for (ElevatorDoor door : room.getElevatorDoors()) {
                        if (!theUtil.equal(comparable, door)) continue;
                        return door;
                    }
                }
                return null;
            }
        });
        EntryPointFactory.registerType(ImportedGeom.class, Intl.intl("Imported"));
        EntryPointFactory.register(ImportedGeom.class, FuncType.GetCompositeRoot, (VentusData md, T obj) -> md.sceneGeom);
        EntryPointFactory.register(ImportedGeom.class, FuncType.GetNameGenerator, new ConstantGetter(new SequentialNameGen("Imported", 2)));
        EntryPointFactory.register(ImportedGeom.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<ImportedGeom, Icon>(){

            @Override
            public Icon get(VentusData md, ImportedGeom obj, Consumer<Icon> whenReady) {
                if (obj.getGeom().getNumPrims(1) > 0) {
                    return importedGeometry3DIcon;
                }
                return importedGeometry2DIcon;
            }
        });
        EntryPointFactory.registerIcon(RasterImage.class, backgroundImageIcon);
        EntryPointFactory.registerType(RasterImage.class, Intl.intl("Background_Image"));
        EntryPointFactory.register(Proxy.class, FuncType.TV_GetForcedAutoexpand, new EntryPoint.Getter<Proxy<? extends ICompElement>, Boolean>(){

            @Override
            public Boolean get(VentusData md, Proxy<? extends ICompElement> obj) {
                return md.selection.isSelected(obj);
            }
        });
        EntryPointFactory.register(Proxy.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<Proxy<? extends ICompElement>, Icon>(){

            @Override
            public Icon get(VentusData md, Proxy<? extends ICompElement> proxy, Consumer<Icon> whenReady) {
                ICompElement obj = proxy.getObj();
                return ((EntryPoint.AsyncGetter)EntryPointFactory.findFunc(obj.getClass(), FuncType.TV_GetIcon, obj)).get(md, obj, whenReady);
            }
        });
        EntryPointFactory.register(Proxy.class, FuncType.TV_GetErrors, new EntryPoint.Getter<Proxy, Collection<? extends SimError>>(){

            @Override
            public Collection<? extends SimError> get(VentusData md, Proxy obj) {
                EntryPoint superep = EntryPointFactory.get(obj.getClass().getSuperclass());
                ArrayList<SimError> errors = new ArrayList<SimError>(superep.tvEntryPoint.getErrors(md, obj));
                return errors;
            }
        });
        EntryPointFactory.register(MaterialDB.class, FuncType.TV_GetParent, (VentusData md, T obj) -> null);
        EntryPointFactory.registerIcon(MaterialDB.class, materialsIcon);
        EntryPointFactory.registerType(MaterialDB.class, Intl.intl("Material_Database"));
        EntryPointFactory.registerType(Material.class, Intl.intl("Material"));
        EntryPointFactory.register(Material.class, FuncType.GetCompositeRoot, (VentusData md, T obj) -> md.materials);
        EntryPointFactory.register(Material.class, FuncType.Delete, new EntryPoint.Action<Material, Boolean, Object>(){

            @Override
            public Boolean perform(VentusData md, Material obj, Object arg) {
                MaterialDB db = md.materials;
                return db.remove(obj, true);
            }
        });
        EntryPointFactory.register(Material.class, FuncType.TV_GetIcon, new EntryPoint.AsyncGetter<Material, Icon>(){

            @Override
            public Icon get(VentusData md, Material obj, Consumer<Icon> whenReady) {
                return guiUtil.getIconsAsync(icons -> whenReady.accept(icons[0]), obj, 16, 16, 0, guiUtil.ImageFilter.NORMAL)[0];
            }
        });
        EntryPointFactory.register(Material.class, FuncType.GetConflict, EntryPointFactory.getStandardConflictGetter(Material.class));
        for (Pair<Class<?>, FuncType> funcEntry : s_funcs.keySet()) {
            EntryPointFactory.get((Class)funcEntry.v1);
        }
    }

    public static enum FuncType {
        CheckDelete,
        GetOtherDeleteObjs,
        GetConflict,
        Delete,
        IsAutoDeleteGroup,
        IsVisible,
        SetVisible,
        GetCompositeRoot,
        GetNameGenerator,
        GetUniqueNameGroup,
        GetNameFormatRules,
        IsIndexed,
        IsMovable,
        TV_GetErrors,
        TV_GetRuntimeErrors,
        TV_GetName,
        TV_SetName,
        TV_CanRename,
        TV_GetIcon,
        TV_GetType,
        TV_GetBaseFont,
        TV_IsVisible,
        TV_IsEnabled,
        TV_GetForcedAutoexpand,
        TV_IsLeaf,
        TV_GetChildren,
        TV_GetParent;

    }

    private static class ConstantAsyncGetter<T, ReturnT>
    implements EntryPoint.AsyncGetter<T, ReturnT> {
        private final ReturnT d_value;

        public ConstantAsyncGetter(ReturnT value) {
            this.d_value = value;
        }

        @Override
        public ReturnT get(VentusData md, T obj, Consumer<ReturnT> whenReady) {
            return this.d_value;
        }
    }

    private static class ConstantGetter<T, ReturnT>
    implements EntryPoint.Getter<T, ReturnT> {
        private final ReturnT d_value;

        public ConstantGetter(ReturnT value) {
            this.d_value = value;
        }

        @Override
        public ReturnT get(VentusData md, T obj) {
            return this.d_value;
        }
    }

    private static class NullAction<T, ReturnT, ArgT>
    implements EntryPoint.Action<T, ReturnT, ArgT> {
        private final ReturnT d_value;

        public NullAction(ReturnT defReturn) {
            this.d_value = defReturn;
        }

        @Override
        public ReturnT perform(VentusData md, T obj, ArgT arg) {
            return this.d_value;
        }
    }

    private static class NullSetter<T, ArgT>
    implements EntryPoint.Setter<T, ArgT> {
        private NullSetter() {
        }

        @Override
        public void set(VentusData md, T obj, ArgT arg) {
        }
    }

    public static class CompositeSimError
    extends SimError {
        public final int errorCount;

        public CompositeSimError(SimError.Level level, int errorCount, Collection<? extends IMerlinObj> causeObjs) {
            this(level, errorCount, causeObjs, SimError.Type.DATA);
        }

        public CompositeSimError(SimError.Level level, int errorCount, Collection<? extends IMerlinObj> causeObjs, SimError.Type type) {
            super(level, Integer.toString(errorCount), "", causeObjs, type);
            this.errorCount = errorCount;
        }
    }

    private static abstract class MVMgrConstructor<T>
    implements EntryPoint.Action<T, Collection<? extends IMerlinDispMgr<?>>, ModelView> {
        private Collection<? extends IMerlinDispMgr<?>> d_managers;

        private MVMgrConstructor() {
        }

        @Override
        public Collection<? extends IMerlinDispMgr<?>> perform(VentusData md, T obj, ModelView mv) {
            if (this.d_managers != null) {
                return this.d_managers;
            }
            this.d_managers = this.create(md, obj, mv);
            return this.d_managers;
        }

        protected abstract Collection<? extends IMerlinDispMgr<?>> create(VentusData var1, T var2, ModelView var3);
    }
}

