/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class LWArrayList {
    public static <T> Object newList(Collection<? extends T> objs) {
        if (objs.isEmpty()) {
            return null;
        }
        if (objs.size() == 1) {
            return objs.iterator().next();
        }
        return new ArrayList<T>(objs);
    }

    public static <T> Object add(Object coll, T obj) {
        if (coll == null) {
            return obj;
        }
        if (coll instanceof Object[]) {
            Object[] arr = coll;
            if (arr.length == 10) {
                ArrayList<Object> list = new ArrayList<Object>(arr.length + 1);
                list.addAll(Arrays.asList(arr));
                list.add(obj);
                coll = list;
            } else {
                arr = LWArrayList.resizeArray(arr, arr.length + 1);
                arr[arr.length - 1] = obj;
                coll = arr;
            }
            return coll;
        }
        if (coll instanceof List) {
            ((ArrayList)coll).add(obj);
            return coll;
        }
        Object[] list = new Object[]{coll, obj};
        return list;
    }

    private static Object[] resizeArray(Object[] arr, int newSize) {
        Object[] newArr = new Object[newSize];
        for (int m = 0; m < arr.length; ++m) {
            newArr[m] = arr[m];
        }
        return newArr;
    }

    public static Object clear(Object coll) {
        return null;
    }

    public static int size(Object coll) {
        if (coll == null) {
            return 0;
        }
        if (coll instanceof List) {
            return ((List)coll).size();
        }
        return 1;
    }

    public static boolean isEmpty(Object coll) {
        return coll == null;
    }

    public static <T> T get(Object coll, int index) {
        if (coll == null) {
            throw new IndexOutOfBoundsException();
        }
        if (coll instanceof Object[]) {
            return (T)((Object[])coll)[index];
        }
        if (coll instanceof List) {
            return (T)((List)coll).get(index);
        }
        if (index > 0 || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return (T)coll;
    }

    public static <T> Object set(Object coll, int index, T obj) {
        if (coll == null) {
            throw new IndexOutOfBoundsException();
        }
        if (coll instanceof Object[]) {
            ((Object[])coll)[index] = obj;
            return coll;
        }
        if (coll instanceof List) {
            ((List)coll).set(index, obj);
            return coll;
        }
        if (index > 0 || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return obj;
    }
}

