/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import javafx.embed.swing.JFXPanel;
import javax.swing.SwingUtilities;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.v6.FDS6Const;
import thunderheadeng.gui.guiJFXDirectoryChooser;

public class FDSRecordSpecDiagnostics {
    public static void main(String[] args) throws InterruptedException, InvocationTargetException {
        File outDir;
        if (args.length == 1) {
            outDir = new File(args[0]);
        } else {
            FDSRecordSpecDiagnostics.wakeupJavaFX();
            guiJFXDirectoryChooser chooser = new guiJFXDirectoryChooser(null, "Choose output directory");
            outDir = chooser.showDirDialog();
        }
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        File outFile = new File(outDir, "namelists_java.txt");
        try {
            outFile.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (PrintWriter writer = new PrintWriter(outFile);){
            FDS6Const.getRecordSpecs().entrySet().stream().sorted((kvPair1, kvPair2) -> ((String)kvPair1.getKey()).compareTo((String)kvPair2.getKey())).forEach(kvPair -> ((FDSRecordSpec)kvPair.getValue()).fields.keySet().stream().sorted(FDSRecordSpecDiagnostics.getUnderscoreAgnosticComparator()).forEachOrdered(field -> writer.println("/" + (String)kvPair.getKey() + "/" + field)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    private static void wakeupJavaFX() throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(JFXPanel::new);
    }

    private static Comparator<String> getUnderscoreAgnosticComparator() {
        return (s1, s2) -> {
            int len1 = s1.length();
            int len2 = s2.length();
            int lim = Math.min(len1, len2);
            char[] v1 = s1.toCharArray();
            char[] v2 = s2.toCharArray();
            for (int k = 0; k < lim; ++k) {
                char c1 = v1[k];
                char c2 = v2[k];
                if ('_' == c1 && (Character.isAlphabetic(c2) || Character.isDigit(c2))) {
                    return c2 - c1;
                }
                if ('_' == c2 && (Character.isAlphabetic(c1) || Character.isDigit(c1))) {
                    return c2 - c1;
                }
                if (c1 == c2) continue;
                return c1 - c2;
            }
            return len1 - len2;
        };
    }
}

