/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.treeview;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.tasks.SetNameTask;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.Util;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class TVEntryPoint<T> {
    protected static final Font s_plain = new Font("Sans Serif", 0, 11);
    protected static final Font s_bold = new Font("Sans Serif", 1, 11);
    protected static final Font s_italic = new Font("Sans Serif", 2, 11);
    protected static final Font s_italicBold = s_italic.deriveFont(1);
    private static final Map<Class, Boolean> s_refedTypesToUpdate = new HashMap<Class, Boolean>();
    private final ImageIcon d_icon;
    private final String d_categoryName;

    public static void registerReferencedUpdateTypes(Class<? extends IPyroObject> ... types) {
        for (Class<? extends IPyroObject> type : types) {
            s_refedTypesToUpdate.put(type, Boolean.TRUE);
        }
    }

    protected static boolean getDependentsNeedUpdate(Class type) {
        Boolean refed = s_refedTypesToUpdate.get(type);
        if (refed == null) {
            refed = theUtil.findObjectForClass(s_refedTypesToUpdate, type);
            if (refed == null) {
                refed = false;
            }
            s_refedTypesToUpdate.put(type, refed);
        }
        return refed;
    }

    public TVEntryPoint(String categoryName) {
        this(null, categoryName);
    }

    public TVEntryPoint(ImageIcon icon, String categoryName) {
        this.d_icon = icon;
        this.d_categoryName = categoryName;
    }

    public String getCategoryName(T obj) {
        return this.getCategoryName();
    }

    protected String getCategoryName() {
        return this.d_categoryName;
    }

    public String getName(T obj) {
        if (obj instanceof INamed) {
            return ((INamed)obj).getName();
        }
        return obj.toString();
    }

    public String getDisplayName(T obj) {
        return this.getName(obj);
    }

    public String getTooltip(T obj) {
        return "";
    }

    public void setName(PyroMod md, T obj, String newText) {
        if (obj instanceof INamed) {
            try {
                newText = Util.validateName(md, (INamed)obj, newText);
                SetNameTask tsk = new SetNameTask((INamed)obj, newText);
                md.getTaskManager().exec(tsk, Intl.intl("Rename"));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), e.getLocalizedMessage(), Intl.intl("Invalid Name"), 0);
            }
        }
    }

    public boolean objectInModel(PyroMod md, T obj) {
        if (!(obj instanceof IPyroObject)) {
            return false;
        }
        return ((IPyroObject)obj).getDomain() == md;
    }

    public Object getTreeviewParent(PyroMod md, T obj) {
        if (obj instanceof IPyroObject) {
            return ((IPyroObject)obj).getParent();
        }
        return null;
    }

    public boolean canRename(PyroMod md, T obj) {
        return obj instanceof INamed && ((INamed)obj).isSetNameSupported();
    }

    public boolean isDependentSingleton(PyroMod md, T obj) {
        return false;
    }

    public Icon[] getIcons(PyroMod md, T obj, Consumer<Icon[]> whenDone) {
        return new Icon[]{this.d_icon, null};
    }

    public Font getBaseFont(PyroMod md, T obj) {
        return s_plain;
    }

    public Font getFont(PyroMod md, T obj) {
        Font base = this.getBaseFont(md, obj);
        if (!this.isEnabled(md, obj)) {
            HashMap attribs = new HashMap(base.getAttributes());
            attribs.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            base = base.deriveFont(attribs);
        }
        return base;
    }

    public boolean isVisible(PyroMod md, T obj) {
        if (obj instanceof IPyroGeomSrc) {
            return ((IPyroGeomSrc)obj).isVisible();
        }
        return true;
    }

    public boolean isEnabled(PyroMod md, T obj) {
        if (obj instanceof IPyroObject) {
            return ((IPyroObject)obj).isEnabled();
        }
        return true;
    }

    public boolean isLeaf(PyroMod md, T obj) {
        if (obj instanceof IPyroObject) {
            return ((IPyroObject)obj).getMembers().isEmpty();
        }
        return false;
    }

    public Object getPasteLocation(PyroMod md, T obj) {
        return this.getCategoryRoot(md, obj);
    }

    public boolean canPaste(PyroMod md, T obj, Object child) {
        return false;
    }

    public boolean canMerge(PyroMod md, T obj) {
        return false;
    }

    public T mergeToRoot(PyroMod md, T obj) {
        return null;
    }

    public boolean isOccluder(PyroMod md, T obj) {
        return true;
    }

    public boolean isDrawingSnappable(PyroMod md, T obj) {
        return true;
    }

    public boolean showInTree(PyroMod md, T obj) {
        T curr = obj;
        Object parent = this.getTreeviewParent(md, obj);
        if (parent != null) {
            TVEntryPoint<Object> parentep = TVEntryPoints.ep(parent);
            if (parent == md) {
                return parentep.getTreeviewChildren(md, parent).contains(curr);
            }
            return parentep.showInTree(md, parent);
        }
        return false;
    }

    public boolean mayBeReferenced(PyroMod md, T obj) {
        return true;
    }

    public boolean getDependentsMayNeedUpdate(PyroMod md, T obj) {
        return obj == null ? false : TVEntryPoint.getDependentsNeedUpdate(obj.getClass());
    }

    public Object getCategoryRoot(PyroMod md, T obj) {
        for (IPyroObject iPyroObject : md.getMembers()) {
            if (!TVEntryPoints.ep(iPyroObject).isContainer(md, iPyroObject, obj)) continue;
            return iPyroObject;
        }
        return null;
    }

    public Collection<?> getTreeviewChildren(PyroMod md, T obj) {
        if (obj instanceof IPyroObject) {
            return ((IPyroObject)obj).getMembers();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isContainer(PyroMod md, T obj, Object child) {
        return false;
    }

    public boolean canDelete(PyroMod md, T obj, Object child) {
        return false;
    }

    public boolean preserveIndexOnDelete(PyroMod md, T obj, Object child) {
        return true;
    }

    public boolean add(T obj, Object child) {
        return false;
    }

    public boolean addAll(T obj, Collection<?> children) {
        boolean addedAll = true;
        for (Object child : children) {
            addedAll &= this.add(obj, child);
        }
        return addedAll;
    }

    public boolean remove(T obj, Object child) {
        return false;
    }

    public boolean removeAll(T obj, Collection<?> children) {
        boolean removedAll = true;
        for (Object child : children) {
            removedAll &= this.remove(obj, child);
        }
        return removedAll;
    }

    public void reorder(T obj, Collection<?> newOrder) {
    }

    public Object getConflict(PyroMod md, T categoryRoot, Object child) {
        return null;
    }

    public boolean isEquivalent(PyroMod md, T categoryRoot, Object existing, Object incoming) {
        return existing.equals(incoming);
    }

    public Task paste(PyroMod md, T pasteLoc, Object newObj, Object existingObj, ConflictResolution cr, DepSnapshot deps) {
        return EmptyTask.INSTANCE;
    }

    public boolean isDroppable(PyroMod md, T target) {
        return false;
    }

    public boolean canDrop(PyroMod md, T target, Set<?> objs, Object commonParent) {
        return false;
    }

    public Task drop(PyroMod md, T target, int insertPos, Collection<?> objs) {
        return EmptyTask.INSTANCE;
    }

    public IRenameGroup getRenameGroup(PyroMod pm, T refObj) {
        return null;
    }

    public static interface IRenameGroup {
        public Collection<?> getGroupedObjects(PyroMod var1);
    }

    public static enum ConflictResolution {
        OVERWRITE_EXISTING,
        RENAME_NEW;

    }
}

