/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.util.List;
import java.util.Map;
import pyrosim.PyroMod;
import pyrosim.domain.geom.ISurfObj;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.legacy.v1.util.LinkedIdentityHashMap;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IPropertySet;

public class FaceCache
implements IEventObserver {
    public static final int MAX_CACHE_SIZE = 20;
    private final Map<ISurfObj, Faces> d_faceCache = new LinkedIdentityHashMap<ISurfObj, Faces>();

    public FaceCache(PyroMod domain) {
        domain.getEvents().addObserver(this);
    }

    @Override
    public void update(Events events) {
        IEventRecord<ISurfObj> oevts = events.getEvents(ISurfObj.class, new Class[0]);
        this.d_faceCache.keySet().removeAll(oevts.getRemovedObjs());
        this.d_faceCache.keySet().removeAll(oevts.getChangedNotOfType(PyroMod.EVT_SEL, PyroMod.EVT_VISIBILITY_CHANGED));
    }

    public Faces getFaces(ISurfObj obst) {
        Faces faces = this.d_faceCache.get(obst);
        if (faces == null) {
            IGeomNode fnode = obst.getGeom().flatten();
            List<IFace> flist = GeomUtil.explode(fnode.getLocalGeom(), IFace.class);
            faces = new Faces(flist.toArray(new IFace[flist.size()]), fnode.getLocalElements());
            if (this.d_faceCache.size() == 20) {
                this.d_faceCache.remove(this.d_faceCache.keySet().iterator().next());
            }
            this.d_faceCache.put(obst, faces);
        } else {
            this.d_faceCache.remove(obst);
            this.d_faceCache.put(obst, faces);
        }
        return faces;
    }

    public void clear() {
        this.d_faceCache.clear();
    }

    public static class Faces {
        public final IFace[] faces;
        public final IPropertySet elems;

        public Faces(IFace[] faces, IPropertySet elems) {
            this.faces = faces;
            this.elems = elems;
        }
    }
}

