/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.snappers;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.mv.snappers.ISnapper;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.nativebuffered.OriginDisp;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;

public class OriginSnapper
extends OriginDisp
implements ISnapper {
    private static final long serialVersionUID = -6802169228030203862L;

    public OriginSnapper() {
    }

    public OriginSnapper(Matrix4d xform) {
        super(xform);
    }

    @Override
    public AABox getBounds() {
        return new AABox(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return DisplayGeom.EMPTY;
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull box) {
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
        if (!filter.acceptPickObject(this)) {
            return;
        }
        boolean edges = filter.acceptGeomType(this, GeomType.EDGE);
        boolean points = filter.acceptGeomType(this, GeomType.VERTEX);
        if (!edges && !points) {
            return;
        }
        Point3d origin = Util3D.xform(this.getTransform(), GeomConstants.PNT3D_ORIGIN);
        Vector3d[] vecs = new Vector3d[]{Util3D.xform(this.getTransform(), GeomConstants.VEC3D_XPOS), Util3D.xform(this.getTransform(), GeomConstants.VEC3D_YPOS), Util3D.xform(this.getTransform(), GeomConstants.VEC3D_ZPOS)};
        if (edges) {
            Vector3d[] vector3dArray = vecs;
            int n = vector3dArray.length;
            for (int i = 0; i < n; ++i) {
                Point3d isect = new Point3d();
                Vector3d dir = vector3dArray[i];
                if (!Inter3D.lineLineProximity(isect, null, origin, dir, rayBegin, rayDirN)) continue;
                isects.addInfinite(this, isect, GeomType.EDGE, null);
            }
        }
        if (points) {
            isects.addInfinite(this, origin, GeomType.VERTEX, new Point(origin));
        }
    }
}

