/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.vecmath.Vector3d;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.GridRefinement;
import pyrosim.domain.Property;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.devices.IAttachedPointDevice;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreePointDevice;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.geom.Geometry;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.ParticleComboBox;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.comboboxes.SurfaceComboBox;
import pyrosim.gui.devices.DevcEditorFactory;
import pyrosim.gui.devices.DeviceEditorUtil;
import pyrosim.gui.devices.DevicePnl;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.geom.InitEditor;
import pyrosim.gui.geom.PartCloudEditor;
import pyrosim.mv.tools.DrawProps;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.Util;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class ToolPropertiesDlg
extends guiDialog {
    private static final long serialVersionUID = 5542101197693312041L;
    private static final String COLOR_FROM_SURF = Intl.intl("From Surface");
    private static final String COLOR_SPECIFY = Intl.intl("Specify");
    private guiTextField d_nameFld;
    private ValueField<UnitDouble> d_location;
    private guiLabel orientationLab;
    private guiLabel xOrienLab;
    private guiLabel yOrienLab;
    private guiLabel zOrienLab;
    private ValueField<Double> d_xOrien;
    private ValueField<Double> d_yOrien;
    private ValueField<Double> d_zOrien;
    private JComponent[] d_orientComponents;
    private guiLabel normalSolidLab;
    private guiLabel xNormalSolidLab;
    private guiLabel yNormalSolidLab;
    private guiLabel zNormalSolidLab;
    private ValueField<Double> d_xNormalSolid;
    private ValueField<Double> d_yNormalSolid;
    private ValueField<Double> d_zNormalSolid;
    private JComponent[] d_normalSolidComponents;
    private ValueField<UnitDouble> d_thick;
    private ValueField<UnitDouble> d_height;
    private guiCheckBox d_cbSpecifySurf;
    private guiCheckBox d_cbRemoveTexUV;
    private SurfaceComboBox d_surfCombo;
    private ParticleComboBox d_partCombo;
    private JButton d_editPartButton;
    private guiCheckBox d_cbSpecifyColor;
    private guiComboBox<String> d_cbColorSpec;
    private ColorButton d_cbColor;
    private guiCheckBox d_cbThicken = new guiCheckBox(Intl.intl("Thicken"), false);
    private guiCheckBox d_cbPermitHoles = new guiCheckBox(Intl.intl("Permit Holes"), true);
    private guiComboBox<DevicePnl<? extends IDevice>> d_devcTypeCB;
    private guiComboBox<Geometry.Axis> d_axisCB;
    private QuantityComboBox d_sliceQuantityCB;
    private guiCheckBox d_sliceVectorCB;
    private guiCheckBox d_sliceCenteredCB;
    private guiRadioButton d_fixedCellSizeRB;
    private guiRadioButton d_fixedCellCountRB;
    private ValueField<UnitDouble> d_cellSizeX;
    private ValueField<UnitDouble> d_cellSizeY;
    private ValueField<UnitDouble> d_cellSizeZ;
    private ValueField<Integer> d_cellCountX;
    private ValueField<Integer> d_cellCountY;
    private ValueField<Integer> d_cellCountZ;
    private guiComboBox<GridRefinement.RefinementAmount> d_refinementAmountCB;
    private PartCloudEditor.InsertionPanel d_massDensPanel;
    private TitleSeparator d_movementTitle;
    private PartCloudEditor.DropletCountPanel d_dropCountPanel;
    private InitEditor d_initEditor;
    private final Set<DrawProps.Prop<?>> d_propTypes;
    private final DrawProps d_props;
    private final String d_nameKey;
    private final int d_axis;

    public ToolPropertiesDlg(JFrame parent, PyroMod mediator, Camera cam, String nameKey, String thicknessDesc, Predicate<Surface> surfFilter, DrawProps props, Collection<DrawProps.Prop<?>> propTypes) {
        super((Window)parent, Intl.intl("Tool Properties"), 9);
        JComponent lblComp;
        this.d_props = props;
        this.d_nameKey = nameKey;
        this.d_propTypes = propTypes instanceof Set ? (Set<Object>)propTypes : new HashSet(propTypes);
        this.d_axis = cam instanceof OrthoCamera ? Util.getClosestAxis(cam.getViewVector()) : 2;
        String locStr = switch (this.d_axis) {
            case 0 -> Intl.intl("X Location:");
            case 1 -> Intl.intl("Y Location:");
            case 2 -> Intl.intl("Z Location:");
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                yield null;
            }
        };
        guiPanel dlgPane = this.getDialogPane();
        dlgPane.setLayout(new MigLayout("insets 0, gap 6, hidemode 3"));
        int rowCount = 0;
        if (this.propsAffected(DrawProps.NAME)) {
            this.d_nameFld = new guiTextField((String)props.get(new DrawProps.Prop(nameKey)));
            this.d_nameFld.setPreferredSize(new Dimension(150, this.d_nameFld.getPreferredSize().height));
            rowCount = this.addRow(dlgPane, new guiLabel(Intl.intl("Name:")), rowCount);
            dlgPane.add((Component)this.d_nameFld, "span, grow");
        }
        if (this.propsAffected(DrawProps.LOCATION)) {
            this.d_location = ValueFields.udFld(props.get(DrawProps.LOCATION), UnitSystem.getSource(0));
            rowCount = this.addRow(dlgPane, new guiLabel(locStr), rowCount);
            dlgPane.add(this.d_location);
        }
        if (this.propsAffected(DrawProps.ORIENTATION)) {
            Vector3d ori = props.get(DrawProps.ORIENTATION);
            this.d_xOrien = ValueFields.doubleFld(ori.x);
            this.d_yOrien = ValueFields.doubleFld(ori.y);
            this.d_zOrien = ValueFields.doubleFld(ori.z);
            if (this.propsAffected(DrawProps.DEVC)) {
                this.orientationLab = new guiLabel(Intl.intl("Orientation"));
                this.xOrienLab = new guiLabel(Intl.intl("X:"));
                this.yOrienLab = new guiLabel(Intl.intl("Y:"));
                this.zOrienLab = new guiLabel(Intl.intl("Z:"));
                rowCount = this.addRow(dlgPane, this.orientationLab, rowCount);
                guiPanel orientationPanel = new guiPanel(new MigLayout("hidemode 3, insets 0"));
                this.d_orientComponents = new JComponent[]{this.orientationLab, orientationPanel};
                orientationPanel.add(this.xOrienLab);
                orientationPanel.add(this.d_xOrien);
                orientationPanel.add(this.yOrienLab);
                orientationPanel.add(this.d_yOrien);
                orientationPanel.add(this.zOrienLab);
                orientationPanel.add(this.d_zOrien);
                dlgPane.add((Component)orientationPanel, "span");
            }
        }
        if (this.propsAffected(DrawProps.NORMAL_SOLID)) {
            Vector3d normal = props.get(DrawProps.NORMAL_SOLID);
            this.d_xNormalSolid = ValueFields.doubleFld(normal.x);
            this.d_yNormalSolid = ValueFields.doubleFld(normal.y);
            this.d_zNormalSolid = ValueFields.doubleFld(normal.z);
            if (this.propsAffected(DrawProps.DEVC)) {
                this.normalSolidLab = new guiLabel(Intl.intl("Normal of Solid"));
                this.xNormalSolidLab = new guiLabel(Intl.intl("X:"));
                this.yNormalSolidLab = new guiLabel(Intl.intl("Y:"));
                this.zNormalSolidLab = new guiLabel(Intl.intl("Z:"));
                rowCount = this.addRow(dlgPane, this.normalSolidLab, rowCount);
                guiPanel normalSolidPanel = new guiPanel(new MigLayout("hidemode 3, insets 0"));
                this.d_normalSolidComponents = new JComponent[]{this.normalSolidLab, normalSolidPanel};
                normalSolidPanel.add(this.xNormalSolidLab);
                normalSolidPanel.add(this.d_xNormalSolid);
                normalSolidPanel.add(this.yNormalSolidLab);
                normalSolidPanel.add(this.d_yNormalSolid);
                normalSolidPanel.add(this.zNormalSolidLab);
                normalSolidPanel.add(this.d_zNormalSolid);
                dlgPane.add((Component)normalSolidPanel, "span");
            }
        }
        if (this.propsAffected(DrawProps.HEIGHT)) {
            UnitDouble height = props.get(DrawProps.HEIGHT);
            this.d_height = ValueFields.udFld(height.getValueNoUnit(), DoubleVR.above(0.0, true), height.getUnit(), UnitSystem.getSource(0));
            rowCount = this.addRow(dlgPane, new guiLabel(Intl.intl("Height: ")), rowCount);
            dlgPane.add(this.d_height);
        }
        if (this.propsAffected(DrawProps.THICKNESS)) {
            this.d_thick = ValueFields.udFld(props.get(DrawProps.THICKNESS), UnitSystem.getSource(0));
            rowCount = this.addRow(dlgPane, new guiLabel(thicknessDesc + ":"), rowCount);
            dlgPane.add(this.d_thick, "span");
        }
        if (this.propsAffected(DrawProps.SURFACE)) {
            this.d_surfCombo = new SurfaceComboBox(mediator.getSurfaceMgr(), props.get(DrawProps.SURFACE));
            this.d_surfCombo.setFilter(surfFilter);
            if (this.propsAffected(DrawProps.SPECIFY_SURFACE)) {
                this.d_cbSpecifySurf = new guiCheckBox(Intl.intl("Apply Surface"), (boolean)props.get(DrawProps.SPECIFY_SURFACE));
                LinkStatus.link((AbstractButton)this.d_cbSpecifySurf, this.d_surfCombo);
            }
            lblComp = this.d_cbSpecifySurf != null ? this.d_cbSpecifySurf : new guiLabel(Intl.intl("Surface:"));
            rowCount = this.addRow(dlgPane, lblComp, rowCount);
            dlgPane.add((Component)this.d_surfCombo, "width min:pref:pref");
        } else if (this.propsAffected(DrawProps.SPECIFY_SURFACE)) {
            this.d_cbSpecifySurf = new guiCheckBox(Intl.intl("Pick Surface"), (boolean)props.get(DrawProps.SPECIFY_SURFACE));
            rowCount = this.addRow(dlgPane, this.d_cbSpecifySurf, rowCount, "span");
        }
        if (this.propsAffected(DrawProps.REMOVE_TEX_UV)) {
            this.d_cbRemoveTexUV = new guiCheckBox(Intl.intl("Remove Imported Texture Coordinates"));
            this.d_cbRemoveTexUV.setToolTipText(Intl.intl("Removes imported texture coordinates from painted faces and uses default texture coordinates instead."));
            this.d_cbRemoveTexUV.setSelected(props.get(DrawProps.REMOVE_TEX_UV));
            if (this.propsAffected(DrawProps.SPECIFY_SURFACE)) {
                LinkStatus.link2((AbstractButton)this.d_cbSpecifySurf, this.d_cbRemoveTexUV);
            }
            rowCount = this.addRow(dlgPane, this.d_cbRemoveTexUV, rowCount, "span");
        }
        if (this.propsAffected(DrawProps.COLOR)) {
            this.d_cbColorSpec = new guiComboBox<Object>((T[])new Object[]{COLOR_FROM_SURF, COLOR_SPECIFY});
            this.d_cbColorSpec.setSelectedItem(props.get(DrawProps.COLOR) == null ? COLOR_FROM_SURF : COLOR_SPECIFY);
            this.d_cbColor = new ColorButton();
            this.d_cbColor.setVisible(props.get(DrawProps.COLOR) != null);
            if (props.get(DrawProps.COLOR) != null) {
                this.d_cbColor.setColor(props.get(DrawProps.COLOR));
            }
            this.d_cbColorSpec.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ToolPropertiesDlg.this.d_cbColor.setVisible(ToolPropertiesDlg.this.d_cbColorSpec.getSelectedItem().equals(COLOR_SPECIFY));
                        if (ToolPropertiesDlg.this.d_cbColor.isVisible()) {
                            ToolPropertiesDlg.this.d_cbColor.editColor();
                            ToolPropertiesDlg.this.pack();
                        }
                    }
                }
            });
            if (this.propsAffected(DrawProps.SPECIFY_COLOR)) {
                this.d_cbSpecifyColor = new guiCheckBox(Intl.intl("Apply Color"), (boolean)props.get(DrawProps.SPECIFY_COLOR));
                LinkStatus.link((AbstractButton)this.d_cbSpecifyColor, this.d_cbColorSpec, this.d_cbColor);
            }
            lblComp = this.d_cbSpecifyColor != null ? this.d_cbSpecifyColor : new guiLabel(Intl.intl("Color:"));
            rowCount = this.addRow(dlgPane, lblComp, rowCount);
            guiPanel colorPanel = new guiPanel(new MigLayout("insets 0, gap 6 0"));
            colorPanel.add(this.d_cbColorSpec);
            colorPanel.add(this.d_cbColor);
            dlgPane.add(colorPanel);
        } else if (this.propsAffected(DrawProps.SPECIFY_COLOR)) {
            this.d_cbSpecifyColor = new guiCheckBox(Intl.intl("Pick Color"), (boolean)props.get(DrawProps.SPECIFY_COLOR));
            this.d_cbColor = new ColorButton();
            LinkStatus.link((AbstractButton)this.d_cbSpecifyColor, this.d_cbColor);
            rowCount = this.addRow(dlgPane, this.d_cbSpecifyColor, rowCount);
            dlgPane.add(this.d_cbColor);
        }
        if (this.propsAffected(DrawProps.THICKEN)) {
            this.d_cbThicken.setSelected(props.get(DrawProps.THICKEN));
            rowCount = this.addRow(dlgPane, this.d_cbThicken, rowCount);
        }
        if (this.propsAffected(DrawProps.PERMIT_HOLES)) {
            this.d_cbPermitHoles.setSelected(props.get(DrawProps.PERMIT_HOLES));
            rowCount = this.addRow(dlgPane, this.d_cbPermitHoles, rowCount);
        }
        if (this.propsAffected(DrawProps.PARTICLES)) {
            this.d_editPartButton = new JButton(Intl.intl("Edit Particles") + "...");
            this.d_editPartButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Actions.editParticles((Particle)ToolPropertiesDlg.this.d_partCombo.getSelectedItem());
                    if (ToolPropertiesDlg.this.d_partCombo.getSelectedItem() == null && ToolPropertiesDlg.this.d_partCombo.getItemCount() > 0) {
                        ToolPropertiesDlg.this.d_partCombo.setSelectedIndex(0);
                    }
                    ToolPropertiesDlg.this.updatePartCloudFields();
                }
            });
            this.d_partCombo = new ParticleComboBox(mediator.getPartList(), props.get(DrawProps.PARTICLES), null);
            this.d_partCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    ToolPropertiesDlg.this.updatePartCloudFields();
                }
            });
            if (this.d_partCombo.getSelectedItem() == null && this.d_partCombo.getItemCount() > 0) {
                this.d_partCombo.setSelectedIndex(0);
            }
            rowCount = this.addRow(dlgPane, new guiLabel(Intl.intl("Particle:")), rowCount);
            dlgPane.add((Component)this.d_partCombo, "grow");
            dlgPane.add(this.d_editPartButton);
        }
        if (this.propsAffected(DrawProps.DROP_COUNT)) {
            this.d_dropCountPanel = new PartCloudEditor.DropletCountPanel(false);
            this.d_dropCountPanel.loadData(Property.of(props.get(DrawProps.DROP_COUNT)));
            rowCount = this.addRow(dlgPane, new TitleSeparator(Intl.intl("Particle Count")), rowCount, "span, grow");
            rowCount = this.addRow(dlgPane, this.d_dropCountPanel, rowCount, "gap 18, span");
        }
        if (this.propsAffected(DrawProps.INSERTION)) {
            this.d_massDensPanel = new PartCloudEditor.InsertionPanel(mediator, objStream -> Stream.of(this.d_nameFld.getText()), false);
            this.d_massDensPanel.loadData((PartCloud.IInsertion)props.get(DrawProps.INSERTION).v1, (ControlBridge)props.get(DrawProps.INSERTION).v2);
            rowCount = this.addRow(dlgPane, new TitleSeparator(Intl.intl("Insertion")), rowCount, "span, grow");
            dlgPane.add((Component)this.d_massDensPanel, "gap 18 6 0 6, span, growy 0");
            this.getButtonPanel().setBorder(BorderFactory.createEmptyBorder(0, 7, 11, 6));
        }
        if (this.propsAffected(DrawProps.INIT)) {
            this.d_initEditor = new InitEditor(mediator);
            this.d_initEditor.load(PyroSim.getApp().getMediator(), (Collection<? extends InitRegion>)Arrays.asList(this.d_props.get(DrawProps.INIT)));
            guiPanel initEditorPanel = new guiPanel(new MigLayout("insets 0, gap 6"));
            this.d_initEditor.add(initEditorPanel);
            rowCount = this.addRow(dlgPane, initEditorPanel, rowCount, "span");
        }
        if (this.propsAffected(DrawProps.DEVC)) {
            List<DevicePnl<? extends IDevice>> panels = ToolPropertiesDlg.getDevicePanels(mediator, props);
            final CardLayout devcPnlCards = new CardLayout();
            final guiPanel devcPnl = new guiPanel(devcPnlCards);
            for (DevicePnl<? extends IDevice> devicePnl : panels) {
                devcPnl.add(devicePnl, devicePnl.getDevcType().getName());
                devicePnl.setEnabled(false);
            }
            this.d_devcTypeCB = new guiComboBox<DevicePnl<? extends IDevice>>((Collection<DevicePnl<? extends IDevice>>)panels);
            this.d_devcTypeCB.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = -1242870236787131484L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    DevicePnl pnl = (DevicePnl)value;
                    this.setText(pnl.getDevcEditor().getDesc());
                    return this;
                }
            });
            this.d_devcTypeCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    block7: {
                        boolean enabled;
                        boolean bl = enabled = e.getStateChange() == 1;
                        if (e.getItem() != null) {
                            ((DevicePnl)e.getItem()).setEnabled(enabled);
                        }
                        if (e.getStateChange() != 1) break block7;
                        DevicePnl<? extends IDevice> pnl = ToolPropertiesDlg.this.d_devcTypeCB.getSelectedItem();
                        devcPnlCards.show(devcPnl, pnl.getDevcType().getName());
                        if (pnl.getDevcType() == SolidPointMeasurer.class) {
                            for (JComponent orientComp : ToolPropertiesDlg.this.d_orientComponents) {
                                orientComp.setVisible(false);
                            }
                            for (JComponent normalSolidComp : ToolPropertiesDlg.this.d_normalSolidComponents) {
                                normalSolidComp.setVisible(true);
                            }
                        } else {
                            for (JComponent orientComp : ToolPropertiesDlg.this.d_orientComponents) {
                                orientComp.setVisible(true);
                            }
                            for (JComponent normalSolidComp : ToolPropertiesDlg.this.d_normalSolidComponents) {
                                normalSolidComp.setVisible(false);
                            }
                        }
                    }
                }
            });
            IDevice template = props.get(DrawProps.DEVC);
            if (template != null) {
                for (DevicePnl<? extends IDevice> devicePnl : panels) {
                    if (!devicePnl.getDevcType().isInstance(template)) continue;
                    devicePnl.load(Arrays.asList(template));
                    this.d_devcTypeCB.setSelectedItem(devicePnl);
                    break;
                }
            }
            rowCount = this.addRow(dlgPane, new guiLabel(Intl.intl("Device Type:")), rowCount);
            dlgPane.add(this.d_devcTypeCB, "span");
            rowCount = this.addRow(dlgPane, new JSeparator(), rowCount, "span, grow");
            dlgPane.add((Component)devcPnl, "span");
        }
        if (this.propsAffected(DrawProps.CELL_TYPE, DrawProps.CELL_SIZE, DrawProps.CELL_COUNT)) {
            this.d_fixedCellCountRB = new guiRadioButton(Intl.intl("Fixed Count:"));
            this.d_fixedCellSizeRB = new guiRadioButton(Intl.intl("Fixed Size:"));
            this.d_cellCountX = ValueFields.intFld(props.get(DrawProps.CELL_COUNT)[0], IntVR.above(0, false));
            this.d_cellCountY = ValueFields.intFld(props.get(DrawProps.CELL_COUNT)[1], IntVR.above(0, false));
            this.d_cellCountZ = ValueFields.intFld(props.get(DrawProps.CELL_COUNT)[2], IntVR.above(0, false));
            this.d_cellSizeX = ValueFields.udFld(props.get(DrawProps.CELL_SIZE)[0], UnitDoubleVR.above(0.0, SI.METER, false), UnitSystem.getSource(0));
            this.d_cellSizeY = ValueFields.udFld(props.get(DrawProps.CELL_SIZE)[1], UnitDoubleVR.above(0.0, SI.METER, false), UnitSystem.getSource(0));
            this.d_cellSizeZ = ValueFields.udFld(props.get(DrawProps.CELL_SIZE)[2], UnitDoubleVR.above(0.0, SI.METER, false), UnitSystem.getSource(0));
            guiLabel cx = new guiLabel(Intl.intl("X:"));
            guiLabel cy = new guiLabel(Intl.intl("Y:"));
            guiLabel cz = new guiLabel(Intl.intl("Z:"));
            guiLabel sx = new guiLabel(Intl.intl("X:"));
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Y:"));
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Z:"));
            new guiButtonGroup(this.d_fixedCellCountRB, this.d_fixedCellSizeRB);
            LinkStatus.link((AbstractButton)this.d_fixedCellCountRB, cx, this.d_cellCountX, cy, this.d_cellCountY, cz, this.d_cellCountZ);
            LinkStatus.link((AbstractButton)this.d_fixedCellSizeRB, sx, this.d_cellSizeX, guiLabel2, this.d_cellSizeY, guiLabel3, this.d_cellSizeZ);
            guiPanel gridPanel = new guiPanel();
            GridBagHelper gb2 = new GridBagHelper(gridPanel);
            gb2.addFilledRow(new TitleSeparator(Intl.intl("Cells")));
            gb2.addIdentRow(this.d_fixedCellSizeRB, sx, this.d_cellSizeX, guiLabel2, this.d_cellSizeY, guiLabel3, this.d_cellSizeZ, 0);
            gb2.addIdentRow(this.d_fixedCellCountRB, cx, this.d_cellCountX, cy, this.d_cellCountY, cz, this.d_cellCountZ, 0);
            gb2.finalizeRows();
            rowCount = this.addRow(dlgPane, gridPanel, rowCount, "span");
            if (props.get(DrawProps.CELL_TYPE) == DrawProps.MeshCellType.FIXED_COUNT) {
                this.d_fixedCellCountRB.setSelected(true);
            } else {
                this.d_fixedCellSizeRB.setSelected(true);
            }
        }
        if (this.propsAffected(DrawProps.REFINEMENT_AMOUNT)) {
            this.d_refinementAmountCB = guiUtil.newCombo(refinementAmount -> new Pair<String, String>(refinementAmount.getName(), refinementAmount.getDesc()), GridRefinement.RefinementAmount.values());
            this.d_refinementAmountCB.setSelectedItem((Object)props.get(DrawProps.REFINEMENT_AMOUNT));
            rowCount = this.addRow(dlgPane, new guiLabel(Intl.intl("Refinement Amount:")), rowCount);
            dlgPane.add(this.d_refinementAmountCB, "span");
        }
        if (this.propsAffected(DrawProps.AXIS)) {
            ArrayList<Geometry.Axis> axes = new ArrayList<Geometry.Axis>();
            axes.add(null);
            axes.addAll(Arrays.asList(Geometry.Axis.values()));
            this.d_axisCB = new guiComboBox(axes);
            this.d_axisCB.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = -5308765187220589086L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value == null) {
                        this.setText(Intl.intl("Automatic"));
                    }
                    return this;
                }
            });
            rowCount = this.addRow(dlgPane, new guiLabel(Intl.intl("Axis:")), rowCount);
            dlgPane.add(this.d_axisCB, "span");
            this.d_axisCB.setSelectedItem((Object)props.get(DrawProps.AXIS));
        }
        if (this.propsAffected(DrawProps.SLICE_QUANTITY)) {
            this.d_sliceQuantityCB = new QuantityComboBox(128L, new QuantityType[0]);
            this.d_sliceQuantityCB.setSelectedItem(props.get(DrawProps.SLICE_QUANTITY));
            rowCount = this.addRow(dlgPane, new guiLabel(Intl.intl("Quantity:")), rowCount);
            dlgPane.add((Component)this.d_sliceQuantityCB, "span");
        }
        if (this.propsAffected(DrawProps.SLICE_VECTOR)) {
            this.d_sliceVectorCB = new guiCheckBox(Intl.intl("Include Vectors"), (boolean)props.get(DrawProps.SLICE_VECTOR));
            rowCount = this.addRow(dlgPane, this.d_sliceVectorCB, rowCount, "span");
        }
        if (this.propsAffected(DrawProps.SLICE_CENTERED)) {
            this.d_sliceCenteredCB = new guiCheckBox(Intl.intl("Cell Centered"), (boolean)props.get(DrawProps.SLICE_CENTERED));
            rowCount = this.addRow(dlgPane, this.d_sliceCenteredCB, rowCount, "span");
        }
        if (this.d_partCombo != null) {
            this.updatePartCloudFields();
        }
    }

    private int addRow(JPanel panel, Component component, int rowCount) {
        return this.addRow(panel, component, rowCount, "");
    }

    private int addRow(JPanel panel, Component component, int rowCount, String constraints) {
        if (rowCount > 0) {
            constraints = (String)constraints + ", newline";
        }
        assert (panel.getLayout() instanceof MigLayout);
        panel.add(component, constraints);
        return rowCount + 1;
    }

    private boolean isBurnAway(SurfaceComboBox box) {
        Surface surf = (Surface)box.getSelectedItem();
        if (surf != null && surf.getSurfDesc() instanceof LayeredSurfDesc) {
            LayeredSurfDesc desc = (LayeredSurfDesc)surf.getSurfDesc();
            return desc.d_burnAway;
        }
        return false;
    }

    private static List<DevicePnl<? extends IDevice>> getDevicePanels(PyroMod pyMod, DrawProps props) {
        ArrayList<DevicePnl<? extends IDevice>> panels = new ArrayList<DevicePnl<? extends IDevice>>();
        for (Class<? extends IDevice> devcType : ToolPropertiesDlg.getPointDevcTypes(pyMod)) {
            IDevcEditor<? extends IDevice> editor = DevcEditorFactory.create(pyMod, devcType, IDevcEditor.Mode.CREATE, 0);
            if (editor == null) continue;
            DevicePnl<? extends IDevice> pnl = new DevicePnl<IDevice>(pyMod, devcType, editor, 0);
            panels.add(pnl);
        }
        Collections.sort(panels, new Comparator<DevicePnl<? extends IDevice>>(){

            @Override
            public int compare(DevicePnl<? extends IDevice> o1, DevicePnl<? extends IDevice> o2) {
                return o1.getDevcEditor().getDesc().compareToIgnoreCase(o2.getDevcEditor().getDesc());
            }
        });
        return panels;
    }

    protected static Collection<Class<? extends IDevice>> getPointDevcTypes(PyroMod domain) {
        return theUtil.filter(DevcEditorFactory.getAllDevcTypes(), Class.class, new Predicate<Class>(){

            @Override
            public boolean test(Class o) {
                return IFreePointDevice.class.isAssignableFrom(o) || IAttachedPointDevice.class.isAssignableFrom(o);
            }
        });
    }

    private boolean propsAffected(DrawProps.Prop ... props) {
        return this.d_propTypes.containsAll(Arrays.asList(props));
    }

    protected void updatePartCloudFields() {
        boolean geom3d;
        boolean massless = this.d_partCombo.getSelectedItem() != null && ((Particle)this.d_partCombo.getSelectedItem()).isType(Particle.Type.TRACER);
        boolean bl = geom3d = this.d_props.get(DrawProps.GEOM_SPACE) == DrawProps.GeomSpace.S3D;
        if (this.d_massDensPanel != null) {
            this.d_massDensPanel.updateEnabled(Property.of(massless), Property.of(geom3d));
        }
        if (this.d_dropCountPanel != null) {
            this.d_dropCountPanel.updateEnabled(Property.of(massless), Property.of(geom3d));
        }
        if (this.d_movementTitle != null) {
            this.d_movementTitle.setEnabled(!massless);
        }
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.propsAffected(DrawProps.NAME) && this.d_nameFld.getText().trim().isEmpty()) {
            if (showWarn) {
                this.showMessageBox(Intl.intl("The name must not be empty."));
            }
            if (allowModify) {
                this.d_nameFld.selectAll();
                this.d_nameFld.requestFocus();
            }
            return false;
        }
        if (this.propsAffected(DrawProps.PARTICLES) && this.d_partCombo.getSelectedItem() == null) {
            this.showMessageBox(Intl.intl("A particle must be chosen."));
            return false;
        }
        return true;
    }

    public void saveProps() {
        Collection<? extends IDevice> devices;
        Optional<DevicePnl<? extends IDevice>> pnl;
        if (this.propsAffected(DrawProps.NAME)) {
            this.d_props.set(new DrawProps.Prop(this.d_nameKey), this.d_nameFld.getText());
        }
        if (this.propsAffected(DrawProps.LOCATION)) {
            this.d_props.set(DrawProps.LOCATION, (UnitDouble)this.d_location.getValue());
        }
        if (this.propsAffected(DrawProps.ORIENTATION)) {
            this.d_props.set(DrawProps.ORIENTATION, new Vector3d((Double)this.d_xOrien.getValue(), (Double)this.d_yOrien.getValue(), (Double)this.d_zOrien.getValue()));
        }
        if (this.propsAffected(DrawProps.NORMAL_SOLID)) {
            this.d_props.set(DrawProps.NORMAL_SOLID, new Vector3d((Double)this.d_xNormalSolid.getValue(), (Double)this.d_yNormalSolid.getValue(), (Double)this.d_zNormalSolid.getValue()));
        }
        if (this.propsAffected(DrawProps.HEIGHT)) {
            this.d_props.set(DrawProps.HEIGHT, (UnitDouble)this.d_height.getValue());
        }
        if (this.propsAffected(DrawProps.THICKNESS)) {
            this.d_props.set(DrawProps.THICKNESS, (UnitDouble)this.d_thick.getValue());
        }
        if (this.propsAffected(DrawProps.SPECIFY_SURFACE)) {
            this.d_props.set(DrawProps.SPECIFY_SURFACE, this.d_cbSpecifySurf.isSelected());
        }
        if (this.propsAffected(DrawProps.REMOVE_TEX_UV)) {
            this.d_props.set(DrawProps.REMOVE_TEX_UV, this.d_cbRemoveTexUV.isSelected());
        }
        if (this.propsAffected(DrawProps.SURFACE)) {
            this.d_props.set(DrawProps.SURFACE, (Surface)this.d_surfCombo.getSelectedItem());
        }
        if (this.propsAffected(DrawProps.SPECIFY_COLOR)) {
            this.d_props.set(DrawProps.SPECIFY_COLOR, this.d_cbSpecifyColor.isSelected());
            if (this.d_cbSpecifyColor.isSelected()) {
                this.d_props.set(DrawProps.COLOR, this.d_cbColor.getColor());
            } else {
                this.d_props.set(DrawProps.COLOR, null);
            }
        }
        if (this.propsAffected(DrawProps.COLOR)) {
            if (this.d_cbColorSpec.getSelectedItem() == COLOR_FROM_SURF) {
                this.d_props.set(DrawProps.COLOR, null);
            } else {
                this.d_props.set(DrawProps.COLOR, this.d_cbColor.getColor());
            }
        }
        if (this.propsAffected(DrawProps.THICKEN)) {
            this.d_props.set(DrawProps.THICKEN, this.d_cbThicken.isSelected());
        }
        if (this.propsAffected(DrawProps.PERMIT_HOLES)) {
            this.d_props.set(DrawProps.PERMIT_HOLES, this.d_cbPermitHoles.isSelected());
        }
        if (this.propsAffected(DrawProps.PARTICLES)) {
            this.d_props.set(DrawProps.PARTICLES, (Particle)this.d_partCombo.getSelectedItem());
        }
        if (this.propsAffected(DrawProps.INSERTION)) {
            this.d_props.set(DrawProps.INSERTION, this.d_massDensPanel.saveData());
        }
        if (this.propsAffected(DrawProps.DROP_COUNT)) {
            this.d_props.set(DrawProps.DROP_COUNT, this.d_dropCountPanel.saveData().get());
        }
        if (this.propsAffected(DrawProps.INIT)) {
            this.d_initEditor.save(PyroSim.getApp().getMediator(), (Collection<? extends InitRegion>)Arrays.asList(this.d_props.get(DrawProps.INIT)));
        }
        if (this.propsAffected(DrawProps.DEVC) && (pnl = DeviceEditorUtil.getSelectedItemOrEmpty(this.d_devcTypeCB)).isPresent() && (devices = pnl.get().save(null)).size() == 1) {
            IDevice protoDevc = devices.stream().findFirst().orElseGet(null);
            protoDevc.setName(pnl.get().getDevcEditor().getDefName());
            this.d_props.set(DrawProps.DEVC, protoDevc);
        }
        if (this.propsAffected(DrawProps.CELL_TYPE, DrawProps.CELL_SIZE, DrawProps.CELL_COUNT)) {
            DrawProps.MeshCellType cellType = this.d_fixedCellCountRB.isSelected() ? DrawProps.MeshCellType.FIXED_COUNT : DrawProps.MeshCellType.FIXED_SIZE;
            this.d_props.set(DrawProps.CELL_TYPE, cellType);
            if (cellType == DrawProps.MeshCellType.FIXED_COUNT) {
                int[] counts = new int[]{(Integer)this.d_cellCountX.getValue(), (Integer)this.d_cellCountY.getValue(), (Integer)this.d_cellCountZ.getValue()};
                this.d_props.set(DrawProps.CELL_COUNT, counts);
            } else {
                UnitDouble[] sizes = new UnitDouble[]{(UnitDouble)this.d_cellSizeX.getValue(), (UnitDouble)this.d_cellSizeY.getValue(), (UnitDouble)this.d_cellSizeZ.getValue()};
                this.d_props.set(DrawProps.CELL_SIZE, sizes);
            }
        }
        if (this.propsAffected(DrawProps.REFINEMENT_AMOUNT)) {
            GridRefinement.RefinementAmount refinementAmount = this.d_refinementAmountCB.getSelectedItem();
            this.d_props.set(DrawProps.REFINEMENT_AMOUNT, refinementAmount);
        }
        if (this.propsAffected(DrawProps.AXIS)) {
            this.d_props.set(DrawProps.AXIS, this.d_axisCB.getSelectedItem());
        }
        if (this.propsAffected(DrawProps.SLICE_QUANTITY)) {
            this.d_props.set(DrawProps.SLICE_QUANTITY, (IQuantity)this.d_sliceQuantityCB.getSelectedItem());
        }
        if (this.propsAffected(DrawProps.SLICE_VECTOR)) {
            this.d_props.set(DrawProps.SLICE_VECTOR, this.d_sliceVectorCB.isSelected());
        }
        if (this.propsAffected(DrawProps.SLICE_CENTERED)) {
            this.d_props.set(DrawProps.SLICE_CENTERED, this.d_sliceCenteredCB.isSelected());
        }
    }
}

