/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.swing.SwingUtilities;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.mv.gui.ColorUtil;
import pyrosim.treeview.PyroTreeCellRenderer;
import thunderheadeng.gui.ColorIcon;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HoverWindow;
import thunderheadeng.gui.guiLabel;

public class SurfaceHover
extends HoverWindow {
    private static final long serialVersionUID = 6893727412437978513L;
    private Memento d_lastSettings;

    public SurfaceHover(Component parent) {
        this(SwingUtilities.getWindowAncestor(parent), parent);
    }

    public SurfaceHover(Window window, Component parent) {
        super(window, parent);
    }

    public void update(String title, boolean pickSurf, Surface surf, boolean pickColor, Color color) {
        this.d_lastSettings = new Memento(title, pickSurf, surf, pickColor, color);
        if (!pickSurf && !pickColor) {
            this.setVisible(false);
            return;
        }
        this.getContentPane().removeAll();
        GridBagHelper gb = new GridBagHelper(this.getContentPane());
        gb.rowSpace = 2;
        gb.addRow("<html><b>" + title + "</b></html>", 0);
        gb.indent();
        if (pickSurf) {
            guiLabel lbl = new guiLabel();
            Memento lastSettings = this.d_lastSettings.clone();
            Runnable updateAgain = () -> {
                if (Objects.equals(lastSettings, this.d_lastSettings)) {
                    this.update(lastSettings.title, lastSettings.pickColor, (Surface)lastSettings.surf.get(), lastSettings.pickColor, lastSettings.color);
                }
            };
            PyroTreeCellRenderer.decorateLabel(PyroSim.getApp().getMediator(), updateAgain, lbl, surf);
            gb.addRow(Intl.intl("Surface:"), lbl, 0);
        }
        if (pickColor) {
            String name = ColorUtil.format(color);
            guiLabel label = new guiLabel(name);
            if (color != null) {
                label.setIcon(new ColorIcon(color, 16, 16, 3));
            }
            gb.addRow(Intl.intl("Color:"), label, 0);
        }
        gb.finalizeRows();
        this.pack();
        this.setVisible(true);
        this.repaint();
    }

    private static class Memento
    implements Cloneable {
        public final String title;
        public final boolean pickSurf;
        public final WeakReference<Surface> surf;
        public final boolean pickColor;
        public final Color color;

        public Memento(String title, boolean pickSurf, Surface surf, boolean pickColor, Color color) {
            this.title = title;
            this.pickSurf = pickSurf;
            this.surf = new WeakReference<Surface>(surf);
            this.pickColor = pickColor;
            this.color = color;
        }

        protected Memento clone() {
            try {
                return (Memento)super.clone();
            }
            catch (CloneNotSupportedException e) {
                assert (false);
                return null;
            }
        }

        public int hashCode() {
            int h = Objects.hash(this.color, this.pickColor, this.surf, this.title);
            Surface s = (Surface)this.surf.get();
            return Objects.hash(h, s);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Memento other = (Memento)obj;
            Surface surf1 = (Surface)this.surf.get();
            Surface surf2 = (Surface)other.surf.get();
            return Objects.equals(this.color, other.color) && this.pickColor == other.pickColor && this.pickSurf == other.pickSurf && Objects.equals(surf1, surf2) && Objects.equals(this.title, other.title);
        }
    }
}

