/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.domain.INamed;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.mv.displays.IPyroDisplay;
import pyrosim.mv.displays.RenderTarget;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.INativeDisplayProps;
import thunderheadeng.scene3d.nativebuffered.Object3D;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.text.EmptyTextSrc;
import thunderheadeng.scene3d.text.IDisplayableTextSrc;
import thunderheadeng.scene3d.text.RenderFont;
import thunderheadeng.scene3d.text.RenderString;
import thunderheadeng.scene3d.text.TextAttrs;

public class NameDisplay
extends GeomDisplay
implements IPyroDisplay {
    private static final long serialVersionUID = 3301429217063736864L;
    public final INamed d_object;
    private final Object3D d_objDisplay;
    private final RenderString.Offset d_parentOffset;
    private Color d_color = Color.GREEN;
    private boolean d_selected = false;
    private Point3d d_anchor = GeomConstants.PNT3D_ORIGIN;

    public NameDisplay(INativeDisplayProps nprops, INamed object, Object3D objDisplay, RenderString.Offset parentOffset) {
        super(nprops, (IDisplayableGeomSrc)EmptyDisplayGeomSrc.INSTANCE, EmptyTextSrc.INSTANCE);
        this.d_object = object;
        this.d_objDisplay = objDisplay;
        this.d_parentOffset = parentOffset;
        this.setTextSource(new TextSrc());
    }

    protected String format(INamed object) {
        return object.getName();
    }

    public INamed getObject() {
        return this.d_object;
    }

    public void setAnchor(Point3d anchor) {
        if (this.d_anchor.equals(anchor)) {
            return;
        }
        this.d_anchor = anchor;
        this.update();
    }

    public void setColor(Color color) {
        if (this.d_color.equals(color)) {
            return;
        }
        this.d_color = color;
        this.update();
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected == this.d_selected) {
            return;
        }
        this.d_selected = selected;
        this.update();
    }

    @Override
    public void getDisplayObjs(RenderTarget target, Collection<? super IDisplayable> displays) {
        switch (target) {
            case NORMAL: {
                displays.add(this);
                break;
            }
        }
    }

    @Override
    public void getAll(Consumer<Object> result, IIsectFilter filter) {
    }

    @Override
    public AABox getBounds() {
        return new AABox();
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull region) {
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
    }

    private static class EmptyDisplayGeomSrc
    implements IDisplayableGeomSrc {
        private static final EmptyDisplayGeomSrc INSTANCE = new EmptyDisplayGeomSrc();

        private EmptyDisplayGeomSrc() {
        }

        @Override
        public AABox getBounds() {
            return new AABox();
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps props) {
            return DisplayGeom.EMPTY;
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public void setVisible(boolean visible) {
        }
    }

    private class TextSrc
    implements IDisplayableTextSrc {
        private static final TextAttrs ATTRS = new TextAttrs(new RenderFont(12.0f, RenderFont.Mode.MODE_2D), true);
        private static final int[] PADDING = new int[]{10, 10, 10, 10};

        private TextSrc() {
        }

        @Override
        public List<RenderString> getStrings(IDisplayProps displayProps) {
            return List.of(new RenderString(NameDisplay.this.format(NameDisplay.this.d_object), NameDisplay.this.d_selected ? Color.YELLOW : NameDisplay.this.d_color, GeomConstants.IDENTITY4d, RenderString.Justification.LEFT, NameDisplay.this.d_anchor, PADDING, NameDisplay.this.d_objDisplay, NameDisplay.this.d_parentOffset));
        }

        @Override
        public TextAttrs getAttrs() {
            return ATTRS;
        }
    }
}

