/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSimColors;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.hvac.HvacAircoil;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacFan;
import pyrosim.domain.hvac.IHvacGeomComp;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.APyroDisplayMgr;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.GeomDisplayMgr;
import pyrosim.mv.displays.IPyroDisplayMgr;
import pyrosim.mv.displays.NameDisplay;
import pyrosim.mv.displays.RenderTarget;
import thunderheadeng.scene3d.nativebuffered.INativeDisplayProps;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.Object3D;
import thunderheadeng.scene3d.text.RenderString;

public class LabelMgr
extends APyroDisplayMgr<IPyroGeomSrc, NameDisplay> {
    private final GeomDisplayMgr[] d_baseMgrs;

    public LabelMgr(PyroMod mod, ModelView mv, ModelScene scene, DisplayFilter df, IPyroDisplayMgr.ObjFilter<IPyroGeomSrc> filter, GeomDisplayMgr ... baseMgrs) {
        super(mod, mv, LabelMgr.newSceneMap(scene), df, filter);
        this.d_baseMgrs = baseMgrs;
    }

    private Color getTextColor(PyroSimColors colors) {
        return colors.getColor(PyroSimColors.TEXT_COLOR);
    }

    public void updateColors(PyroSimColors colors) {
        Color c = this.getTextColor(colors);
        for (NameDisplay disp : this.getDisplayMap().values()) {
            disp.setColor(c);
        }
    }

    @Override
    protected Collection<? extends Class<?>> getFilterTypes() {
        ArrayList types = new ArrayList();
        types.add(Filter.class);
        types.addAll(super.getFilterTypes());
        return types;
    }

    @Override
    protected void filterChanged(DisplayFilter filter, Class type) {
        this.updateAll();
    }

    @Override
    public void addAll() {
        Predicate filter = this.getObjFilter().toArbitraryPredicate();
        this.addDisplays(this.getMediator().getDevices().flatten(filter));
        this.addDisplays(this.getMediator().getObstructions().flatten(IHvacGeomComp.class, filter));
        this.addDisplays(this.getMediator().getZoneMgr().getSpecifiedZones());
    }

    @Override
    protected NameDisplay createDisplay(IPyroGeomSrc obj, boolean visible, boolean selected) {
        NameDisplay nameDisplay;
        GeomDisplayMgr mgr;
        assert (obj instanceof INamed);
        GeomDisplayMgr.CapDisplay baseDisp = null;
        GeomDisplayMgr[] geomDisplayMgrArray = this.d_baseMgrs;
        int n = geomDisplayMgrArray.length;
        for (int i = 0; i < n && (baseDisp = (GeomDisplayMgr.CapDisplay)(mgr = geomDisplayMgrArray[i]).getDisplay(obj)) == null; ++i) {
        }
        if (baseDisp == null) {
            return null;
        }
        ArrayList baseDisplays = new ArrayList(1);
        baseDisp.getDisplayObjs(RenderTarget.NORMAL, baseDisplays);
        Optional<Object3D> display = baseDisplays.stream().filter(o -> o instanceof Object3D).map(o -> (Object3D)((Object)o)).findFirst();
        if (obj instanceof HvacDuct) {
            HvacDuct duct = (HvacDuct)obj;
            nameDisplay = new DuctDisplay((INativeDisplayProps)this.getMV().getDrawProps(), duct, display.orElse(null));
        } else {
            nameDisplay = new NameDisplay((INativeDisplayProps)this.getMV().getDrawProps(), (INamed)((Object)obj), display.orElse(null), RenderString.Offset.CENTER);
        }
        NameDisplay rend = nameDisplay;
        rend.setColor(this.getTextColor(this.getMV().getColors()));
        rend.setVisible(visible);
        rend.setSelected(selected);
        return rend;
    }

    @Override
    protected boolean isFiltered(Object obj) {
        return this.getFilter().isFilteringAllOf(Filter.class) || this.getFilter().isFilteringAllOf(obj.getClass());
    }

    @Override
    protected boolean isVisible(IPyroGeomSrc obj) {
        return obj.isEnabled() && obj.isVisible() && !this.isFiltered(obj);
    }

    public static class Filter {
    }

    protected static class DuctDisplay
    extends NameDisplay {
        private static final long serialVersionUID = -5491893122417485607L;

        public DuctDisplay(INativeDisplayProps nprops, HvacDuct duct, Object3D ductDisp) {
            super(nprops, duct, ductDisp, RenderString.Offset.CENTER);
            this.setAnchor(new Point3d(0.5, 0.0, 0.5));
        }

        @Override
        protected String format(INamed object) {
            HvacDuct duct = (HvacDuct)this.getObject();
            Object txt = duct.getName();
            HvacDuct.AirflowObj airflow = (HvacDuct.AirflowObj)((Object)duct.getProp("opt_none_damper_fan"));
            if (airflow != HvacDuct.AirflowObj.NONE) {
                txt = (String)txt + "/";
                switch (airflow) {
                    case AIRCOIL: {
                        txt = (String)txt + ((HvacAircoil)duct.getProp("AIRCOIL_ID")).getName();
                        break;
                    }
                    case FAN: {
                        txt = (String)txt + ((HvacFan)duct.getProp("FAN_ID")).getName();
                        break;
                    }
                    case DAMPER: {
                        txt = (String)txt + Intl.intl("Damper");
                        break;
                    }
                    case VOLFLOW: {
                        txt = (String)txt + Intl.intl("Volume Flow");
                        break;
                    }
                }
            }
            return txt;
        }
    }
}

