/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.hvac.HvacDevice;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.devices.sprayers.DryPipe;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.zones.Zone;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.APyroDisplayMgr;
import pyrosim.mv.displays.ClippingManager;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.EventResult;
import pyrosim.mv.displays.FloorDisplayManager;
import pyrosim.mv.displays.GeomDisplayMgr;
import pyrosim.mv.displays.GridDisplayManager;
import pyrosim.mv.displays.IPyroDisplay;
import pyrosim.mv.displays.IPyroDisplayMgr;
import pyrosim.mv.displays.LabelMgr;
import pyrosim.mv.displays.RenderTarget;
import pyrosim.mv.displays.TextDisplayMgr;
import thunderheadeng.geometry.RTreef;
import thunderheadeng.scene3d.IDisplayMgr;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.scene3d.transformpreview.CompositeTransformPreview;
import thunderheadeng.scene3d.transformpreview.ITransformPreview;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theUtil;

public class DisplayManager
implements IPyroDisplayMgr<Object> {
    private final PyroMod d_domain;
    private final ModelView d_mv;
    private final ModelScene d_scene;
    private final ModelScene d_patchScene;
    private final ModelScene d_backgroundScene;
    private final ModelScene d_gridScene;
    public final DisplayFilter d_dispFilter;
    public final GridDisplayManager d_gridDispMan;
    public final FloorDisplayManager d_floorDispMan;
    public final GeomDisplayMgr d_geomDispMan;
    public final TextDisplayMgr d_textDispMan;
    public final LabelMgr d_labelMan;
    public final GeomDisplayMgr d_patchDispMan;
    public final GeomDisplayMgr d_clipDispMan;
    public final GeomDisplayMgr d_exClipDispMan;
    private IPyroDisplayMgr<?>[] d_allManagers;

    public DisplayManager(PyroMod domain, ModelView mv, ModelScene mainScene, ModelScene capsScene, ModelScene patchScene, ModelScene backgroundScene, ModelScene gridScene, ModelScene clippingDisplayScene, ModelScene excludedClippingDisplayScene) {
        this.d_domain = domain;
        this.d_mv = mv;
        this.d_scene = mainScene;
        this.d_patchScene = patchScene;
        this.d_backgroundScene = backgroundScene;
        this.d_gridScene = gridScene;
        this.d_dispFilter = new DisplayFilter();
        this.d_gridDispMan = new GridDisplayManager(domain, mainScene, mv, this.d_dispFilter);
        this.d_floorDispMan = new FloorDisplayManager(domain, patchScene, mv, this.d_dispFilter);
        TypeFilter<IPyroGeomSrc> patchFilter = new TypeFilter<IPyroGeomSrc>(Vent.class, FlowMeasurer.class);
        TypeFilter<IPyroGeomSrc> noclipFilter = new TypeFilter<IPyroGeomSrc>(SectionBox.class);
        TypeFilter<IPyroGeomSrc> exNoclipFilter = new TypeFilter<IPyroGeomSrc>(CameraState.class);
        Predicate<IPyroGeomSrc> geomFilter = patchFilter.or(noclipFilter).or(exNoclipFilter).negate();
        APyroDisplayMgr.TargetSceneMap geomSceneMap = t -> {
            switch (t) {
                case NORMAL: {
                    return Optional.of(mainScene);
                }
                case CLIP_CAPS: {
                    return Optional.ofNullable(capsScene);
                }
            }
            return Optional.empty();
        };
        this.d_geomDispMan = new GeomDisplayMgr(domain, mv, geomSceneMap, mv.getDrawProps(), this.d_dispFilter, geomFilter);
        this.d_textDispMan = new TextDisplayMgr(domain, mv, geomSceneMap, mv.getDrawProps(), this.d_dispFilter, Predicates.alwaysTrue());
        APyroDisplayMgr.TargetSceneMap patchSceneMap = GeomDisplayMgr.newSceneMap(patchScene);
        this.d_patchDispMan = new GeomDisplayMgr(domain, mv, patchSceneMap, mv.getDrawProps(), this.d_dispFilter, patchFilter);
        APyroDisplayMgr.TargetSceneMap clippingSceneMap = GeomDisplayMgr.newSceneMap(clippingDisplayScene);
        this.d_clipDispMan = new GeomDisplayMgr(domain, mv, clippingSceneMap, mv.getDrawProps(), this.d_dispFilter, noclipFilter);
        APyroDisplayMgr.TargetSceneMap exClippingSceneMap = GeomDisplayMgr.newSceneMap(excludedClippingDisplayScene);
        this.d_exClipDispMan = new GeomDisplayMgr(domain, mv, exClippingSceneMap, mv.getDrawProps(), this.d_dispFilter, exNoclipFilter);
        IPyroDisplayMgr.ObjFilter<IPyroGeomSrc> labelFilter = new IPyroDisplayMgr.ObjFilter<IPyroGeomSrc>(IPyroGeomSrc.class, new TypeFilter(IDevice.class, HvacNode.class, HvacDuct.class, Zone.class), HvacDevice.class, DryPipe.class);
        this.d_labelMan = new LabelMgr(domain, mv, mainScene, this.d_dispFilter, labelFilter, this.d_geomDispMan, this.d_patchDispMan);
        ArrayList<APyroDisplayMgr> mgrs = new ArrayList<APyroDisplayMgr>();
        mgrs.addAll(Arrays.asList(this.d_gridDispMan, this.d_floorDispMan, this.d_geomDispMan, this.d_textDispMan, this.d_patchDispMan, this.d_clipDispMan, this.d_exClipDispMan, this.d_labelMan));
        this.d_allManagers = theUtil.toArray(mgrs, IPyroDisplayMgr.class);
    }

    @Override
    public Optional<RTreef<Object>> getSearchTree() {
        return Optional.empty();
    }

    public GridMergeUtil.MergeResult getMergedGrids() {
        return this.d_geomDispMan.getGridBoundaries();
    }

    public void updateMode(ModelView.IViewMode mode) {
        if (mode instanceof ModelView.ViewMode2D) {
            this.d_floorDispMan.setScene(FloorDisplayManager.newSceneMap(this.d_backgroundScene));
            this.d_gridDispMan.setScene(GridDisplayManager.newSceneMap(this.d_gridScene));
        } else {
            this.d_floorDispMan.setScene(FloorDisplayManager.newSceneMap(this.d_patchScene));
            this.d_gridDispMan.setScene(GridDisplayManager.newSceneMap(this.d_scene));
        }
    }

    @Override
    public IPyroDisplayMgr.ObjFilter<Object> getObjFilter() {
        return new IPyroDisplayMgr.ObjFilter<Object>(Object.class, Filters.acceptAll(), new Class[0]);
    }

    @Override
    public void removeAll() {
        this.d_mv.getNativeDrawProps().removeAllMats(this.d_domain);
        for (IPyroDisplayMgr mgr : this.getDispManagers()) {
            mgr.removeAll();
        }
    }

    @Override
    public void addAll() {
        this.d_mv.getNativeDrawProps().addAllMats(this.d_domain);
        for (IPyroDisplayMgr mgr : this.getDispManagers()) {
            mgr.addAll();
        }
    }

    @Override
    public void processEvents(Events events, EventResult result) {
        this.d_mv.getNativeDrawProps().update(events);
        for (IPyroDisplayMgr mgr : this.getDispManagers()) {
            mgr.processEvents(events, result);
        }
    }

    @Override
    public void updateClipping(ClippingManager clipMgr) {
        for (IPyroDisplayMgr mgr : this.getDispManagers()) {
            mgr.updateClipping(clipMgr);
        }
    }

    public IPyroDisplayMgr[] getDispManagers() {
        return this.d_allManagers;
    }

    public void add(Object ... objs) {
        this.add(Arrays.asList(objs));
    }

    public void add(Collection<?> objs) {
        for (IPyroDisplayMgr<?> mgr : this.d_allManagers) {
            mgr.addDisplays(theUtil.filter(objs, mgr.getObjFilter().toArbitraryPredicate()));
        }
    }

    public void remove(Object ... objs) {
        this.remove(Arrays.asList(objs));
    }

    public void remove(Collection<?> objs) {
        for (int m = this.d_allManagers.length - 1; m >= 0; --m) {
            IPyroDisplayMgr<?> mgr = this.d_allManagers[m];
            mgr.removeDisplays(theUtil.filter(objs, mgr.getObjFilter().toArbitraryPredicate()));
        }
    }

    @Override
    public void removeFromScene(Collection<?> objs) {
        for (int m = this.d_allManagers.length - 1; m >= 0; --m) {
            IPyroDisplayMgr<?> mgr = this.d_allManagers[m];
            mgr.removeFromScene(theUtil.filter(objs, mgr.getObjFilter().toArbitraryPredicate()));
        }
    }

    @Override
    public void addToScene(Collection<?> objs) {
        for (IPyroDisplayMgr<?> mgr : this.d_allManagers) {
            mgr.addToScene(theUtil.filter(objs, mgr.getObjFilter().toArbitraryPredicate()));
        }
    }

    @Override
    public void updateVisibility(Collection<? extends Object> objs) {
        for (IPyroDisplayMgr<?> mgr : this.d_allManagers) {
            mgr.updateVisibility(theUtil.filter(objs, mgr.getObjFilter().toArbitraryPredicate()));
        }
    }

    public Collection<IDisplayable> getDisplayObjs(Object ... objs) {
        return this.getDisplayObjs(Arrays.asList(objs));
    }

    public Collection<IDisplayable> getDisplayObjs(Collection<?> objs) {
        ArrayList<IDisplayable> displays = new ArrayList<IDisplayable>(objs.size());
        for (RenderTarget target : RenderTarget.values()) {
            for (Object o : objs) {
                IPyroDisplay disp = this.getDisplay(o);
                if (disp == null) continue;
                disp.getDisplayObjs(target, displays);
            }
        }
        return displays;
    }

    @Override
    public IPyroDisplay getDisplay(Object obj) {
        for (IPyroDisplayMgr<?> mgr : this.d_allManagers) {
            IPyroDisplay disp = mgr.getDisplay(obj);
            if (disp == null) continue;
            return disp;
        }
        return null;
    }

    @Override
    public IPickable getPicker(Object obj) {
        for (IPyroDisplayMgr<?> mgr : this.d_allManagers) {
            IPickable picker;
            if (!mgr.isManagerOf(obj) || (picker = mgr.getPicker(obj)) == null) continue;
            return picker;
        }
        return obj instanceof IPickable ? (IPickable)obj : null;
    }

    @Override
    public boolean isManagerOf(Object obj) {
        for (IPyroDisplayMgr<?> mgr : this.d_allManagers) {
            if (!mgr.isManagerOf(obj)) continue;
            return true;
        }
        return false;
    }

    public void updateDisplays(Object ... objs) {
        this.updateDisplays((Collection<?>)Arrays.asList(objs));
    }

    @Override
    public void updateDisplays(Collection<?> objs) {
        for (IPyroDisplayMgr<?> mgr : this.d_allManagers) {
            mgr.updateDisplays(theUtil.filter(objs, mgr.getObjFilter().toArbitraryPredicate()));
        }
    }

    @Override
    public Function<RenderTarget, Optional<ModelScene>> getScenes() {
        return t -> {
            switch (t) {
                case NORMAL: {
                    return Optional.of(this.d_scene);
                }
            }
            return Optional.empty();
        };
    }

    private IPyroDisplayMgr getFirstMgr(Object o) {
        for (IPyroDisplayMgr<?> mgr : this.d_allManagers) {
            if (!mgr.getObjFilter().toArbitraryPredicate().test(o)) continue;
            return mgr;
        }
        return null;
    }

    @Override
    public void addDisplays(Collection<? extends Object> objs) {
        for (Object object : objs) {
            IPyroDisplayMgr mgr = this.getFirstMgr(object);
            if (mgr == null) continue;
            mgr.addDisplays(Arrays.asList(object));
        }
    }

    @Override
    public void removeDisplays(Collection<? extends Object> objs) {
        for (Object object : objs) {
            IPyroDisplayMgr mgr = this.getFirstMgr(object);
            if (mgr == null) continue;
            mgr.removeDisplays(Arrays.asList(object));
        }
    }

    @Override
    public void updateAll() {
        for (IPyroDisplayMgr mgr : this.getDispManagers()) {
            mgr.updateAll();
        }
    }

    @Override
    public ITransformPreview getTransformPreview(IDisplayMgr<? super Object> copyMgr, Collection<? extends Object> objs, boolean copyMode) {
        assert (copyMgr instanceof DisplayManager);
        if (!(copyMgr instanceof DisplayManager)) {
            throw new UnsupportedOperationException();
        }
        DisplayManager copyDispMgr = (DisplayManager)copyMgr;
        ArrayList<ITransformPreview> transformers = new ArrayList<ITransformPreview>();
        assert (this.d_allManagers.length == copyDispMgr.d_allManagers.length);
        for (int m = 0; m < this.d_allManagers.length; ++m) {
            IPyroDisplayMgr<?> mgr = this.d_allManagers[m];
            Predicate test = mgr.getObjFilter().toArbitraryPredicate();
            IFilteredCollection<? extends Object> fobjs = theUtil.filter(objs, test);
            if (fobjs.isEmpty()) continue;
            ITransformPreview xformer = this.d_allManagers[m].getTransformPreview(copyDispMgr.d_allManagers[m], fobjs, copyMode);
            transformers.add(xformer);
        }
        if (transformers.size() == 1) {
            return (ITransformPreview)transformers.get(0);
        }
        return new CompositeTransformPreview(transformers);
    }
}

