/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import pyrosim.legacy_2012_1.util.ITransformer;
import pyrosim.legacy_2012_1.util.TransformIterator;

public class TransformedCollection<OType, TType>
extends AbstractCollection<TType> {
    private final Collection<OType> d_collection;
    private final ITransformer<OType, TType> d_transformer;
    private final ITransformer<TType, OType> d_invTransformer;
    private final Class<TType> d_transformedType;

    public TransformedCollection(Collection<OType> collection, ITransformer<OType, TType> transformer) {
        this(collection, transformer, null, null);
    }

    public TransformedCollection(Collection<OType> collection, ITransformer<OType, TType> transformer, ITransformer<TType, OType> invTransformer, Class<TType> transformedType) {
        this.d_collection = collection;
        this.d_transformer = transformer;
        this.d_invTransformer = invTransformer;
        this.d_transformedType = transformedType;
        assert (this.d_invTransformer == null || this.d_transformedType != null);
    }

    @Override
    public Iterator<TType> iterator() {
        return new TransformIterator<OType, TType>(this.d_collection.iterator(), this.d_transformer);
    }

    @Override
    public boolean add(TType e) {
        if (this.d_invTransformer != null) {
            return this.d_collection.add(this.d_invTransformer.transform(e));
        }
        return super.add(e);
    }

    @Override
    public boolean remove(Object o) {
        if (this.d_invTransformer != null) {
            if (o == null) {
                return this.d_collection.remove(null);
            }
            if (this.d_transformedType.isInstance(o)) {
                return this.d_collection.remove(this.d_invTransformer.transform(o));
            }
            return false;
        }
        return super.remove(o);
    }

    @Override
    public boolean contains(Object o) {
        if (this.d_invTransformer != null) {
            if (o == null) {
                return this.d_collection.contains(null);
            }
            if (this.d_transformedType.isInstance(o)) {
                return this.d_collection.contains(this.d_invTransformer.transform(o));
            }
            return false;
        }
        return super.contains(o);
    }

    @Override
    public boolean isEmpty() {
        return this.d_collection.isEmpty();
    }

    @Override
    public int size() {
        return this.d_collection.size();
    }

    @Override
    public void clear() {
        this.d_collection.clear();
    }
}

