/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.util;

import java.util.Collection;
import java.util.HashSet;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class GeomUtil {
    public static IDOF getDOF(Collection<? extends IPyroGeomSrc> geoms) {
        HashSet<IDOF> dofs = new HashSet<IDOF>();
        for (IPyroGeomSrc iPyroGeomSrc : geoms) {
            dofs.add(iPyroGeomSrc.getGeom().getDOF());
        }
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil.groupDOFs(dofs);
    }

    public static AABox getBounds(Collection<? extends IPyroGeomSrc> objects) {
        AABox bb = new AABox();
        for (IPyroGeomSrc iPyroGeomSrc : objects) {
            iPyroGeomSrc.getGeom().getBoundingBox(bb);
        }
        return bb;
    }

    public static UnitAABox getUnitBounds(Collection<? extends IPyroGeomSrc> objects) {
        AABox bb = GeomUtil.getBounds(objects);
        return new UnitAABox(bb, Geometry.LU);
    }

    public static UnitPoint3D getCenter(Collection<? extends IPyroGeomSrc> objects) {
        Unit lu = Geometry.LU;
        AABox bb = GeomUtil.getBounds(objects);
        Point3d min = bb.getMin();
        Point3d max = bb.getMax();
        min.add(max);
        min.scale(0.5);
        return new UnitPoint3D(min, lu);
    }

    public static boolean isAligned(IDOF dof) {
        if (dof == IDOF.ALIGNED) {
            return true;
        }
        if (dof instanceof IDOF.CompositeDOF) {
            IDOF.CompositeDOF group = (IDOF.CompositeDOF)dof;
            for (IDOF iDOF : group.dofs) {
                if (!GeomUtil.isAligned(iDOF)) continue;
                return true;
            }
        }
        return false;
    }
}

