/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.unitsystem;

import org.jscience.physics.units.Unit;

public abstract class UnitSystem {
    public static final int LENGTH = 0;
    public static final int TEMP = 1;
    public static final int TIME = 2;
    public static final int RTI = 3;
    public static final int DENSITY = 4;
    public static final int ATM_GRAD = 5;
    public static final int ACCEL = 6;
    public static final int AMBIENT_PRESSURE = 7;
    public static final int VELOCITY = 8;
    public static final int SMALL_LENGTH = 9;
    public static final int SPEC_ENERGY = 10;
    public static final int SPEC_HEAT = 11;
    public static final int PIPE_PRESSURE = 12;
    public static final int ABSORPTION_COEFFICIENT = 13;
    public static final int ENERGY_PER_MOL = 15;
    public static final int VISIBILITY = 16;
    public static final int MOLECULAR_WEIGHT = 17;
    public static final int MASS_FRACTION = 18;
    public static final int CONDUCTIVITY = 19;
    public static final int BURNING_RATE = 20;
    public static final int EXTINGUISHING_COEFFICIENT = 21;
    public static final int HRRPUA = 22;
    public static final int SURFACE_DENSITY = 23;
    public static final int VOLUME_FLUX = 24;
    public static final int HRRPUV = 25;
    public static final int MIXTURE_FRACTION = 26;
    public static final int DIFFUSION = 27;
    public static final int ANGLE = 29;
    public static final int UNITLESS = 28;
    public static final int VOLUME_FLOW_RATE = 30;
    public static final int OBSCURATION = 31;
    public static final int CONCENTRATION = 32;
    public static final int HEAT_FLUX = 33;
    public static final int KAPPA0 = 34;
    public static final int DIVERGENCE = 35;
    public static final int H = 36;
    public static final int HEAT = 37;
    public static final int MASS_FLOW_RATE = 38;
    public static final int PRESSURE = 39;
    public static final int SOOT_DENSITY = 40;
    public static final int VISCOSITY = 41;
    public static final int LJ_SIGMA = 42;
    public static final int LJ_EPSILONK = 43;
    public static final int MLRPUA = 44;
    public static final int MASS_FLUX = 45;
    public static final int HEAT_OF_VAPORIZATION = 46;
    public static final int HEAT_OF_REACTION = 47;
    public static final int HEAT_OF_COMBUSTION = 48;
    public static final int REAC_PRE_EXP_FACTOR = 50;
    public static final int EXTINCTION_COEFFICIENT = 51;
    public static final int MASS_EXTINCTION_COEFFICIENT = 52;
    public static final int REAC_REF_RATE = 53;
    public static final int ACTIVATION_ENERGY = 54;
    public static final int DROPLET_DENSITY = 55;
    public static final int VOLUME = 56;
    public static final int ASPIRATION = 57;
    public static final int K_FACTOR = 58;
    public static final int OPERATING_PRESSURE = 59;
    public static final int C_FACTOR = 60;
    public static final int PART_DIAM_UNIT = 61;
    public static final int ENTHALPY = 62;
    public static final int OPTICAL_DENSITY = 63;
    public static final int RELATIVE_HUMIDITY = 64;
    public static final int SPECIFIC_ENTHALPY = 65;
    public static final int MOMENT_OF_INERTIA = 66;
    public static final int FORCE = 67;
    public static final int SMALL_AREA = 68;
    public static final int RADIAL_DAMPING_FORCE_COEFFICIENT = 69;
    public static final int ROTATIONS_PER_SECOND = 70;
    public static final int AGENT_DENSITY = 71;
    public static final int AGENT_INSERT_RATE = 72;
    public static final int VAPOR_FLUX = 73;
    public static final int HEATING_RATE = 74;
    public static final int MASS_PER_LENGTH = 75;
    public static final int MASS_PER_TIME = 76;
    public static final int MASS = 77;
    public static final int HEAT_EXCHANGE_RATE = 78;
    public static final int AREA = 79;
    public static final int TOTAL_OBSCURATION = 80;
    public static final int CONVECTION = 81;
    public static final int PARTS_PER_MILLION = 82;
    public static final int SURFACE_DEPOSITION = 83;
    private final String d_name;

    public UnitSystem(String name) {
        this.d_name = name;
    }

    public String getSystemName() {
        return this.d_name;
    }

    public abstract Unit getUnit(int var1);

    public Unit getDiffusionUnit() {
        return this.getUnit(27);
    }

    public Unit getLengthUnit() {
        return this.getUnit(0);
    }

    public Unit getTempUnit() {
        return this.getUnit(1);
    }

    public Unit getTimeUnit() {
        return this.getUnit(2);
    }

    public Unit getRtiUnit() {
        return this.getUnit(3);
    }

    public Unit getDensityUnit() {
        return this.getUnit(4);
    }

    public Unit getAtmGradUnit() {
        return this.getUnit(5);
    }

    public Unit getAccelUnit() {
        return this.getUnit(6);
    }

    public Unit getAmbientPressureUnit() {
        return this.getUnit(7);
    }

    public Unit getVelocityUnit() {
        return this.getUnit(8);
    }

    public Unit getSmallLengthUnit() {
        return this.getUnit(9);
    }

    public Unit getSpecEnergyUnit() {
        return this.getUnit(10);
    }

    public Unit getSpecHeatUnit() {
        return this.getUnit(11);
    }

    public Unit getPipePressureUnit() {
        return this.getUnit(12);
    }

    public Unit getAbsorptionCoefficientUnit() {
        return this.getUnit(13);
    }

    public Unit getEnergyPerMolUnit() {
        return this.getUnit(15);
    }

    public Unit getVisibilityUnit() {
        return this.getUnit(16);
    }

    public Unit getMolecularWeightUnit() {
        return this.getUnit(17);
    }

    public Unit getMassFractionUnit() {
        return this.getUnit(18);
    }

    public Unit getConductivityUnit() {
        return this.getUnit(19);
    }

    public Unit getAngleUnit() {
        return this.getUnit(29);
    }

    public Unit getBurningRateUnit() {
        return this.getUnit(20);
    }

    public Unit getExtinguishingCoefficientUnit() {
        return this.getUnit(21);
    }

    public Unit getHRRPUAUnit() {
        return this.getUnit(22);
    }

    public Unit getHRRPUVUnit() {
        return this.getUnit(25);
    }

    public Unit getSurfaceDensityUnit() {
        return this.getUnit(23);
    }

    public Unit getVolumeFluxUnit() {
        return this.getUnit(24);
    }

    public Unit getMixFracUnit() {
        return this.getUnit(26);
    }

    public Unit getKappa0Unit() {
        return this.getUnit(34);
    }

    public Unit getObscurationUnit() {
        return this.getUnit(31);
    }

    public Unit getMassFlowrateUnit() {
        return this.getUnit(38);
    }

    public Unit getVolumeFlowrateUnit() {
        return this.getUnit(30);
    }

    public Unit getUnitlessUnit() {
        return this.getUnit(28);
    }

    public Unit getConcentrationUnit() {
        return this.getUnit(32);
    }

    public Unit getViscosityUnit() {
        return this.getUnit(41);
    }

    public Unit getLJSigmaUnit() {
        return this.getUnit(42);
    }

    public Unit getLJEpsilonKUnit() {
        return this.getUnit(43);
    }

    public Unit getHeatFlux() {
        return this.getUnit(33);
    }

    public Unit getMLRPUA() {
        return this.getUnit(44);
    }

    public Unit getHeatOfVaporization() {
        return this.getUnit(46);
    }

    public Unit getHeatOfReaction() {
        return this.getUnit(47);
    }

    public Unit getHeatOfCombustion() {
        return this.getUnit(48);
    }

    public Unit getActivationEnergy() {
        return this.getUnit(54);
    }

    public Unit getReacRate() {
        return this.getUnit(53);
    }

    public Unit getMassExtinctionCoeff() {
        return this.getUnit(52);
    }

    public Unit getDropletDensity() {
        return this.getUnit(55);
    }

    public Unit getMomentOfInertia() {
        return this.getUnit(66);
    }

    public Unit getForce() {
        return this.getUnit(67);
    }

    public Unit getAgentInsertRate() {
        return this.getUnit(72);
    }

    public Unit getHeatExchangeRate() {
        return this.getUnit(78);
    }

    public Unit getMass() {
        return this.getUnit(77);
    }

    public Unit getArea() {
        return this.getUnit(79);
    }

    public Unit getEnthalpyUnit() {
        return this.getUnit(62);
    }

    public Unit getSpecEnthalpyUnit() {
        return this.getUnit(65);
    }
}

